/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.csip.v20221121.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeSubUserInfoResponse extends AbstractModel {

    /**
    * total
    */
    @SerializedName("TotalCount")
    @Expose
    private Long TotalCount;

    /**
    * Sub-user list
    */
    @SerializedName("Data")
    @Expose
    private SubUserInfo [] Data;

    /**
    * Manufacturer Enumeration List
    */
    @SerializedName("CloudTypeLst")
    @Expose
    private FilterDataObject [] CloudTypeLst;

    /**
    * Enumeration of appid of the main account
    */
    @SerializedName("OwnerAppIDLst")
    @Expose
    private FilterDataObject [] OwnerAppIDLst;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get total 
     * @return TotalCount total
     */
    public Long getTotalCount() {
        return this.TotalCount;
    }

    /**
     * Set total
     * @param TotalCount total
     */
    public void setTotalCount(Long TotalCount) {
        this.TotalCount = TotalCount;
    }

    /**
     * Get Sub-user list 
     * @return Data Sub-user list
     */
    public SubUserInfo [] getData() {
        return this.Data;
    }

    /**
     * Set Sub-user list
     * @param Data Sub-user list
     */
    public void setData(SubUserInfo [] Data) {
        this.Data = Data;
    }

    /**
     * Get Manufacturer Enumeration List 
     * @return CloudTypeLst Manufacturer Enumeration List
     */
    public FilterDataObject [] getCloudTypeLst() {
        return this.CloudTypeLst;
    }

    /**
     * Set Manufacturer Enumeration List
     * @param CloudTypeLst Manufacturer Enumeration List
     */
    public void setCloudTypeLst(FilterDataObject [] CloudTypeLst) {
        this.CloudTypeLst = CloudTypeLst;
    }

    /**
     * Get Enumeration of appid of the main account 
     * @return OwnerAppIDLst Enumeration of appid of the main account
     */
    public FilterDataObject [] getOwnerAppIDLst() {
        return this.OwnerAppIDLst;
    }

    /**
     * Set Enumeration of appid of the main account
     * @param OwnerAppIDLst Enumeration of appid of the main account
     */
    public void setOwnerAppIDLst(FilterDataObject [] OwnerAppIDLst) {
        this.OwnerAppIDLst = OwnerAppIDLst;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeSubUserInfoResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeSubUserInfoResponse(DescribeSubUserInfoResponse source) {
        if (source.TotalCount != null) {
            this.TotalCount = new Long(source.TotalCount);
        }
        if (source.Data != null) {
            this.Data = new SubUserInfo[source.Data.length];
            for (int i = 0; i < source.Data.length; i++) {
                this.Data[i] = new SubUserInfo(source.Data[i]);
            }
        }
        if (source.CloudTypeLst != null) {
            this.CloudTypeLst = new FilterDataObject[source.CloudTypeLst.length];
            for (int i = 0; i < source.CloudTypeLst.length; i++) {
                this.CloudTypeLst[i] = new FilterDataObject(source.CloudTypeLst[i]);
            }
        }
        if (source.OwnerAppIDLst != null) {
            this.OwnerAppIDLst = new FilterDataObject[source.OwnerAppIDLst.length];
            for (int i = 0; i < source.OwnerAppIDLst.length; i++) {
                this.OwnerAppIDLst[i] = new FilterDataObject(source.OwnerAppIDLst[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "TotalCount", this.TotalCount);
        this.setParamArrayObj(map, prefix + "Data.", this.Data);
        this.setParamArrayObj(map, prefix + "CloudTypeLst.", this.CloudTypeLst);
        this.setParamArrayObj(map, prefix + "OwnerAppIDLst.", this.OwnerAppIDLst);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

