/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.csip.v20221121.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeTaskLogListResponse extends AbstractModel {

    /**
    * Total number of entries
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("TotalCount")
    @Expose
    private Long TotalCount;

    /**
    * List of reports
Note: This field may return·null, indicating that no valid values can be obtained.
    */
    @SerializedName("Data")
    @Expose
    private TaskLogInfo [] Data;

    /**
    * Number of reports pending viewed
Note: This field may return·null, indicating that no valid values can be obtained.
    */
    @SerializedName("NotViewNumber")
    @Expose
    private Long NotViewNumber;

    /**
    * Number of report templates
Note: This field may return·null, indicating that no valid values can be obtained.
    */
    @SerializedName("ReportTemplateNumber")
    @Expose
    private Long ReportTemplateNumber;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Total number of entries
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return TotalCount Total number of entries
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getTotalCount() {
        return this.TotalCount;
    }

    /**
     * Set Total number of entries
Note: This field may return null, indicating that no valid values can be obtained.
     * @param TotalCount Total number of entries
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setTotalCount(Long TotalCount) {
        this.TotalCount = TotalCount;
    }

    /**
     * Get List of reports
Note: This field may return·null, indicating that no valid values can be obtained. 
     * @return Data List of reports
Note: This field may return·null, indicating that no valid values can be obtained.
     */
    public TaskLogInfo [] getData() {
        return this.Data;
    }

    /**
     * Set List of reports
Note: This field may return·null, indicating that no valid values can be obtained.
     * @param Data List of reports
Note: This field may return·null, indicating that no valid values can be obtained.
     */
    public void setData(TaskLogInfo [] Data) {
        this.Data = Data;
    }

    /**
     * Get Number of reports pending viewed
Note: This field may return·null, indicating that no valid values can be obtained. 
     * @return NotViewNumber Number of reports pending viewed
Note: This field may return·null, indicating that no valid values can be obtained.
     */
    public Long getNotViewNumber() {
        return this.NotViewNumber;
    }

    /**
     * Set Number of reports pending viewed
Note: This field may return·null, indicating that no valid values can be obtained.
     * @param NotViewNumber Number of reports pending viewed
Note: This field may return·null, indicating that no valid values can be obtained.
     */
    public void setNotViewNumber(Long NotViewNumber) {
        this.NotViewNumber = NotViewNumber;
    }

    /**
     * Get Number of report templates
Note: This field may return·null, indicating that no valid values can be obtained. 
     * @return ReportTemplateNumber Number of report templates
Note: This field may return·null, indicating that no valid values can be obtained.
     */
    public Long getReportTemplateNumber() {
        return this.ReportTemplateNumber;
    }

    /**
     * Set Number of report templates
Note: This field may return·null, indicating that no valid values can be obtained.
     * @param ReportTemplateNumber Number of report templates
Note: This field may return·null, indicating that no valid values can be obtained.
     */
    public void setReportTemplateNumber(Long ReportTemplateNumber) {
        this.ReportTemplateNumber = ReportTemplateNumber;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeTaskLogListResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeTaskLogListResponse(DescribeTaskLogListResponse source) {
        if (source.TotalCount != null) {
            this.TotalCount = new Long(source.TotalCount);
        }
        if (source.Data != null) {
            this.Data = new TaskLogInfo[source.Data.length];
            for (int i = 0; i < source.Data.length; i++) {
                this.Data[i] = new TaskLogInfo(source.Data[i]);
            }
        }
        if (source.NotViewNumber != null) {
            this.NotViewNumber = new Long(source.NotViewNumber);
        }
        if (source.ReportTemplateNumber != null) {
            this.ReportTemplateNumber = new Long(source.ReportTemplateNumber);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "TotalCount", this.TotalCount);
        this.setParamArrayObj(map, prefix + "Data.", this.Data);
        this.setParamSimple(map, prefix + "NotViewNumber", this.NotViewNumber);
        this.setParamSimple(map, prefix + "ReportTemplateNumber", this.ReportTemplateNumber);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

