/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cvm.v20170312.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class ConvertOperatingSystemsResponse extends AbstractModel {

    /**
    * Information about the target operating system, which is returned only when the input parameter DryRun is true.
Note: This field may return null, indicating that no valid value is found.
    */
    @SerializedName("SupportTargetOSList")
    @Expose
    private TargetOS [] SupportTargetOSList;

    /**
    * Task ID for operating system switching.
Note: This field may return null, indicating that no valid value is found.
    */
    @SerializedName("TaskId")
    @Expose
    private String TaskId;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Information about the target operating system, which is returned only when the input parameter DryRun is true.
Note: This field may return null, indicating that no valid value is found. 
     * @return SupportTargetOSList Information about the target operating system, which is returned only when the input parameter DryRun is true.
Note: This field may return null, indicating that no valid value is found.
     */
    public TargetOS [] getSupportTargetOSList() {
        return this.SupportTargetOSList;
    }

    /**
     * Set Information about the target operating system, which is returned only when the input parameter DryRun is true.
Note: This field may return null, indicating that no valid value is found.
     * @param SupportTargetOSList Information about the target operating system, which is returned only when the input parameter DryRun is true.
Note: This field may return null, indicating that no valid value is found.
     */
    public void setSupportTargetOSList(TargetOS [] SupportTargetOSList) {
        this.SupportTargetOSList = SupportTargetOSList;
    }

    /**
     * Get Task ID for operating system switching.
Note: This field may return null, indicating that no valid value is found. 
     * @return TaskId Task ID for operating system switching.
Note: This field may return null, indicating that no valid value is found.
     */
    public String getTaskId() {
        return this.TaskId;
    }

    /**
     * Set Task ID for operating system switching.
Note: This field may return null, indicating that no valid value is found.
     * @param TaskId Task ID for operating system switching.
Note: This field may return null, indicating that no valid value is found.
     */
    public void setTaskId(String TaskId) {
        this.TaskId = TaskId;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public ConvertOperatingSystemsResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public ConvertOperatingSystemsResponse(ConvertOperatingSystemsResponse source) {
        if (source.SupportTargetOSList != null) {
            this.SupportTargetOSList = new TargetOS[source.SupportTargetOSList.length];
            for (int i = 0; i < source.SupportTargetOSList.length; i++) {
                this.SupportTargetOSList[i] = new TargetOS(source.SupportTargetOSList[i]);
            }
        }
        if (source.TaskId != null) {
            this.TaskId = new String(source.TaskId);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "SupportTargetOSList.", this.SupportTargetOSList);
        this.setParamSimple(map, prefix + "TaskId", this.TaskId);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

