/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class AddLoginWhiteListsRequest extends AbstractModel {

    /**
    * Cross-region log-in allowlist entity
    */
    @SerializedName("HostLoginWhiteObj")
    @Expose
    private HostLoginWhiteObj HostLoginWhiteObj;

    /**
    * Synchronous event processing method:
"": do not process"All": add all events that match this configuration to the allowlist"Id": add the event corresponding to the event ID to the allowlist
    */
    @SerializedName("ProcessType")
    @Expose
    private String ProcessType;

    /**
    * Cross-region log-in event ID. This parameter is required when ProcessType is set to Id.
    */
    @SerializedName("EventId")
    @Expose
    private Long EventId;

    /**
     * Get Cross-region log-in allowlist entity 
     * @return HostLoginWhiteObj Cross-region log-in allowlist entity
     */
    public HostLoginWhiteObj getHostLoginWhiteObj() {
        return this.HostLoginWhiteObj;
    }

    /**
     * Set Cross-region log-in allowlist entity
     * @param HostLoginWhiteObj Cross-region log-in allowlist entity
     */
    public void setHostLoginWhiteObj(HostLoginWhiteObj HostLoginWhiteObj) {
        this.HostLoginWhiteObj = HostLoginWhiteObj;
    }

    /**
     * Get Synchronous event processing method:
"": do not process"All": add all events that match this configuration to the allowlist"Id": add the event corresponding to the event ID to the allowlist 
     * @return ProcessType Synchronous event processing method:
"": do not process"All": add all events that match this configuration to the allowlist"Id": add the event corresponding to the event ID to the allowlist
     */
    public String getProcessType() {
        return this.ProcessType;
    }

    /**
     * Set Synchronous event processing method:
"": do not process"All": add all events that match this configuration to the allowlist"Id": add the event corresponding to the event ID to the allowlist
     * @param ProcessType Synchronous event processing method:
"": do not process"All": add all events that match this configuration to the allowlist"Id": add the event corresponding to the event ID to the allowlist
     */
    public void setProcessType(String ProcessType) {
        this.ProcessType = ProcessType;
    }

    /**
     * Get Cross-region log-in event ID. This parameter is required when ProcessType is set to Id. 
     * @return EventId Cross-region log-in event ID. This parameter is required when ProcessType is set to Id.
     */
    public Long getEventId() {
        return this.EventId;
    }

    /**
     * Set Cross-region log-in event ID. This parameter is required when ProcessType is set to Id.
     * @param EventId Cross-region log-in event ID. This parameter is required when ProcessType is set to Id.
     */
    public void setEventId(Long EventId) {
        this.EventId = EventId;
    }

    public AddLoginWhiteListsRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public AddLoginWhiteListsRequest(AddLoginWhiteListsRequest source) {
        if (source.HostLoginWhiteObj != null) {
            this.HostLoginWhiteObj = new HostLoginWhiteObj(source.HostLoginWhiteObj);
        }
        if (source.ProcessType != null) {
            this.ProcessType = new String(source.ProcessType);
        }
        if (source.EventId != null) {
            this.EventId = new Long(source.EventId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamObj(map, prefix + "HostLoginWhiteObj.", this.HostLoginWhiteObj);
        this.setParamSimple(map, prefix + "ProcessType", this.ProcessType);
        this.setParamSimple(map, prefix + "EventId", this.EventId);

    }
}

