/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class CreateBanWhiteListResponse extends AbstractModel {

    /**
    * Whether a global rule
    */
    @SerializedName("IsGlobal")
    @Expose
    private Boolean IsGlobal;

    /**
    * Whether the addition of a rule would result in a duplicate
    */
    @SerializedName("IsDuplicate")
    @Expose
    private Boolean IsDuplicate;

    /**
    * Information on duplicate machines
    */
    @SerializedName("DuplicateHosts")
    @Expose
    private DuplicateHosts [] DuplicateHosts;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Whether a global rule 
     * @return IsGlobal Whether a global rule
     */
    public Boolean getIsGlobal() {
        return this.IsGlobal;
    }

    /**
     * Set Whether a global rule
     * @param IsGlobal Whether a global rule
     */
    public void setIsGlobal(Boolean IsGlobal) {
        this.IsGlobal = IsGlobal;
    }

    /**
     * Get Whether the addition of a rule would result in a duplicate 
     * @return IsDuplicate Whether the addition of a rule would result in a duplicate
     */
    public Boolean getIsDuplicate() {
        return this.IsDuplicate;
    }

    /**
     * Set Whether the addition of a rule would result in a duplicate
     * @param IsDuplicate Whether the addition of a rule would result in a duplicate
     */
    public void setIsDuplicate(Boolean IsDuplicate) {
        this.IsDuplicate = IsDuplicate;
    }

    /**
     * Get Information on duplicate machines 
     * @return DuplicateHosts Information on duplicate machines
     */
    public DuplicateHosts [] getDuplicateHosts() {
        return this.DuplicateHosts;
    }

    /**
     * Set Information on duplicate machines
     * @param DuplicateHosts Information on duplicate machines
     */
    public void setDuplicateHosts(DuplicateHosts [] DuplicateHosts) {
        this.DuplicateHosts = DuplicateHosts;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public CreateBanWhiteListResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public CreateBanWhiteListResponse(CreateBanWhiteListResponse source) {
        if (source.IsGlobal != null) {
            this.IsGlobal = new Boolean(source.IsGlobal);
        }
        if (source.IsDuplicate != null) {
            this.IsDuplicate = new Boolean(source.IsDuplicate);
        }
        if (source.DuplicateHosts != null) {
            this.DuplicateHosts = new DuplicateHosts[source.DuplicateHosts.length];
            for (int i = 0; i < source.DuplicateHosts.length; i++) {
                this.DuplicateHosts[i] = new DuplicateHosts(source.DuplicateHosts[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "IsGlobal", this.IsGlobal);
        this.setParamSimple(map, prefix + "IsDuplicate", this.IsDuplicate);
        this.setParamArrayObj(map, prefix + "DuplicateHosts.", this.DuplicateHosts);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

