/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeAssetInfoResponse extends AbstractModel {

    /**
    * Number of Hosts
    */
    @SerializedName("MachineCount")
    @Expose
    private Long MachineCount;

    /**
    * Number of Accounts
    */
    @SerializedName("AccountCount")
    @Expose
    private Long AccountCount;

    /**
    * Number of ports
    */
    @SerializedName("PortCount")
    @Expose
    private Long PortCount;

    /**
    * Number of Processes
    */
    @SerializedName("ProcessCount")
    @Expose
    private Long ProcessCount;

    /**
    * Number of software
    */
    @SerializedName("SoftwareCount")
    @Expose
    private Long SoftwareCount;

    /**
    * Number of databases
    */
    @SerializedName("DatabaseCount")
    @Expose
    private Long DatabaseCount;

    /**
    * Number of web applications
    */
    @SerializedName("WebAppCount")
    @Expose
    private Long WebAppCount;

    /**
    * Number of web frameworks
    */
    @SerializedName("WebFrameCount")
    @Expose
    private Long WebFrameCount;

    /**
    * Number of web services
    */
    @SerializedName("WebServiceCount")
    @Expose
    private Long WebServiceCount;

    /**
    * Number of web sites
    */
    @SerializedName("WebLocationCount")
    @Expose
    private Long WebLocationCount;

    /**
    * New accounts today
    */
    @SerializedName("AccountNewCount")
    @Expose
    private Long AccountNewCount;

    /**
    * New ports today
    */
    @SerializedName("PortNewCount")
    @Expose
    private Long PortNewCount;

    /**
    * New processes today
    */
    @SerializedName("ProcessNewCount")
    @Expose
    private Long ProcessNewCount;

    /**
    * New software today
    */
    @SerializedName("SoftwareNewCount")
    @Expose
    private Long SoftwareNewCount;

    /**
    * New databases today
    */
    @SerializedName("DatabaseNewCount")
    @Expose
    private Long DatabaseNewCount;

    /**
    * New web applications today
    */
    @SerializedName("WebAppNewCount")
    @Expose
    private Long WebAppNewCount;

    /**
    * New web frameworks today
    */
    @SerializedName("WebFrameNewCount")
    @Expose
    private Long WebFrameNewCount;

    /**
    * New web services today
    */
    @SerializedName("WebServiceNewCount")
    @Expose
    private Long WebServiceNewCount;

    /**
    * New web sites today
    */
    @SerializedName("WebLocationNewCount")
    @Expose
    private Long WebLocationNewCount;

    /**
    * New hosts today
    */
    @SerializedName("MachineNewCount")
    @Expose
    private Long MachineNewCount;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Number of Hosts 
     * @return MachineCount Number of Hosts
     */
    public Long getMachineCount() {
        return this.MachineCount;
    }

    /**
     * Set Number of Hosts
     * @param MachineCount Number of Hosts
     */
    public void setMachineCount(Long MachineCount) {
        this.MachineCount = MachineCount;
    }

    /**
     * Get Number of Accounts 
     * @return AccountCount Number of Accounts
     */
    public Long getAccountCount() {
        return this.AccountCount;
    }

    /**
     * Set Number of Accounts
     * @param AccountCount Number of Accounts
     */
    public void setAccountCount(Long AccountCount) {
        this.AccountCount = AccountCount;
    }

    /**
     * Get Number of ports 
     * @return PortCount Number of ports
     */
    public Long getPortCount() {
        return this.PortCount;
    }

    /**
     * Set Number of ports
     * @param PortCount Number of ports
     */
    public void setPortCount(Long PortCount) {
        this.PortCount = PortCount;
    }

    /**
     * Get Number of Processes 
     * @return ProcessCount Number of Processes
     */
    public Long getProcessCount() {
        return this.ProcessCount;
    }

    /**
     * Set Number of Processes
     * @param ProcessCount Number of Processes
     */
    public void setProcessCount(Long ProcessCount) {
        this.ProcessCount = ProcessCount;
    }

    /**
     * Get Number of software 
     * @return SoftwareCount Number of software
     */
    public Long getSoftwareCount() {
        return this.SoftwareCount;
    }

    /**
     * Set Number of software
     * @param SoftwareCount Number of software
     */
    public void setSoftwareCount(Long SoftwareCount) {
        this.SoftwareCount = SoftwareCount;
    }

    /**
     * Get Number of databases 
     * @return DatabaseCount Number of databases
     */
    public Long getDatabaseCount() {
        return this.DatabaseCount;
    }

    /**
     * Set Number of databases
     * @param DatabaseCount Number of databases
     */
    public void setDatabaseCount(Long DatabaseCount) {
        this.DatabaseCount = DatabaseCount;
    }

    /**
     * Get Number of web applications 
     * @return WebAppCount Number of web applications
     */
    public Long getWebAppCount() {
        return this.WebAppCount;
    }

    /**
     * Set Number of web applications
     * @param WebAppCount Number of web applications
     */
    public void setWebAppCount(Long WebAppCount) {
        this.WebAppCount = WebAppCount;
    }

    /**
     * Get Number of web frameworks 
     * @return WebFrameCount Number of web frameworks
     */
    public Long getWebFrameCount() {
        return this.WebFrameCount;
    }

    /**
     * Set Number of web frameworks
     * @param WebFrameCount Number of web frameworks
     */
    public void setWebFrameCount(Long WebFrameCount) {
        this.WebFrameCount = WebFrameCount;
    }

    /**
     * Get Number of web services 
     * @return WebServiceCount Number of web services
     */
    public Long getWebServiceCount() {
        return this.WebServiceCount;
    }

    /**
     * Set Number of web services
     * @param WebServiceCount Number of web services
     */
    public void setWebServiceCount(Long WebServiceCount) {
        this.WebServiceCount = WebServiceCount;
    }

    /**
     * Get Number of web sites 
     * @return WebLocationCount Number of web sites
     */
    public Long getWebLocationCount() {
        return this.WebLocationCount;
    }

    /**
     * Set Number of web sites
     * @param WebLocationCount Number of web sites
     */
    public void setWebLocationCount(Long WebLocationCount) {
        this.WebLocationCount = WebLocationCount;
    }

    /**
     * Get New accounts today 
     * @return AccountNewCount New accounts today
     */
    public Long getAccountNewCount() {
        return this.AccountNewCount;
    }

    /**
     * Set New accounts today
     * @param AccountNewCount New accounts today
     */
    public void setAccountNewCount(Long AccountNewCount) {
        this.AccountNewCount = AccountNewCount;
    }

    /**
     * Get New ports today 
     * @return PortNewCount New ports today
     */
    public Long getPortNewCount() {
        return this.PortNewCount;
    }

    /**
     * Set New ports today
     * @param PortNewCount New ports today
     */
    public void setPortNewCount(Long PortNewCount) {
        this.PortNewCount = PortNewCount;
    }

    /**
     * Get New processes today 
     * @return ProcessNewCount New processes today
     */
    public Long getProcessNewCount() {
        return this.ProcessNewCount;
    }

    /**
     * Set New processes today
     * @param ProcessNewCount New processes today
     */
    public void setProcessNewCount(Long ProcessNewCount) {
        this.ProcessNewCount = ProcessNewCount;
    }

    /**
     * Get New software today 
     * @return SoftwareNewCount New software today
     */
    public Long getSoftwareNewCount() {
        return this.SoftwareNewCount;
    }

    /**
     * Set New software today
     * @param SoftwareNewCount New software today
     */
    public void setSoftwareNewCount(Long SoftwareNewCount) {
        this.SoftwareNewCount = SoftwareNewCount;
    }

    /**
     * Get New databases today 
     * @return DatabaseNewCount New databases today
     */
    public Long getDatabaseNewCount() {
        return this.DatabaseNewCount;
    }

    /**
     * Set New databases today
     * @param DatabaseNewCount New databases today
     */
    public void setDatabaseNewCount(Long DatabaseNewCount) {
        this.DatabaseNewCount = DatabaseNewCount;
    }

    /**
     * Get New web applications today 
     * @return WebAppNewCount New web applications today
     */
    public Long getWebAppNewCount() {
        return this.WebAppNewCount;
    }

    /**
     * Set New web applications today
     * @param WebAppNewCount New web applications today
     */
    public void setWebAppNewCount(Long WebAppNewCount) {
        this.WebAppNewCount = WebAppNewCount;
    }

    /**
     * Get New web frameworks today 
     * @return WebFrameNewCount New web frameworks today
     */
    public Long getWebFrameNewCount() {
        return this.WebFrameNewCount;
    }

    /**
     * Set New web frameworks today
     * @param WebFrameNewCount New web frameworks today
     */
    public void setWebFrameNewCount(Long WebFrameNewCount) {
        this.WebFrameNewCount = WebFrameNewCount;
    }

    /**
     * Get New web services today 
     * @return WebServiceNewCount New web services today
     */
    public Long getWebServiceNewCount() {
        return this.WebServiceNewCount;
    }

    /**
     * Set New web services today
     * @param WebServiceNewCount New web services today
     */
    public void setWebServiceNewCount(Long WebServiceNewCount) {
        this.WebServiceNewCount = WebServiceNewCount;
    }

    /**
     * Get New web sites today 
     * @return WebLocationNewCount New web sites today
     */
    public Long getWebLocationNewCount() {
        return this.WebLocationNewCount;
    }

    /**
     * Set New web sites today
     * @param WebLocationNewCount New web sites today
     */
    public void setWebLocationNewCount(Long WebLocationNewCount) {
        this.WebLocationNewCount = WebLocationNewCount;
    }

    /**
     * Get New hosts today 
     * @return MachineNewCount New hosts today
     */
    public Long getMachineNewCount() {
        return this.MachineNewCount;
    }

    /**
     * Set New hosts today
     * @param MachineNewCount New hosts today
     */
    public void setMachineNewCount(Long MachineNewCount) {
        this.MachineNewCount = MachineNewCount;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeAssetInfoResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeAssetInfoResponse(DescribeAssetInfoResponse source) {
        if (source.MachineCount != null) {
            this.MachineCount = new Long(source.MachineCount);
        }
        if (source.AccountCount != null) {
            this.AccountCount = new Long(source.AccountCount);
        }
        if (source.PortCount != null) {
            this.PortCount = new Long(source.PortCount);
        }
        if (source.ProcessCount != null) {
            this.ProcessCount = new Long(source.ProcessCount);
        }
        if (source.SoftwareCount != null) {
            this.SoftwareCount = new Long(source.SoftwareCount);
        }
        if (source.DatabaseCount != null) {
            this.DatabaseCount = new Long(source.DatabaseCount);
        }
        if (source.WebAppCount != null) {
            this.WebAppCount = new Long(source.WebAppCount);
        }
        if (source.WebFrameCount != null) {
            this.WebFrameCount = new Long(source.WebFrameCount);
        }
        if (source.WebServiceCount != null) {
            this.WebServiceCount = new Long(source.WebServiceCount);
        }
        if (source.WebLocationCount != null) {
            this.WebLocationCount = new Long(source.WebLocationCount);
        }
        if (source.AccountNewCount != null) {
            this.AccountNewCount = new Long(source.AccountNewCount);
        }
        if (source.PortNewCount != null) {
            this.PortNewCount = new Long(source.PortNewCount);
        }
        if (source.ProcessNewCount != null) {
            this.ProcessNewCount = new Long(source.ProcessNewCount);
        }
        if (source.SoftwareNewCount != null) {
            this.SoftwareNewCount = new Long(source.SoftwareNewCount);
        }
        if (source.DatabaseNewCount != null) {
            this.DatabaseNewCount = new Long(source.DatabaseNewCount);
        }
        if (source.WebAppNewCount != null) {
            this.WebAppNewCount = new Long(source.WebAppNewCount);
        }
        if (source.WebFrameNewCount != null) {
            this.WebFrameNewCount = new Long(source.WebFrameNewCount);
        }
        if (source.WebServiceNewCount != null) {
            this.WebServiceNewCount = new Long(source.WebServiceNewCount);
        }
        if (source.WebLocationNewCount != null) {
            this.WebLocationNewCount = new Long(source.WebLocationNewCount);
        }
        if (source.MachineNewCount != null) {
            this.MachineNewCount = new Long(source.MachineNewCount);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "MachineCount", this.MachineCount);
        this.setParamSimple(map, prefix + "AccountCount", this.AccountCount);
        this.setParamSimple(map, prefix + "PortCount", this.PortCount);
        this.setParamSimple(map, prefix + "ProcessCount", this.ProcessCount);
        this.setParamSimple(map, prefix + "SoftwareCount", this.SoftwareCount);
        this.setParamSimple(map, prefix + "DatabaseCount", this.DatabaseCount);
        this.setParamSimple(map, prefix + "WebAppCount", this.WebAppCount);
        this.setParamSimple(map, prefix + "WebFrameCount", this.WebFrameCount);
        this.setParamSimple(map, prefix + "WebServiceCount", this.WebServiceCount);
        this.setParamSimple(map, prefix + "WebLocationCount", this.WebLocationCount);
        this.setParamSimple(map, prefix + "AccountNewCount", this.AccountNewCount);
        this.setParamSimple(map, prefix + "PortNewCount", this.PortNewCount);
        this.setParamSimple(map, prefix + "ProcessNewCount", this.ProcessNewCount);
        this.setParamSimple(map, prefix + "SoftwareNewCount", this.SoftwareNewCount);
        this.setParamSimple(map, prefix + "DatabaseNewCount", this.DatabaseNewCount);
        this.setParamSimple(map, prefix + "WebAppNewCount", this.WebAppNewCount);
        this.setParamSimple(map, prefix + "WebFrameNewCount", this.WebFrameNewCount);
        this.setParamSimple(map, prefix + "WebServiceNewCount", this.WebServiceNewCount);
        this.setParamSimple(map, prefix + "WebLocationNewCount", this.WebLocationNewCount);
        this.setParamSimple(map, prefix + "MachineNewCount", this.MachineNewCount);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

