/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeAssetLoadInfoResponse extends AbstractModel {

    /**
    * System load
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("CpuLoad")
    @Expose
    private AssetLoadSummary CpuLoad;

    /**
    * Memory utilization
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("MemLoad")
    @Expose
    private AssetLoadSummary MemLoad;

    /**
    * Hard disk utilization
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("DiskLoad")
    @Expose
    private AssetLoadSummary DiskLoad;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get System load
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return CpuLoad System load
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public AssetLoadSummary getCpuLoad() {
        return this.CpuLoad;
    }

    /**
     * Set System load
Note: This field may return null, indicating that no valid values can be obtained.
     * @param CpuLoad System load
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setCpuLoad(AssetLoadSummary CpuLoad) {
        this.CpuLoad = CpuLoad;
    }

    /**
     * Get Memory utilization
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return MemLoad Memory utilization
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public AssetLoadSummary getMemLoad() {
        return this.MemLoad;
    }

    /**
     * Set Memory utilization
Note: This field may return null, indicating that no valid values can be obtained.
     * @param MemLoad Memory utilization
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setMemLoad(AssetLoadSummary MemLoad) {
        this.MemLoad = MemLoad;
    }

    /**
     * Get Hard disk utilization
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return DiskLoad Hard disk utilization
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public AssetLoadSummary getDiskLoad() {
        return this.DiskLoad;
    }

    /**
     * Set Hard disk utilization
Note: This field may return null, indicating that no valid values can be obtained.
     * @param DiskLoad Hard disk utilization
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setDiskLoad(AssetLoadSummary DiskLoad) {
        this.DiskLoad = DiskLoad;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeAssetLoadInfoResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeAssetLoadInfoResponse(DescribeAssetLoadInfoResponse source) {
        if (source.CpuLoad != null) {
            this.CpuLoad = new AssetLoadSummary(source.CpuLoad);
        }
        if (source.MemLoad != null) {
            this.MemLoad = new AssetLoadSummary(source.MemLoad);
        }
        if (source.DiskLoad != null) {
            this.DiskLoad = new AssetLoadSummary(source.DiskLoad);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamObj(map, prefix + "CpuLoad.", this.CpuLoad);
        this.setParamObj(map, prefix + "MemLoad.", this.MemLoad);
        this.setParamObj(map, prefix + "DiskLoad.", this.DiskLoad);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

