/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeAssetTypeTopResponse extends AbstractModel {

    /**
    * Top 5 accounts
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("User")
    @Expose
    private AssetKeyVal [] User;

    /**
    * Top 5 ports
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Port")
    @Expose
    private AssetKeyVal [] Port;

    /**
    * Top 5 processes
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Process")
    @Expose
    private AssetKeyVal [] Process;

    /**
    * Top 5 software
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Software")
    @Expose
    private AssetKeyVal [] Software;

    /**
    * Top 5 databases
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Database")
    @Expose
    private AssetKeyVal [] Database;

    /**
    * Top 5 web applications
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("WebApp")
    @Expose
    private AssetKeyVal [] WebApp;

    /**
    * Top 5 web sites
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("WebLocation")
    @Expose
    private AssetKeyVal [] WebLocation;

    /**
    * Top 5 web frameworks
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("WebFrame")
    @Expose
    private AssetKeyVal [] WebFrame;

    /**
    * Top 5 web services
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("WebService")
    @Expose
    private AssetKeyVal [] WebService;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Top 5 accounts
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return User Top 5 accounts
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public AssetKeyVal [] getUser() {
        return this.User;
    }

    /**
     * Set Top 5 accounts
Note: This field may return null, indicating that no valid values can be obtained.
     * @param User Top 5 accounts
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setUser(AssetKeyVal [] User) {
        this.User = User;
    }

    /**
     * Get Top 5 ports
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return Port Top 5 ports
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public AssetKeyVal [] getPort() {
        return this.Port;
    }

    /**
     * Set Top 5 ports
Note: This field may return null, indicating that no valid values can be obtained.
     * @param Port Top 5 ports
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setPort(AssetKeyVal [] Port) {
        this.Port = Port;
    }

    /**
     * Get Top 5 processes
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return Process Top 5 processes
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public AssetKeyVal [] getProcess() {
        return this.Process;
    }

    /**
     * Set Top 5 processes
Note: This field may return null, indicating that no valid values can be obtained.
     * @param Process Top 5 processes
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setProcess(AssetKeyVal [] Process) {
        this.Process = Process;
    }

    /**
     * Get Top 5 software
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return Software Top 5 software
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public AssetKeyVal [] getSoftware() {
        return this.Software;
    }

    /**
     * Set Top 5 software
Note: This field may return null, indicating that no valid values can be obtained.
     * @param Software Top 5 software
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setSoftware(AssetKeyVal [] Software) {
        this.Software = Software;
    }

    /**
     * Get Top 5 databases
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return Database Top 5 databases
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public AssetKeyVal [] getDatabase() {
        return this.Database;
    }

    /**
     * Set Top 5 databases
Note: This field may return null, indicating that no valid values can be obtained.
     * @param Database Top 5 databases
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setDatabase(AssetKeyVal [] Database) {
        this.Database = Database;
    }

    /**
     * Get Top 5 web applications
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return WebApp Top 5 web applications
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public AssetKeyVal [] getWebApp() {
        return this.WebApp;
    }

    /**
     * Set Top 5 web applications
Note: This field may return null, indicating that no valid values can be obtained.
     * @param WebApp Top 5 web applications
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setWebApp(AssetKeyVal [] WebApp) {
        this.WebApp = WebApp;
    }

    /**
     * Get Top 5 web sites
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return WebLocation Top 5 web sites
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public AssetKeyVal [] getWebLocation() {
        return this.WebLocation;
    }

    /**
     * Set Top 5 web sites
Note: This field may return null, indicating that no valid values can be obtained.
     * @param WebLocation Top 5 web sites
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setWebLocation(AssetKeyVal [] WebLocation) {
        this.WebLocation = WebLocation;
    }

    /**
     * Get Top 5 web frameworks
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return WebFrame Top 5 web frameworks
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public AssetKeyVal [] getWebFrame() {
        return this.WebFrame;
    }

    /**
     * Set Top 5 web frameworks
Note: This field may return null, indicating that no valid values can be obtained.
     * @param WebFrame Top 5 web frameworks
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setWebFrame(AssetKeyVal [] WebFrame) {
        this.WebFrame = WebFrame;
    }

    /**
     * Get Top 5 web services
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return WebService Top 5 web services
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public AssetKeyVal [] getWebService() {
        return this.WebService;
    }

    /**
     * Set Top 5 web services
Note: This field may return null, indicating that no valid values can be obtained.
     * @param WebService Top 5 web services
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setWebService(AssetKeyVal [] WebService) {
        this.WebService = WebService;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeAssetTypeTopResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeAssetTypeTopResponse(DescribeAssetTypeTopResponse source) {
        if (source.User != null) {
            this.User = new AssetKeyVal[source.User.length];
            for (int i = 0; i < source.User.length; i++) {
                this.User[i] = new AssetKeyVal(source.User[i]);
            }
        }
        if (source.Port != null) {
            this.Port = new AssetKeyVal[source.Port.length];
            for (int i = 0; i < source.Port.length; i++) {
                this.Port[i] = new AssetKeyVal(source.Port[i]);
            }
        }
        if (source.Process != null) {
            this.Process = new AssetKeyVal[source.Process.length];
            for (int i = 0; i < source.Process.length; i++) {
                this.Process[i] = new AssetKeyVal(source.Process[i]);
            }
        }
        if (source.Software != null) {
            this.Software = new AssetKeyVal[source.Software.length];
            for (int i = 0; i < source.Software.length; i++) {
                this.Software[i] = new AssetKeyVal(source.Software[i]);
            }
        }
        if (source.Database != null) {
            this.Database = new AssetKeyVal[source.Database.length];
            for (int i = 0; i < source.Database.length; i++) {
                this.Database[i] = new AssetKeyVal(source.Database[i]);
            }
        }
        if (source.WebApp != null) {
            this.WebApp = new AssetKeyVal[source.WebApp.length];
            for (int i = 0; i < source.WebApp.length; i++) {
                this.WebApp[i] = new AssetKeyVal(source.WebApp[i]);
            }
        }
        if (source.WebLocation != null) {
            this.WebLocation = new AssetKeyVal[source.WebLocation.length];
            for (int i = 0; i < source.WebLocation.length; i++) {
                this.WebLocation[i] = new AssetKeyVal(source.WebLocation[i]);
            }
        }
        if (source.WebFrame != null) {
            this.WebFrame = new AssetKeyVal[source.WebFrame.length];
            for (int i = 0; i < source.WebFrame.length; i++) {
                this.WebFrame[i] = new AssetKeyVal(source.WebFrame[i]);
            }
        }
        if (source.WebService != null) {
            this.WebService = new AssetKeyVal[source.WebService.length];
            for (int i = 0; i < source.WebService.length; i++) {
                this.WebService[i] = new AssetKeyVal(source.WebService[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "User.", this.User);
        this.setParamArrayObj(map, prefix + "Port.", this.Port);
        this.setParamArrayObj(map, prefix + "Process.", this.Process);
        this.setParamArrayObj(map, prefix + "Software.", this.Software);
        this.setParamArrayObj(map, prefix + "Database.", this.Database);
        this.setParamArrayObj(map, prefix + "WebApp.", this.WebApp);
        this.setParamArrayObj(map, prefix + "WebLocation.", this.WebLocation);
        this.setParamArrayObj(map, prefix + "WebFrame.", this.WebFrame);
        this.setParamArrayObj(map, prefix + "WebService.", this.WebService);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

