/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeAttackStatisticsResponse extends AbstractModel {

    /**
    * Total Number of Attacks
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("PendingAttackCount")
    @Expose
    private Long PendingAttackCount;

    /**
    * Total Attack Attempts
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("PendingTryAttackCount")
    @Expose
    private Long PendingTryAttackCount;

    /**
    * Total Number of Successful Attacks
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("PendingSuccAttackCount")
    @Expose
    private Long PendingSuccAttackCount;

    /**
    * Number of New Attacks Today
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("PendingNewAttackCount")
    @Expose
    private Long PendingNewAttackCount;

    /**
    * Total Number of Assets Under Attack
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("AttackedAssetCount")
    @Expose
    private Long AttackedAssetCount;

    /**
    * Number of New Attacked Assets Today
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("NewAttackedAssetCount")
    @Expose
    private Long NewAttackedAssetCount;

    /**
    * Total Number of Attacked Ports
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("AttackedPortCount")
    @Expose
    private Long AttackedPortCount;

    /**
    * Number of New Attacked Ports Today
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("NewAttackedPortCount")
    @Expose
    private Long NewAttackedPortCount;

    /**
    * Total Number of Attack Source IPs
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("AttackSrcIpCount")
    @Expose
    private Long AttackSrcIpCount;

    /**
    * Number of New Attacking Source IPs Today
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("NewAttackSrcIpCount")
    @Expose
    private Long NewAttackSrcIpCount;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Total Number of Attacks
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return PendingAttackCount Total Number of Attacks
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getPendingAttackCount() {
        return this.PendingAttackCount;
    }

    /**
     * Set Total Number of Attacks
Note: This field may return null, indicating that no valid values can be obtained.
     * @param PendingAttackCount Total Number of Attacks
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setPendingAttackCount(Long PendingAttackCount) {
        this.PendingAttackCount = PendingAttackCount;
    }

    /**
     * Get Total Attack Attempts
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return PendingTryAttackCount Total Attack Attempts
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getPendingTryAttackCount() {
        return this.PendingTryAttackCount;
    }

    /**
     * Set Total Attack Attempts
Note: This field may return null, indicating that no valid values can be obtained.
     * @param PendingTryAttackCount Total Attack Attempts
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setPendingTryAttackCount(Long PendingTryAttackCount) {
        this.PendingTryAttackCount = PendingTryAttackCount;
    }

    /**
     * Get Total Number of Successful Attacks
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return PendingSuccAttackCount Total Number of Successful Attacks
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getPendingSuccAttackCount() {
        return this.PendingSuccAttackCount;
    }

    /**
     * Set Total Number of Successful Attacks
Note: This field may return null, indicating that no valid values can be obtained.
     * @param PendingSuccAttackCount Total Number of Successful Attacks
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setPendingSuccAttackCount(Long PendingSuccAttackCount) {
        this.PendingSuccAttackCount = PendingSuccAttackCount;
    }

    /**
     * Get Number of New Attacks Today
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return PendingNewAttackCount Number of New Attacks Today
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getPendingNewAttackCount() {
        return this.PendingNewAttackCount;
    }

    /**
     * Set Number of New Attacks Today
Note: This field may return null, indicating that no valid values can be obtained.
     * @param PendingNewAttackCount Number of New Attacks Today
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setPendingNewAttackCount(Long PendingNewAttackCount) {
        this.PendingNewAttackCount = PendingNewAttackCount;
    }

    /**
     * Get Total Number of Assets Under Attack
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return AttackedAssetCount Total Number of Assets Under Attack
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getAttackedAssetCount() {
        return this.AttackedAssetCount;
    }

    /**
     * Set Total Number of Assets Under Attack
Note: This field may return null, indicating that no valid values can be obtained.
     * @param AttackedAssetCount Total Number of Assets Under Attack
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setAttackedAssetCount(Long AttackedAssetCount) {
        this.AttackedAssetCount = AttackedAssetCount;
    }

    /**
     * Get Number of New Attacked Assets Today
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return NewAttackedAssetCount Number of New Attacked Assets Today
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getNewAttackedAssetCount() {
        return this.NewAttackedAssetCount;
    }

    /**
     * Set Number of New Attacked Assets Today
Note: This field may return null, indicating that no valid values can be obtained.
     * @param NewAttackedAssetCount Number of New Attacked Assets Today
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setNewAttackedAssetCount(Long NewAttackedAssetCount) {
        this.NewAttackedAssetCount = NewAttackedAssetCount;
    }

    /**
     * Get Total Number of Attacked Ports
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return AttackedPortCount Total Number of Attacked Ports
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getAttackedPortCount() {
        return this.AttackedPortCount;
    }

    /**
     * Set Total Number of Attacked Ports
Note: This field may return null, indicating that no valid values can be obtained.
     * @param AttackedPortCount Total Number of Attacked Ports
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setAttackedPortCount(Long AttackedPortCount) {
        this.AttackedPortCount = AttackedPortCount;
    }

    /**
     * Get Number of New Attacked Ports Today
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return NewAttackedPortCount Number of New Attacked Ports Today
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getNewAttackedPortCount() {
        return this.NewAttackedPortCount;
    }

    /**
     * Set Number of New Attacked Ports Today
Note: This field may return null, indicating that no valid values can be obtained.
     * @param NewAttackedPortCount Number of New Attacked Ports Today
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setNewAttackedPortCount(Long NewAttackedPortCount) {
        this.NewAttackedPortCount = NewAttackedPortCount;
    }

    /**
     * Get Total Number of Attack Source IPs
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return AttackSrcIpCount Total Number of Attack Source IPs
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getAttackSrcIpCount() {
        return this.AttackSrcIpCount;
    }

    /**
     * Set Total Number of Attack Source IPs
Note: This field may return null, indicating that no valid values can be obtained.
     * @param AttackSrcIpCount Total Number of Attack Source IPs
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setAttackSrcIpCount(Long AttackSrcIpCount) {
        this.AttackSrcIpCount = AttackSrcIpCount;
    }

    /**
     * Get Number of New Attacking Source IPs Today
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return NewAttackSrcIpCount Number of New Attacking Source IPs Today
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getNewAttackSrcIpCount() {
        return this.NewAttackSrcIpCount;
    }

    /**
     * Set Number of New Attacking Source IPs Today
Note: This field may return null, indicating that no valid values can be obtained.
     * @param NewAttackSrcIpCount Number of New Attacking Source IPs Today
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setNewAttackSrcIpCount(Long NewAttackSrcIpCount) {
        this.NewAttackSrcIpCount = NewAttackSrcIpCount;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeAttackStatisticsResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeAttackStatisticsResponse(DescribeAttackStatisticsResponse source) {
        if (source.PendingAttackCount != null) {
            this.PendingAttackCount = new Long(source.PendingAttackCount);
        }
        if (source.PendingTryAttackCount != null) {
            this.PendingTryAttackCount = new Long(source.PendingTryAttackCount);
        }
        if (source.PendingSuccAttackCount != null) {
            this.PendingSuccAttackCount = new Long(source.PendingSuccAttackCount);
        }
        if (source.PendingNewAttackCount != null) {
            this.PendingNewAttackCount = new Long(source.PendingNewAttackCount);
        }
        if (source.AttackedAssetCount != null) {
            this.AttackedAssetCount = new Long(source.AttackedAssetCount);
        }
        if (source.NewAttackedAssetCount != null) {
            this.NewAttackedAssetCount = new Long(source.NewAttackedAssetCount);
        }
        if (source.AttackedPortCount != null) {
            this.AttackedPortCount = new Long(source.AttackedPortCount);
        }
        if (source.NewAttackedPortCount != null) {
            this.NewAttackedPortCount = new Long(source.NewAttackedPortCount);
        }
        if (source.AttackSrcIpCount != null) {
            this.AttackSrcIpCount = new Long(source.AttackSrcIpCount);
        }
        if (source.NewAttackSrcIpCount != null) {
            this.NewAttackSrcIpCount = new Long(source.NewAttackSrcIpCount);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "PendingAttackCount", this.PendingAttackCount);
        this.setParamSimple(map, prefix + "PendingTryAttackCount", this.PendingTryAttackCount);
        this.setParamSimple(map, prefix + "PendingSuccAttackCount", this.PendingSuccAttackCount);
        this.setParamSimple(map, prefix + "PendingNewAttackCount", this.PendingNewAttackCount);
        this.setParamSimple(map, prefix + "AttackedAssetCount", this.AttackedAssetCount);
        this.setParamSimple(map, prefix + "NewAttackedAssetCount", this.NewAttackedAssetCount);
        this.setParamSimple(map, prefix + "AttackedPortCount", this.AttackedPortCount);
        this.setParamSimple(map, prefix + "NewAttackedPortCount", this.NewAttackedPortCount);
        this.setParamSimple(map, prefix + "AttackSrcIpCount", this.AttackSrcIpCount);
        this.setParamSimple(map, prefix + "NewAttackSrcIpCount", this.NewAttackSrcIpCount);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

