/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeAvailableExpertServiceDetailResponse extends AbstractModel {

    /**
    * Security manager order
    */
    @SerializedName("ExpertService")
    @Expose
    private ExpertServiceOrderInfo [] ExpertService;

    /**
    * Number of available emergency responses
    */
    @SerializedName("EmergencyResponse")
    @Expose
    private Long EmergencyResponse;

    /**
    * 
    */
    @SerializedName("ProtectNet")
    @Expose
    private Long ProtectNet;

    /**
    * Whether you purchased security manager
    */
    @SerializedName("ExpertServiceBuy")
    @Expose
    private Boolean ExpertServiceBuy;

    /**
    * Whether you purchased emergency response
    */
    @SerializedName("EmergencyResponseBuy")
    @Expose
    private Boolean EmergencyResponseBuy;

    /**
    * 
    */
    @SerializedName("ProtectNetBuy")
    @Expose
    private Boolean ProtectNetBuy;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Security manager order 
     * @return ExpertService Security manager order
     */
    public ExpertServiceOrderInfo [] getExpertService() {
        return this.ExpertService;
    }

    /**
     * Set Security manager order
     * @param ExpertService Security manager order
     */
    public void setExpertService(ExpertServiceOrderInfo [] ExpertService) {
        this.ExpertService = ExpertService;
    }

    /**
     * Get Number of available emergency responses 
     * @return EmergencyResponse Number of available emergency responses
     */
    public Long getEmergencyResponse() {
        return this.EmergencyResponse;
    }

    /**
     * Set Number of available emergency responses
     * @param EmergencyResponse Number of available emergency responses
     */
    public void setEmergencyResponse(Long EmergencyResponse) {
        this.EmergencyResponse = EmergencyResponse;
    }

    /**
     * Get  
     * @return ProtectNet 
     */
    public Long getProtectNet() {
        return this.ProtectNet;
    }

    /**
     * Set 
     * @param ProtectNet 
     */
    public void setProtectNet(Long ProtectNet) {
        this.ProtectNet = ProtectNet;
    }

    /**
     * Get Whether you purchased security manager 
     * @return ExpertServiceBuy Whether you purchased security manager
     */
    public Boolean getExpertServiceBuy() {
        return this.ExpertServiceBuy;
    }

    /**
     * Set Whether you purchased security manager
     * @param ExpertServiceBuy Whether you purchased security manager
     */
    public void setExpertServiceBuy(Boolean ExpertServiceBuy) {
        this.ExpertServiceBuy = ExpertServiceBuy;
    }

    /**
     * Get Whether you purchased emergency response 
     * @return EmergencyResponseBuy Whether you purchased emergency response
     */
    public Boolean getEmergencyResponseBuy() {
        return this.EmergencyResponseBuy;
    }

    /**
     * Set Whether you purchased emergency response
     * @param EmergencyResponseBuy Whether you purchased emergency response
     */
    public void setEmergencyResponseBuy(Boolean EmergencyResponseBuy) {
        this.EmergencyResponseBuy = EmergencyResponseBuy;
    }

    /**
     * Get  
     * @return ProtectNetBuy 
     */
    public Boolean getProtectNetBuy() {
        return this.ProtectNetBuy;
    }

    /**
     * Set 
     * @param ProtectNetBuy 
     */
    public void setProtectNetBuy(Boolean ProtectNetBuy) {
        this.ProtectNetBuy = ProtectNetBuy;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeAvailableExpertServiceDetailResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeAvailableExpertServiceDetailResponse(DescribeAvailableExpertServiceDetailResponse source) {
        if (source.ExpertService != null) {
            this.ExpertService = new ExpertServiceOrderInfo[source.ExpertService.length];
            for (int i = 0; i < source.ExpertService.length; i++) {
                this.ExpertService[i] = new ExpertServiceOrderInfo(source.ExpertService[i]);
            }
        }
        if (source.EmergencyResponse != null) {
            this.EmergencyResponse = new Long(source.EmergencyResponse);
        }
        if (source.ProtectNet != null) {
            this.ProtectNet = new Long(source.ProtectNet);
        }
        if (source.ExpertServiceBuy != null) {
            this.ExpertServiceBuy = new Boolean(source.ExpertServiceBuy);
        }
        if (source.EmergencyResponseBuy != null) {
            this.EmergencyResponseBuy = new Boolean(source.EmergencyResponseBuy);
        }
        if (source.ProtectNetBuy != null) {
            this.ProtectNetBuy = new Boolean(source.ProtectNetBuy);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "ExpertService.", this.ExpertService);
        this.setParamSimple(map, prefix + "EmergencyResponse", this.EmergencyResponse);
        this.setParamSimple(map, prefix + "ProtectNet", this.ProtectNet);
        this.setParamSimple(map, prefix + "ExpertServiceBuy", this.ExpertServiceBuy);
        this.setParamSimple(map, prefix + "EmergencyResponseBuy", this.EmergencyResponseBuy);
        this.setParamSimple(map, prefix + "ProtectNetBuy", this.ProtectNetBuy);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

