/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeBanStatusResponse extends AbstractModel {

    /**
    * Blocking enabling status:
0: disabled 
1: advanced blocking
2: basic blocking (block only malicious IP addresses in the intelligence database)
    */
    @SerializedName("Status")
    @Expose
    private Long Status;

    /**
    * Whether to display the pop-up prompt. False: no; true: yes.
    */
    @SerializedName("ShowTips")
    @Expose
    private Boolean ShowTips;

    /**
    * Whether to enable intelligent over-allowing mode
    */
    @SerializedName("OpenSmartMode")
    @Expose
    private Boolean OpenSmartMode;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Blocking enabling status:
0: disabled 
1: advanced blocking
2: basic blocking (block only malicious IP addresses in the intelligence database) 
     * @return Status Blocking enabling status:
0: disabled 
1: advanced blocking
2: basic blocking (block only malicious IP addresses in the intelligence database)
     */
    public Long getStatus() {
        return this.Status;
    }

    /**
     * Set Blocking enabling status:
0: disabled 
1: advanced blocking
2: basic blocking (block only malicious IP addresses in the intelligence database)
     * @param Status Blocking enabling status:
0: disabled 
1: advanced blocking
2: basic blocking (block only malicious IP addresses in the intelligence database)
     */
    public void setStatus(Long Status) {
        this.Status = Status;
    }

    /**
     * Get Whether to display the pop-up prompt. False: no; true: yes. 
     * @return ShowTips Whether to display the pop-up prompt. False: no; true: yes.
     */
    public Boolean getShowTips() {
        return this.ShowTips;
    }

    /**
     * Set Whether to display the pop-up prompt. False: no; true: yes.
     * @param ShowTips Whether to display the pop-up prompt. False: no; true: yes.
     */
    public void setShowTips(Boolean ShowTips) {
        this.ShowTips = ShowTips;
    }

    /**
     * Get Whether to enable intelligent over-allowing mode 
     * @return OpenSmartMode Whether to enable intelligent over-allowing mode
     */
    public Boolean getOpenSmartMode() {
        return this.OpenSmartMode;
    }

    /**
     * Set Whether to enable intelligent over-allowing mode
     * @param OpenSmartMode Whether to enable intelligent over-allowing mode
     */
    public void setOpenSmartMode(Boolean OpenSmartMode) {
        this.OpenSmartMode = OpenSmartMode;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeBanStatusResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeBanStatusResponse(DescribeBanStatusResponse source) {
        if (source.Status != null) {
            this.Status = new Long(source.Status);
        }
        if (source.ShowTips != null) {
            this.ShowTips = new Boolean(source.ShowTips);
        }
        if (source.OpenSmartMode != null) {
            this.OpenSmartMode = new Boolean(source.OpenSmartMode);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Status", this.Status);
        this.setParamSimple(map, prefix + "ShowTips", this.ShowTips);
        this.setParamSimple(map, prefix + "OpenSmartMode", this.OpenSmartMode);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

