/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeBaselineHostTopResponse extends AbstractModel {

    /**
    * Top host baseline policy events
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("BaselineHostTopList")
    @Expose
    private BaselineHostTopList [] BaselineHostTopList;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Top host baseline policy events
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return BaselineHostTopList Top host baseline policy events
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public BaselineHostTopList [] getBaselineHostTopList() {
        return this.BaselineHostTopList;
    }

    /**
     * Set Top host baseline policy events
Note: This field may return null, indicating that no valid values can be obtained.
     * @param BaselineHostTopList Top host baseline policy events
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setBaselineHostTopList(BaselineHostTopList [] BaselineHostTopList) {
        this.BaselineHostTopList = BaselineHostTopList;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeBaselineHostTopResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeBaselineHostTopResponse(DescribeBaselineHostTopResponse source) {
        if (source.BaselineHostTopList != null) {
            this.BaselineHostTopList = new BaselineHostTopList[source.BaselineHostTopList.length];
            for (int i = 0; i < source.BaselineHostTopList.length; i++) {
                this.BaselineHostTopList[i] = new BaselineHostTopList(source.BaselineHostTopList[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "BaselineHostTopList.", this.BaselineHostTopList);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

