/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeBaselineStrategyDetailResponse extends AbstractModel {

    /**
    * Policy scan pass rate
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("PassRate")
    @Expose
    private Long PassRate;

    /**
    * Policy name
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("StrategyName")
    @Expose
    private String StrategyName;

    /**
    * policy scan cycle (days)
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("ScanCycle")
    @Expose
    private String ScanCycle;

    /**
    * Regular scan time. The scan task is triggered at this time.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("ScanAt")
    @Expose
    private String ScanAt;

    /**
    * Whether all hosts are scanned. 1: yes; 0: no. If the value is 1, all Pro Edition hosts are scanned.Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("IsGlobal")
    @Expose
    private Long IsGlobal;

    /**
    * Machine type:
cvm: Tencent Cloud Virtual Machine
bm: BM
ecm: Edge Computing Machine
lh: Lighthouse
other: Hybrid Cloud Machine
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("MachineType")
    @Expose
    private String MachineType;

    /**
    * Host region
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Region")
    @Expose
    private String Region;

    /**
    * IDs of all user hosts involved in this policy
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Quuids")
    @Expose
    private String [] Quuids;

    /**
    * IDs of all user baselines involved in this policy
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("CategoryIds")
    @Expose
    private String [] CategoryIds;

    /**
    * 1: scanned; 0: not scanned.Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("IfScanned")
    @Expose
    private Long IfScanned;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Policy scan pass rate
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return PassRate Policy scan pass rate
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getPassRate() {
        return this.PassRate;
    }

    /**
     * Set Policy scan pass rate
Note: This field may return null, indicating that no valid values can be obtained.
     * @param PassRate Policy scan pass rate
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setPassRate(Long PassRate) {
        this.PassRate = PassRate;
    }

    /**
     * Get Policy name
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return StrategyName Policy name
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String getStrategyName() {
        return this.StrategyName;
    }

    /**
     * Set Policy name
Note: This field may return null, indicating that no valid values can be obtained.
     * @param StrategyName Policy name
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setStrategyName(String StrategyName) {
        this.StrategyName = StrategyName;
    }

    /**
     * Get policy scan cycle (days)
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return ScanCycle policy scan cycle (days)
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String getScanCycle() {
        return this.ScanCycle;
    }

    /**
     * Set policy scan cycle (days)
Note: This field may return null, indicating that no valid values can be obtained.
     * @param ScanCycle policy scan cycle (days)
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setScanCycle(String ScanCycle) {
        this.ScanCycle = ScanCycle;
    }

    /**
     * Get Regular scan time. The scan task is triggered at this time.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return ScanAt Regular scan time. The scan task is triggered at this time.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String getScanAt() {
        return this.ScanAt;
    }

    /**
     * Set Regular scan time. The scan task is triggered at this time.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param ScanAt Regular scan time. The scan task is triggered at this time.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setScanAt(String ScanAt) {
        this.ScanAt = ScanAt;
    }

    /**
     * Get Whether all hosts are scanned. 1: yes; 0: no. If the value is 1, all Pro Edition hosts are scanned.Note: This field may return null, indicating that no valid values can be obtained. 
     * @return IsGlobal Whether all hosts are scanned. 1: yes; 0: no. If the value is 1, all Pro Edition hosts are scanned.Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getIsGlobal() {
        return this.IsGlobal;
    }

    /**
     * Set Whether all hosts are scanned. 1: yes; 0: no. If the value is 1, all Pro Edition hosts are scanned.Note: This field may return null, indicating that no valid values can be obtained.
     * @param IsGlobal Whether all hosts are scanned. 1: yes; 0: no. If the value is 1, all Pro Edition hosts are scanned.Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setIsGlobal(Long IsGlobal) {
        this.IsGlobal = IsGlobal;
    }

    /**
     * Get Machine type:
cvm: Tencent Cloud Virtual Machine
bm: BM
ecm: Edge Computing Machine
lh: Lighthouse
other: Hybrid Cloud Machine
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return MachineType Machine type:
cvm: Tencent Cloud Virtual Machine
bm: BM
ecm: Edge Computing Machine
lh: Lighthouse
other: Hybrid Cloud Machine
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String getMachineType() {
        return this.MachineType;
    }

    /**
     * Set Machine type:
cvm: Tencent Cloud Virtual Machine
bm: BM
ecm: Edge Computing Machine
lh: Lighthouse
other: Hybrid Cloud Machine
Note: This field may return null, indicating that no valid values can be obtained.
     * @param MachineType Machine type:
cvm: Tencent Cloud Virtual Machine
bm: BM
ecm: Edge Computing Machine
lh: Lighthouse
other: Hybrid Cloud Machine
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setMachineType(String MachineType) {
        this.MachineType = MachineType;
    }

    /**
     * Get Host region
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return Region Host region
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String getRegion() {
        return this.Region;
    }

    /**
     * Set Host region
Note: This field may return null, indicating that no valid values can be obtained.
     * @param Region Host region
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setRegion(String Region) {
        this.Region = Region;
    }

    /**
     * Get IDs of all user hosts involved in this policy
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return Quuids IDs of all user hosts involved in this policy
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String [] getQuuids() {
        return this.Quuids;
    }

    /**
     * Set IDs of all user hosts involved in this policy
Note: This field may return null, indicating that no valid values can be obtained.
     * @param Quuids IDs of all user hosts involved in this policy
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setQuuids(String [] Quuids) {
        this.Quuids = Quuids;
    }

    /**
     * Get IDs of all user baselines involved in this policy
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return CategoryIds IDs of all user baselines involved in this policy
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String [] getCategoryIds() {
        return this.CategoryIds;
    }

    /**
     * Set IDs of all user baselines involved in this policy
Note: This field may return null, indicating that no valid values can be obtained.
     * @param CategoryIds IDs of all user baselines involved in this policy
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setCategoryIds(String [] CategoryIds) {
        this.CategoryIds = CategoryIds;
    }

    /**
     * Get 1: scanned; 0: not scanned.Note: This field may return null, indicating that no valid values can be obtained. 
     * @return IfScanned 1: scanned; 0: not scanned.Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getIfScanned() {
        return this.IfScanned;
    }

    /**
     * Set 1: scanned; 0: not scanned.Note: This field may return null, indicating that no valid values can be obtained.
     * @param IfScanned 1: scanned; 0: not scanned.Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setIfScanned(Long IfScanned) {
        this.IfScanned = IfScanned;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeBaselineStrategyDetailResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeBaselineStrategyDetailResponse(DescribeBaselineStrategyDetailResponse source) {
        if (source.PassRate != null) {
            this.PassRate = new Long(source.PassRate);
        }
        if (source.StrategyName != null) {
            this.StrategyName = new String(source.StrategyName);
        }
        if (source.ScanCycle != null) {
            this.ScanCycle = new String(source.ScanCycle);
        }
        if (source.ScanAt != null) {
            this.ScanAt = new String(source.ScanAt);
        }
        if (source.IsGlobal != null) {
            this.IsGlobal = new Long(source.IsGlobal);
        }
        if (source.MachineType != null) {
            this.MachineType = new String(source.MachineType);
        }
        if (source.Region != null) {
            this.Region = new String(source.Region);
        }
        if (source.Quuids != null) {
            this.Quuids = new String[source.Quuids.length];
            for (int i = 0; i < source.Quuids.length; i++) {
                this.Quuids[i] = new String(source.Quuids[i]);
            }
        }
        if (source.CategoryIds != null) {
            this.CategoryIds = new String[source.CategoryIds.length];
            for (int i = 0; i < source.CategoryIds.length; i++) {
                this.CategoryIds[i] = new String(source.CategoryIds[i]);
            }
        }
        if (source.IfScanned != null) {
            this.IfScanned = new Long(source.IfScanned);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "PassRate", this.PassRate);
        this.setParamSimple(map, prefix + "StrategyName", this.StrategyName);
        this.setParamSimple(map, prefix + "ScanCycle", this.ScanCycle);
        this.setParamSimple(map, prefix + "ScanAt", this.ScanAt);
        this.setParamSimple(map, prefix + "IsGlobal", this.IsGlobal);
        this.setParamSimple(map, prefix + "MachineType", this.MachineType);
        this.setParamSimple(map, prefix + "Region", this.Region);
        this.setParamArraySimple(map, prefix + "Quuids.", this.Quuids);
        this.setParamArraySimple(map, prefix + "CategoryIds.", this.CategoryIds);
        this.setParamSimple(map, prefix + "IfScanned", this.IfScanned);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

