/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeEmergencyVulListResponse extends AbstractModel {

    /**
    * Vulnerability list
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("List")
    @Expose
    private EmergencyVul [] List;

    /**
    * Total number of vulnerabilities
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("TotalCount")
    @Expose
    private Long TotalCount;

    /**
    * Whether there is any risk
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("ExistsRisk")
    @Expose
    private Boolean ExistsRisk;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Vulnerability list
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return List Vulnerability list
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public EmergencyVul [] getList() {
        return this.List;
    }

    /**
     * Set Vulnerability list
Note: This field may return null, indicating that no valid values can be obtained.
     * @param List Vulnerability list
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setList(EmergencyVul [] List) {
        this.List = List;
    }

    /**
     * Get Total number of vulnerabilities
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return TotalCount Total number of vulnerabilities
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getTotalCount() {
        return this.TotalCount;
    }

    /**
     * Set Total number of vulnerabilities
Note: This field may return null, indicating that no valid values can be obtained.
     * @param TotalCount Total number of vulnerabilities
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setTotalCount(Long TotalCount) {
        this.TotalCount = TotalCount;
    }

    /**
     * Get Whether there is any risk
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return ExistsRisk Whether there is any risk
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Boolean getExistsRisk() {
        return this.ExistsRisk;
    }

    /**
     * Set Whether there is any risk
Note: This field may return null, indicating that no valid values can be obtained.
     * @param ExistsRisk Whether there is any risk
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setExistsRisk(Boolean ExistsRisk) {
        this.ExistsRisk = ExistsRisk;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeEmergencyVulListResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeEmergencyVulListResponse(DescribeEmergencyVulListResponse source) {
        if (source.List != null) {
            this.List = new EmergencyVul[source.List.length];
            for (int i = 0; i < source.List.length; i++) {
                this.List[i] = new EmergencyVul(source.List[i]);
            }
        }
        if (source.TotalCount != null) {
            this.TotalCount = new Long(source.TotalCount);
        }
        if (source.ExistsRisk != null) {
            this.ExistsRisk = new Boolean(source.ExistsRisk);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "List.", this.List);
        this.setParamSimple(map, prefix + "TotalCount", this.TotalCount);
        this.setParamSimple(map, prefix + "ExistsRisk", this.ExistsRisk);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

