/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeEventByTableResponse extends AbstractModel {

    /**
    * Alarm type. Bruteattack: brute force cracking; bash: high-risk command; malware: malicious file; risk_dns: malicious request; privilege_escalation: local privilege escalation; reverse_shell: reverse shell; java_shell: Java webshell.
    */
    @SerializedName("Type")
    @Expose
    private String Type;

    /**
    * JSON string of the event content. The field structure is the same as that of the event table.
    */
    @SerializedName("Value")
    @Expose
    private String Value;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Alarm type. Bruteattack: brute force cracking; bash: high-risk command; malware: malicious file; risk_dns: malicious request; privilege_escalation: local privilege escalation; reverse_shell: reverse shell; java_shell: Java webshell. 
     * @return Type Alarm type. Bruteattack: brute force cracking; bash: high-risk command; malware: malicious file; risk_dns: malicious request; privilege_escalation: local privilege escalation; reverse_shell: reverse shell; java_shell: Java webshell.
     */
    public String getType() {
        return this.Type;
    }

    /**
     * Set Alarm type. Bruteattack: brute force cracking; bash: high-risk command; malware: malicious file; risk_dns: malicious request; privilege_escalation: local privilege escalation; reverse_shell: reverse shell; java_shell: Java webshell.
     * @param Type Alarm type. Bruteattack: brute force cracking; bash: high-risk command; malware: malicious file; risk_dns: malicious request; privilege_escalation: local privilege escalation; reverse_shell: reverse shell; java_shell: Java webshell.
     */
    public void setType(String Type) {
        this.Type = Type;
    }

    /**
     * Get JSON string of the event content. The field structure is the same as that of the event table. 
     * @return Value JSON string of the event content. The field structure is the same as that of the event table.
     */
    public String getValue() {
        return this.Value;
    }

    /**
     * Set JSON string of the event content. The field structure is the same as that of the event table.
     * @param Value JSON string of the event content. The field structure is the same as that of the event table.
     */
    public void setValue(String Value) {
        this.Value = Value;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeEventByTableResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeEventByTableResponse(DescribeEventByTableResponse source) {
        if (source.Type != null) {
            this.Type = new String(source.Type);
        }
        if (source.Value != null) {
            this.Value = new String(source.Value);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Type", this.Type);
        this.setParamSimple(map, prefix + "Value", this.Value);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

