/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeGeneralStatResponse extends AbstractModel {

    /**
    * Total number of hosts
    */
    @SerializedName("MachinesAll")
    @Expose
    private Long MachinesAll;

    /**
    * Total number of hosts not installed with the CWPP client
    */
    @SerializedName("MachinesUninstalled")
    @Expose
    private Long MachinesUninstalled;

    /**
    * Total number of CWPP clients
    */
    @SerializedName("AgentsAll")
    @Expose
    private Long AgentsAll;

    /**
    * Total number of online CWPP clients
    */
    @SerializedName("AgentsOnline")
    @Expose
    private Long AgentsOnline;

    /**
    * Total number of CWPP clients that are offline and shut down
    */
    @SerializedName("AgentsOffline")
    @Expose
    private Long AgentsOffline;

    /**
    * Total number of Pro Edition CWPP clients
    */
    @SerializedName("AgentsPro")
    @Expose
    private Long AgentsPro;

    /**
    * Total number of Basic Edition CWPP clients
    */
    @SerializedName("AgentsBasic")
    @Expose
    private Long AgentsBasic;

    /**
    * Total number of prepaid Pro Edition CWPP clients that will expire in 7 days
    */
    @SerializedName("AgentsProExpireWithInSevenDays")
    @Expose
    private Long AgentsProExpireWithInSevenDays;

    /**
    * Total number of risky hosts
    */
    @SerializedName("RiskMachine")
    @Expose
    private Long RiskMachine;

    /**
    * Total number of hosts that are shut down
    */
    @SerializedName("Shutdown")
    @Expose
    private Long Shutdown;

    /**
    * Total number of offline hosts
    */
    @SerializedName("Offline")
    @Expose
    private Long Offline;

    /**
    * Number of Ultimate Edition hosts
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("FlagshipMachineCnt")
    @Expose
    private Long FlagshipMachineCnt;

    /**
    * Protection duration, in days
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("ProtectDays")
    @Expose
    private Long ProtectDays;

    /**
    * Number of hosts added in the last 15 days
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("AddedOnTheFifteen")
    @Expose
    private Long AddedOnTheFifteen;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Total number of hosts 
     * @return MachinesAll Total number of hosts
     */
    public Long getMachinesAll() {
        return this.MachinesAll;
    }

    /**
     * Set Total number of hosts
     * @param MachinesAll Total number of hosts
     */
    public void setMachinesAll(Long MachinesAll) {
        this.MachinesAll = MachinesAll;
    }

    /**
     * Get Total number of hosts not installed with the CWPP client 
     * @return MachinesUninstalled Total number of hosts not installed with the CWPP client
     */
    public Long getMachinesUninstalled() {
        return this.MachinesUninstalled;
    }

    /**
     * Set Total number of hosts not installed with the CWPP client
     * @param MachinesUninstalled Total number of hosts not installed with the CWPP client
     */
    public void setMachinesUninstalled(Long MachinesUninstalled) {
        this.MachinesUninstalled = MachinesUninstalled;
    }

    /**
     * Get Total number of CWPP clients 
     * @return AgentsAll Total number of CWPP clients
     */
    public Long getAgentsAll() {
        return this.AgentsAll;
    }

    /**
     * Set Total number of CWPP clients
     * @param AgentsAll Total number of CWPP clients
     */
    public void setAgentsAll(Long AgentsAll) {
        this.AgentsAll = AgentsAll;
    }

    /**
     * Get Total number of online CWPP clients 
     * @return AgentsOnline Total number of online CWPP clients
     */
    public Long getAgentsOnline() {
        return this.AgentsOnline;
    }

    /**
     * Set Total number of online CWPP clients
     * @param AgentsOnline Total number of online CWPP clients
     */
    public void setAgentsOnline(Long AgentsOnline) {
        this.AgentsOnline = AgentsOnline;
    }

    /**
     * Get Total number of CWPP clients that are offline and shut down 
     * @return AgentsOffline Total number of CWPP clients that are offline and shut down
     */
    public Long getAgentsOffline() {
        return this.AgentsOffline;
    }

    /**
     * Set Total number of CWPP clients that are offline and shut down
     * @param AgentsOffline Total number of CWPP clients that are offline and shut down
     */
    public void setAgentsOffline(Long AgentsOffline) {
        this.AgentsOffline = AgentsOffline;
    }

    /**
     * Get Total number of Pro Edition CWPP clients 
     * @return AgentsPro Total number of Pro Edition CWPP clients
     */
    public Long getAgentsPro() {
        return this.AgentsPro;
    }

    /**
     * Set Total number of Pro Edition CWPP clients
     * @param AgentsPro Total number of Pro Edition CWPP clients
     */
    public void setAgentsPro(Long AgentsPro) {
        this.AgentsPro = AgentsPro;
    }

    /**
     * Get Total number of Basic Edition CWPP clients 
     * @return AgentsBasic Total number of Basic Edition CWPP clients
     */
    public Long getAgentsBasic() {
        return this.AgentsBasic;
    }

    /**
     * Set Total number of Basic Edition CWPP clients
     * @param AgentsBasic Total number of Basic Edition CWPP clients
     */
    public void setAgentsBasic(Long AgentsBasic) {
        this.AgentsBasic = AgentsBasic;
    }

    /**
     * Get Total number of prepaid Pro Edition CWPP clients that will expire in 7 days 
     * @return AgentsProExpireWithInSevenDays Total number of prepaid Pro Edition CWPP clients that will expire in 7 days
     */
    public Long getAgentsProExpireWithInSevenDays() {
        return this.AgentsProExpireWithInSevenDays;
    }

    /**
     * Set Total number of prepaid Pro Edition CWPP clients that will expire in 7 days
     * @param AgentsProExpireWithInSevenDays Total number of prepaid Pro Edition CWPP clients that will expire in 7 days
     */
    public void setAgentsProExpireWithInSevenDays(Long AgentsProExpireWithInSevenDays) {
        this.AgentsProExpireWithInSevenDays = AgentsProExpireWithInSevenDays;
    }

    /**
     * Get Total number of risky hosts 
     * @return RiskMachine Total number of risky hosts
     */
    public Long getRiskMachine() {
        return this.RiskMachine;
    }

    /**
     * Set Total number of risky hosts
     * @param RiskMachine Total number of risky hosts
     */
    public void setRiskMachine(Long RiskMachine) {
        this.RiskMachine = RiskMachine;
    }

    /**
     * Get Total number of hosts that are shut down 
     * @return Shutdown Total number of hosts that are shut down
     */
    public Long getShutdown() {
        return this.Shutdown;
    }

    /**
     * Set Total number of hosts that are shut down
     * @param Shutdown Total number of hosts that are shut down
     */
    public void setShutdown(Long Shutdown) {
        this.Shutdown = Shutdown;
    }

    /**
     * Get Total number of offline hosts 
     * @return Offline Total number of offline hosts
     */
    public Long getOffline() {
        return this.Offline;
    }

    /**
     * Set Total number of offline hosts
     * @param Offline Total number of offline hosts
     */
    public void setOffline(Long Offline) {
        this.Offline = Offline;
    }

    /**
     * Get Number of Ultimate Edition hosts
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return FlagshipMachineCnt Number of Ultimate Edition hosts
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getFlagshipMachineCnt() {
        return this.FlagshipMachineCnt;
    }

    /**
     * Set Number of Ultimate Edition hosts
Note: This field may return null, indicating that no valid values can be obtained.
     * @param FlagshipMachineCnt Number of Ultimate Edition hosts
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setFlagshipMachineCnt(Long FlagshipMachineCnt) {
        this.FlagshipMachineCnt = FlagshipMachineCnt;
    }

    /**
     * Get Protection duration, in days
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return ProtectDays Protection duration, in days
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getProtectDays() {
        return this.ProtectDays;
    }

    /**
     * Set Protection duration, in days
Note: This field may return null, indicating that no valid values can be obtained.
     * @param ProtectDays Protection duration, in days
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setProtectDays(Long ProtectDays) {
        this.ProtectDays = ProtectDays;
    }

    /**
     * Get Number of hosts added in the last 15 days
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return AddedOnTheFifteen Number of hosts added in the last 15 days
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getAddedOnTheFifteen() {
        return this.AddedOnTheFifteen;
    }

    /**
     * Set Number of hosts added in the last 15 days
Note: This field may return null, indicating that no valid values can be obtained.
     * @param AddedOnTheFifteen Number of hosts added in the last 15 days
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setAddedOnTheFifteen(Long AddedOnTheFifteen) {
        this.AddedOnTheFifteen = AddedOnTheFifteen;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeGeneralStatResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeGeneralStatResponse(DescribeGeneralStatResponse source) {
        if (source.MachinesAll != null) {
            this.MachinesAll = new Long(source.MachinesAll);
        }
        if (source.MachinesUninstalled != null) {
            this.MachinesUninstalled = new Long(source.MachinesUninstalled);
        }
        if (source.AgentsAll != null) {
            this.AgentsAll = new Long(source.AgentsAll);
        }
        if (source.AgentsOnline != null) {
            this.AgentsOnline = new Long(source.AgentsOnline);
        }
        if (source.AgentsOffline != null) {
            this.AgentsOffline = new Long(source.AgentsOffline);
        }
        if (source.AgentsPro != null) {
            this.AgentsPro = new Long(source.AgentsPro);
        }
        if (source.AgentsBasic != null) {
            this.AgentsBasic = new Long(source.AgentsBasic);
        }
        if (source.AgentsProExpireWithInSevenDays != null) {
            this.AgentsProExpireWithInSevenDays = new Long(source.AgentsProExpireWithInSevenDays);
        }
        if (source.RiskMachine != null) {
            this.RiskMachine = new Long(source.RiskMachine);
        }
        if (source.Shutdown != null) {
            this.Shutdown = new Long(source.Shutdown);
        }
        if (source.Offline != null) {
            this.Offline = new Long(source.Offline);
        }
        if (source.FlagshipMachineCnt != null) {
            this.FlagshipMachineCnt = new Long(source.FlagshipMachineCnt);
        }
        if (source.ProtectDays != null) {
            this.ProtectDays = new Long(source.ProtectDays);
        }
        if (source.AddedOnTheFifteen != null) {
            this.AddedOnTheFifteen = new Long(source.AddedOnTheFifteen);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "MachinesAll", this.MachinesAll);
        this.setParamSimple(map, prefix + "MachinesUninstalled", this.MachinesUninstalled);
        this.setParamSimple(map, prefix + "AgentsAll", this.AgentsAll);
        this.setParamSimple(map, prefix + "AgentsOnline", this.AgentsOnline);
        this.setParamSimple(map, prefix + "AgentsOffline", this.AgentsOffline);
        this.setParamSimple(map, prefix + "AgentsPro", this.AgentsPro);
        this.setParamSimple(map, prefix + "AgentsBasic", this.AgentsBasic);
        this.setParamSimple(map, prefix + "AgentsProExpireWithInSevenDays", this.AgentsProExpireWithInSevenDays);
        this.setParamSimple(map, prefix + "RiskMachine", this.RiskMachine);
        this.setParamSimple(map, prefix + "Shutdown", this.Shutdown);
        this.setParamSimple(map, prefix + "Offline", this.Offline);
        this.setParamSimple(map, prefix + "FlagshipMachineCnt", this.FlagshipMachineCnt);
        this.setParamSimple(map, prefix + "ProtectDays", this.ProtectDays);
        this.setParamSimple(map, prefix + "AddedOnTheFifteen", this.AddedOnTheFifteen);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

