/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeHistoryServiceResponse extends AbstractModel {

    /**
    * 1: available for purchase; 2: specification adjustment only; 3: redirection to renewal management page only.
    */
    @SerializedName("BuyStatus")
    @Expose
    private Long BuyStatus;

    /**
    * Capacity purchased by the user, in GB
    */
    @SerializedName("InquireNum")
    @Expose
    private Long InquireNum;

    /**
    * Expiration time
    */
    @SerializedName("EndTime")
    @Expose
    private String EndTime;

    /**
    * Whether automatic renewal is enabled. 0: initial value; 1: enabled; 2: disabled.
    */
    @SerializedName("IsAutoOpenRenew")
    @Expose
    private Long IsAutoOpenRenew;

    /**
    * Resource ID
    */
    @SerializedName("ResourceId")
    @Expose
    private String ResourceId;

    /**
    * 0: not activated; 1: normal; 2: isolated; 3: terminated.
    */
    @SerializedName("Status")
    @Expose
    private Long Status;

    /**
    * Start time
    */
    @SerializedName("StartTime")
    @Expose
    private String StartTime;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get 1: available for purchase; 2: specification adjustment only; 3: redirection to renewal management page only. 
     * @return BuyStatus 1: available for purchase; 2: specification adjustment only; 3: redirection to renewal management page only.
     */
    public Long getBuyStatus() {
        return this.BuyStatus;
    }

    /**
     * Set 1: available for purchase; 2: specification adjustment only; 3: redirection to renewal management page only.
     * @param BuyStatus 1: available for purchase; 2: specification adjustment only; 3: redirection to renewal management page only.
     */
    public void setBuyStatus(Long BuyStatus) {
        this.BuyStatus = BuyStatus;
    }

    /**
     * Get Capacity purchased by the user, in GB 
     * @return InquireNum Capacity purchased by the user, in GB
     */
    public Long getInquireNum() {
        return this.InquireNum;
    }

    /**
     * Set Capacity purchased by the user, in GB
     * @param InquireNum Capacity purchased by the user, in GB
     */
    public void setInquireNum(Long InquireNum) {
        this.InquireNum = InquireNum;
    }

    /**
     * Get Expiration time 
     * @return EndTime Expiration time
     */
    public String getEndTime() {
        return this.EndTime;
    }

    /**
     * Set Expiration time
     * @param EndTime Expiration time
     */
    public void setEndTime(String EndTime) {
        this.EndTime = EndTime;
    }

    /**
     * Get Whether automatic renewal is enabled. 0: initial value; 1: enabled; 2: disabled. 
     * @return IsAutoOpenRenew Whether automatic renewal is enabled. 0: initial value; 1: enabled; 2: disabled.
     */
    public Long getIsAutoOpenRenew() {
        return this.IsAutoOpenRenew;
    }

    /**
     * Set Whether automatic renewal is enabled. 0: initial value; 1: enabled; 2: disabled.
     * @param IsAutoOpenRenew Whether automatic renewal is enabled. 0: initial value; 1: enabled; 2: disabled.
     */
    public void setIsAutoOpenRenew(Long IsAutoOpenRenew) {
        this.IsAutoOpenRenew = IsAutoOpenRenew;
    }

    /**
     * Get Resource ID 
     * @return ResourceId Resource ID
     */
    public String getResourceId() {
        return this.ResourceId;
    }

    /**
     * Set Resource ID
     * @param ResourceId Resource ID
     */
    public void setResourceId(String ResourceId) {
        this.ResourceId = ResourceId;
    }

    /**
     * Get 0: not activated; 1: normal; 2: isolated; 3: terminated. 
     * @return Status 0: not activated; 1: normal; 2: isolated; 3: terminated.
     */
    public Long getStatus() {
        return this.Status;
    }

    /**
     * Set 0: not activated; 1: normal; 2: isolated; 3: terminated.
     * @param Status 0: not activated; 1: normal; 2: isolated; 3: terminated.
     */
    public void setStatus(Long Status) {
        this.Status = Status;
    }

    /**
     * Get Start time 
     * @return StartTime Start time
     */
    public String getStartTime() {
        return this.StartTime;
    }

    /**
     * Set Start time
     * @param StartTime Start time
     */
    public void setStartTime(String StartTime) {
        this.StartTime = StartTime;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeHistoryServiceResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeHistoryServiceResponse(DescribeHistoryServiceResponse source) {
        if (source.BuyStatus != null) {
            this.BuyStatus = new Long(source.BuyStatus);
        }
        if (source.InquireNum != null) {
            this.InquireNum = new Long(source.InquireNum);
        }
        if (source.EndTime != null) {
            this.EndTime = new String(source.EndTime);
        }
        if (source.IsAutoOpenRenew != null) {
            this.IsAutoOpenRenew = new Long(source.IsAutoOpenRenew);
        }
        if (source.ResourceId != null) {
            this.ResourceId = new String(source.ResourceId);
        }
        if (source.Status != null) {
            this.Status = new Long(source.Status);
        }
        if (source.StartTime != null) {
            this.StartTime = new String(source.StartTime);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "BuyStatus", this.BuyStatus);
        this.setParamSimple(map, prefix + "InquireNum", this.InquireNum);
        this.setParamSimple(map, prefix + "EndTime", this.EndTime);
        this.setParamSimple(map, prefix + "IsAutoOpenRenew", this.IsAutoOpenRenew);
        this.setParamSimple(map, prefix + "ResourceId", this.ResourceId);
        this.setParamSimple(map, prefix + "Status", this.Status);
        this.setParamSimple(map, prefix + "StartTime", this.StartTime);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

