/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeIgnoreBaselineRuleResponse extends AbstractModel {

    /**
    * List of ignored baseline check items
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("IgnoreBaselineRuleList")
    @Expose
    private IgnoreBaselineRule [] IgnoreBaselineRuleList;

    /**
    * Total number of pagination query records
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("TotalCount")
    @Expose
    private Long TotalCount;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get List of ignored baseline check items
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return IgnoreBaselineRuleList List of ignored baseline check items
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public IgnoreBaselineRule [] getIgnoreBaselineRuleList() {
        return this.IgnoreBaselineRuleList;
    }

    /**
     * Set List of ignored baseline check items
Note: This field may return null, indicating that no valid values can be obtained.
     * @param IgnoreBaselineRuleList List of ignored baseline check items
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setIgnoreBaselineRuleList(IgnoreBaselineRule [] IgnoreBaselineRuleList) {
        this.IgnoreBaselineRuleList = IgnoreBaselineRuleList;
    }

    /**
     * Get Total number of pagination query records
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return TotalCount Total number of pagination query records
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getTotalCount() {
        return this.TotalCount;
    }

    /**
     * Set Total number of pagination query records
Note: This field may return null, indicating that no valid values can be obtained.
     * @param TotalCount Total number of pagination query records
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setTotalCount(Long TotalCount) {
        this.TotalCount = TotalCount;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeIgnoreBaselineRuleResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeIgnoreBaselineRuleResponse(DescribeIgnoreBaselineRuleResponse source) {
        if (source.IgnoreBaselineRuleList != null) {
            this.IgnoreBaselineRuleList = new IgnoreBaselineRule[source.IgnoreBaselineRuleList.length];
            for (int i = 0; i < source.IgnoreBaselineRuleList.length; i++) {
                this.IgnoreBaselineRuleList[i] = new IgnoreBaselineRule(source.IgnoreBaselineRuleList[i]);
            }
        }
        if (source.TotalCount != null) {
            this.TotalCount = new Long(source.TotalCount);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "IgnoreBaselineRuleList.", this.IgnoreBaselineRuleList);
        this.setParamSimple(map, prefix + "TotalCount", this.TotalCount);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

