/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeLicenseWhiteConfigResponse extends AbstractModel {

    /**
    * Ultimate Edition configuration information
    */
    @SerializedName("FlagShip")
    @Expose
    private VersionWhiteConfig FlagShip;

    /**
    * Pro Edition configuration information
    */
    @SerializedName("Professional")
    @Expose
    private VersionWhiteConfig Professional;

    /**
    * Inclusive Edition configuration information
    */
    @SerializedName("PrattWhitney")
    @Expose
    private VersionWhiteConfig PrattWhitney;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Ultimate Edition configuration information 
     * @return FlagShip Ultimate Edition configuration information
     */
    public VersionWhiteConfig getFlagShip() {
        return this.FlagShip;
    }

    /**
     * Set Ultimate Edition configuration information
     * @param FlagShip Ultimate Edition configuration information
     */
    public void setFlagShip(VersionWhiteConfig FlagShip) {
        this.FlagShip = FlagShip;
    }

    /**
     * Get Pro Edition configuration information 
     * @return Professional Pro Edition configuration information
     */
    public VersionWhiteConfig getProfessional() {
        return this.Professional;
    }

    /**
     * Set Pro Edition configuration information
     * @param Professional Pro Edition configuration information
     */
    public void setProfessional(VersionWhiteConfig Professional) {
        this.Professional = Professional;
    }

    /**
     * Get Inclusive Edition configuration information 
     * @return PrattWhitney Inclusive Edition configuration information
     */
    public VersionWhiteConfig getPrattWhitney() {
        return this.PrattWhitney;
    }

    /**
     * Set Inclusive Edition configuration information
     * @param PrattWhitney Inclusive Edition configuration information
     */
    public void setPrattWhitney(VersionWhiteConfig PrattWhitney) {
        this.PrattWhitney = PrattWhitney;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeLicenseWhiteConfigResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeLicenseWhiteConfigResponse(DescribeLicenseWhiteConfigResponse source) {
        if (source.FlagShip != null) {
            this.FlagShip = new VersionWhiteConfig(source.FlagShip);
        }
        if (source.Professional != null) {
            this.Professional = new VersionWhiteConfig(source.Professional);
        }
        if (source.PrattWhitney != null) {
            this.PrattWhitney = new VersionWhiteConfig(source.PrattWhitney);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamObj(map, prefix + "FlagShip.", this.FlagShip);
        this.setParamObj(map, prefix + "Professional.", this.Professional);
        this.setParamObj(map, prefix + "PrattWhitney.", this.PrattWhitney);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

