/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeLogHistogramResponse extends AbstractModel {

    /**
    * Result details of statistics within the period
    */
    @SerializedName("Data")
    @Expose
    private LogHistogram [] Data;

    /**
    * Statistical period (unit: ms)
    */
    @SerializedName("Period")
    @Expose
    private Long Period;

    /**
    * Total number of logs that hit the keywords
    */
    @SerializedName("TotalCount")
    @Expose
    private Long TotalCount;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Result details of statistics within the period 
     * @return Data Result details of statistics within the period
     */
    public LogHistogram [] getData() {
        return this.Data;
    }

    /**
     * Set Result details of statistics within the period
     * @param Data Result details of statistics within the period
     */
    public void setData(LogHistogram [] Data) {
        this.Data = Data;
    }

    /**
     * Get Statistical period (unit: ms) 
     * @return Period Statistical period (unit: ms)
     */
    public Long getPeriod() {
        return this.Period;
    }

    /**
     * Set Statistical period (unit: ms)
     * @param Period Statistical period (unit: ms)
     */
    public void setPeriod(Long Period) {
        this.Period = Period;
    }

    /**
     * Get Total number of logs that hit the keywords 
     * @return TotalCount Total number of logs that hit the keywords
     */
    public Long getTotalCount() {
        return this.TotalCount;
    }

    /**
     * Set Total number of logs that hit the keywords
     * @param TotalCount Total number of logs that hit the keywords
     */
    public void setTotalCount(Long TotalCount) {
        this.TotalCount = TotalCount;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeLogHistogramResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeLogHistogramResponse(DescribeLogHistogramResponse source) {
        if (source.Data != null) {
            this.Data = new LogHistogram[source.Data.length];
            for (int i = 0; i < source.Data.length; i++) {
                this.Data[i] = new LogHistogram(source.Data[i]);
            }
        }
        if (source.Period != null) {
            this.Period = new Long(source.Period);
        }
        if (source.TotalCount != null) {
            this.TotalCount = new Long(source.TotalCount);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "Data.", this.Data);
        this.setParamSimple(map, prefix + "Period", this.Period);
        this.setParamSimple(map, prefix + "TotalCount", this.TotalCount);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

