/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeLogStorageConfigResponse extends AbstractModel {

    /**
    * Storage type. The value is an array of strings.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Type")
    @Expose
    private String [] Type;

    /**
    * Log retention days. The value 3640 means the retention days are not limited.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Period")
    @Expose
    private Long Period;

    /**
    * Count of period changes in this month
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("PeriodModifyCount")
    @Expose
    private Long PeriodModifyCount;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Storage type. The value is an array of strings.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return Type Storage type. The value is an array of strings.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String [] getType() {
        return this.Type;
    }

    /**
     * Set Storage type. The value is an array of strings.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param Type Storage type. The value is an array of strings.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setType(String [] Type) {
        this.Type = Type;
    }

    /**
     * Get Log retention days. The value 3640 means the retention days are not limited.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return Period Log retention days. The value 3640 means the retention days are not limited.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getPeriod() {
        return this.Period;
    }

    /**
     * Set Log retention days. The value 3640 means the retention days are not limited.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param Period Log retention days. The value 3640 means the retention days are not limited.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setPeriod(Long Period) {
        this.Period = Period;
    }

    /**
     * Get Count of period changes in this month
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return PeriodModifyCount Count of period changes in this month
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getPeriodModifyCount() {
        return this.PeriodModifyCount;
    }

    /**
     * Set Count of period changes in this month
Note: This field may return null, indicating that no valid values can be obtained.
     * @param PeriodModifyCount Count of period changes in this month
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setPeriodModifyCount(Long PeriodModifyCount) {
        this.PeriodModifyCount = PeriodModifyCount;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeLogStorageConfigResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeLogStorageConfigResponse(DescribeLogStorageConfigResponse source) {
        if (source.Type != null) {
            this.Type = new String[source.Type.length];
            for (int i = 0; i < source.Type.length; i++) {
                this.Type[i] = new String(source.Type[i]);
            }
        }
        if (source.Period != null) {
            this.Period = new Long(source.Period);
        }
        if (source.PeriodModifyCount != null) {
            this.PeriodModifyCount = new Long(source.PeriodModifyCount);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArraySimple(map, prefix + "Type.", this.Type);
        this.setParamSimple(map, prefix + "Period", this.Period);
        this.setParamSimple(map, prefix + "PeriodModifyCount", this.PeriodModifyCount);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

