/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeMachineGeneralResponse extends AbstractModel {

    /**
    * Total number of assets
    */
    @SerializedName("MachineCnt")
    @Expose
    private Long MachineCnt;

    /**
    * Number of Tencent Cloud machines
    */
    @SerializedName("TencentCloudMachineCnt")
    @Expose
    private Long TencentCloudMachineCnt;

    /**
    * Number of Alibaba Cloud machines
    */
    @SerializedName("AliCloudMachineCnt")
    @Expose
    private Long AliCloudMachineCnt;

    /**
    * Number of Baidu Cloud machines
    */
    @SerializedName("BaiduCloudMachineCnt")
    @Expose
    private Long BaiduCloudMachineCnt;

    /**
    * Number of IDC machines
    */
    @SerializedName("IDCMachineCnt")
    @Expose
    private Long IDCMachineCnt;

    /**
    * Number of machines from other cloud service vendors
    */
    @SerializedName("OtherCloudMachineCnt")
    @Expose
    private Long OtherCloudMachineCnt;

    /**
    * Number of protected machines
    */
    @SerializedName("ProtectMachineCnt")
    @Expose
    private Long ProtectMachineCnt;

    /**
    * Number of protected Basic Edition machines
    */
    @SerializedName("BaseMachineCnt")
    @Expose
    private Long BaseMachineCnt;

    /**
    * Number of protected Pro Edition machines
    */
    @SerializedName("SpecialtyMachineCnt")
    @Expose
    private Long SpecialtyMachineCnt;

    /**
    * Number of protected Ultimate Edition machines
    */
    @SerializedName("FlagshipMachineCnt")
    @Expose
    private Long FlagshipMachineCnt;

    /**
    * Number of risky machines
    */
    @SerializedName("RiskMachineCnt")
    @Expose
    private Long RiskMachineCnt;

    /**
    * Number of new risky machines compared with that yesterday
    */
    @SerializedName("CompareYesterdayRiskMachineCnt")
    @Expose
    private Long CompareYesterdayRiskMachineCnt;

    /**
    * Number of new unprotected machines compared with that yesterday
    */
    @SerializedName("CompareYesterdayNotProtectMachineCnt")
    @Expose
    private Long CompareYesterdayNotProtectMachineCnt;

    /**
    * Number of new machines about to expire compared with that yesterday
    */
    @SerializedName("CompareYesterdayDeadlineMachineCnt")
    @Expose
    private Long CompareYesterdayDeadlineMachineCnt;

    /**
    * Number of machines about to expire
    */
    @SerializedName("DeadlineMachineCnt")
    @Expose
    private Long DeadlineMachineCnt;

    /**
    * Number of unprotected machines
    */
    @SerializedName("NotProtectMachineCnt")
    @Expose
    private Long NotProtectMachineCnt;

    /**
    * Number of protected Inclusive Edition machines (Lighthouse machines)
    */
    @SerializedName("LHGeneralDiscountCnt")
    @Expose
    private Long LHGeneralDiscountCnt;

    /**
    * Number of new hosts compared with that yesterday
    */
    @SerializedName("CompareYesterdayMachineCnt")
    @Expose
    private Long CompareYesterdayMachineCnt;

    /**
    * Auto-cleanup Time, maximum 720 hours, minimum 0, 0 by default, 0=OFF
    */
    @SerializedName("MachineDestroyAfterOfflineHours")
    @Expose
    private Long MachineDestroyAfterOfflineHours;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Total number of assets 
     * @return MachineCnt Total number of assets
     */
    public Long getMachineCnt() {
        return this.MachineCnt;
    }

    /**
     * Set Total number of assets
     * @param MachineCnt Total number of assets
     */
    public void setMachineCnt(Long MachineCnt) {
        this.MachineCnt = MachineCnt;
    }

    /**
     * Get Number of Tencent Cloud machines 
     * @return TencentCloudMachineCnt Number of Tencent Cloud machines
     * @deprecated
     */
    @Deprecated
    public Long getTencentCloudMachineCnt() {
        return this.TencentCloudMachineCnt;
    }

    /**
     * Set Number of Tencent Cloud machines
     * @param TencentCloudMachineCnt Number of Tencent Cloud machines
     * @deprecated
     */
    @Deprecated
    public void setTencentCloudMachineCnt(Long TencentCloudMachineCnt) {
        this.TencentCloudMachineCnt = TencentCloudMachineCnt;
    }

    /**
     * Get Number of Alibaba Cloud machines 
     * @return AliCloudMachineCnt Number of Alibaba Cloud machines
     * @deprecated
     */
    @Deprecated
    public Long getAliCloudMachineCnt() {
        return this.AliCloudMachineCnt;
    }

    /**
     * Set Number of Alibaba Cloud machines
     * @param AliCloudMachineCnt Number of Alibaba Cloud machines
     * @deprecated
     */
    @Deprecated
    public void setAliCloudMachineCnt(Long AliCloudMachineCnt) {
        this.AliCloudMachineCnt = AliCloudMachineCnt;
    }

    /**
     * Get Number of Baidu Cloud machines 
     * @return BaiduCloudMachineCnt Number of Baidu Cloud machines
     * @deprecated
     */
    @Deprecated
    public Long getBaiduCloudMachineCnt() {
        return this.BaiduCloudMachineCnt;
    }

    /**
     * Set Number of Baidu Cloud machines
     * @param BaiduCloudMachineCnt Number of Baidu Cloud machines
     * @deprecated
     */
    @Deprecated
    public void setBaiduCloudMachineCnt(Long BaiduCloudMachineCnt) {
        this.BaiduCloudMachineCnt = BaiduCloudMachineCnt;
    }

    /**
     * Get Number of IDC machines 
     * @return IDCMachineCnt Number of IDC machines
     * @deprecated
     */
    @Deprecated
    public Long getIDCMachineCnt() {
        return this.IDCMachineCnt;
    }

    /**
     * Set Number of IDC machines
     * @param IDCMachineCnt Number of IDC machines
     * @deprecated
     */
    @Deprecated
    public void setIDCMachineCnt(Long IDCMachineCnt) {
        this.IDCMachineCnt = IDCMachineCnt;
    }

    /**
     * Get Number of machines from other cloud service vendors 
     * @return OtherCloudMachineCnt Number of machines from other cloud service vendors
     * @deprecated
     */
    @Deprecated
    public Long getOtherCloudMachineCnt() {
        return this.OtherCloudMachineCnt;
    }

    /**
     * Set Number of machines from other cloud service vendors
     * @param OtherCloudMachineCnt Number of machines from other cloud service vendors
     * @deprecated
     */
    @Deprecated
    public void setOtherCloudMachineCnt(Long OtherCloudMachineCnt) {
        this.OtherCloudMachineCnt = OtherCloudMachineCnt;
    }

    /**
     * Get Number of protected machines 
     * @return ProtectMachineCnt Number of protected machines
     */
    public Long getProtectMachineCnt() {
        return this.ProtectMachineCnt;
    }

    /**
     * Set Number of protected machines
     * @param ProtectMachineCnt Number of protected machines
     */
    public void setProtectMachineCnt(Long ProtectMachineCnt) {
        this.ProtectMachineCnt = ProtectMachineCnt;
    }

    /**
     * Get Number of protected Basic Edition machines 
     * @return BaseMachineCnt Number of protected Basic Edition machines
     */
    public Long getBaseMachineCnt() {
        return this.BaseMachineCnt;
    }

    /**
     * Set Number of protected Basic Edition machines
     * @param BaseMachineCnt Number of protected Basic Edition machines
     */
    public void setBaseMachineCnt(Long BaseMachineCnt) {
        this.BaseMachineCnt = BaseMachineCnt;
    }

    /**
     * Get Number of protected Pro Edition machines 
     * @return SpecialtyMachineCnt Number of protected Pro Edition machines
     */
    public Long getSpecialtyMachineCnt() {
        return this.SpecialtyMachineCnt;
    }

    /**
     * Set Number of protected Pro Edition machines
     * @param SpecialtyMachineCnt Number of protected Pro Edition machines
     */
    public void setSpecialtyMachineCnt(Long SpecialtyMachineCnt) {
        this.SpecialtyMachineCnt = SpecialtyMachineCnt;
    }

    /**
     * Get Number of protected Ultimate Edition machines 
     * @return FlagshipMachineCnt Number of protected Ultimate Edition machines
     */
    public Long getFlagshipMachineCnt() {
        return this.FlagshipMachineCnt;
    }

    /**
     * Set Number of protected Ultimate Edition machines
     * @param FlagshipMachineCnt Number of protected Ultimate Edition machines
     */
    public void setFlagshipMachineCnt(Long FlagshipMachineCnt) {
        this.FlagshipMachineCnt = FlagshipMachineCnt;
    }

    /**
     * Get Number of risky machines 
     * @return RiskMachineCnt Number of risky machines
     */
    public Long getRiskMachineCnt() {
        return this.RiskMachineCnt;
    }

    /**
     * Set Number of risky machines
     * @param RiskMachineCnt Number of risky machines
     */
    public void setRiskMachineCnt(Long RiskMachineCnt) {
        this.RiskMachineCnt = RiskMachineCnt;
    }

    /**
     * Get Number of new risky machines compared with that yesterday 
     * @return CompareYesterdayRiskMachineCnt Number of new risky machines compared with that yesterday
     */
    public Long getCompareYesterdayRiskMachineCnt() {
        return this.CompareYesterdayRiskMachineCnt;
    }

    /**
     * Set Number of new risky machines compared with that yesterday
     * @param CompareYesterdayRiskMachineCnt Number of new risky machines compared with that yesterday
     */
    public void setCompareYesterdayRiskMachineCnt(Long CompareYesterdayRiskMachineCnt) {
        this.CompareYesterdayRiskMachineCnt = CompareYesterdayRiskMachineCnt;
    }

    /**
     * Get Number of new unprotected machines compared with that yesterday 
     * @return CompareYesterdayNotProtectMachineCnt Number of new unprotected machines compared with that yesterday
     */
    public Long getCompareYesterdayNotProtectMachineCnt() {
        return this.CompareYesterdayNotProtectMachineCnt;
    }

    /**
     * Set Number of new unprotected machines compared with that yesterday
     * @param CompareYesterdayNotProtectMachineCnt Number of new unprotected machines compared with that yesterday
     */
    public void setCompareYesterdayNotProtectMachineCnt(Long CompareYesterdayNotProtectMachineCnt) {
        this.CompareYesterdayNotProtectMachineCnt = CompareYesterdayNotProtectMachineCnt;
    }

    /**
     * Get Number of new machines about to expire compared with that yesterday 
     * @return CompareYesterdayDeadlineMachineCnt Number of new machines about to expire compared with that yesterday
     */
    public Long getCompareYesterdayDeadlineMachineCnt() {
        return this.CompareYesterdayDeadlineMachineCnt;
    }

    /**
     * Set Number of new machines about to expire compared with that yesterday
     * @param CompareYesterdayDeadlineMachineCnt Number of new machines about to expire compared with that yesterday
     */
    public void setCompareYesterdayDeadlineMachineCnt(Long CompareYesterdayDeadlineMachineCnt) {
        this.CompareYesterdayDeadlineMachineCnt = CompareYesterdayDeadlineMachineCnt;
    }

    /**
     * Get Number of machines about to expire 
     * @return DeadlineMachineCnt Number of machines about to expire
     */
    public Long getDeadlineMachineCnt() {
        return this.DeadlineMachineCnt;
    }

    /**
     * Set Number of machines about to expire
     * @param DeadlineMachineCnt Number of machines about to expire
     */
    public void setDeadlineMachineCnt(Long DeadlineMachineCnt) {
        this.DeadlineMachineCnt = DeadlineMachineCnt;
    }

    /**
     * Get Number of unprotected machines 
     * @return NotProtectMachineCnt Number of unprotected machines
     */
    public Long getNotProtectMachineCnt() {
        return this.NotProtectMachineCnt;
    }

    /**
     * Set Number of unprotected machines
     * @param NotProtectMachineCnt Number of unprotected machines
     */
    public void setNotProtectMachineCnt(Long NotProtectMachineCnt) {
        this.NotProtectMachineCnt = NotProtectMachineCnt;
    }

    /**
     * Get Number of protected Inclusive Edition machines (Lighthouse machines) 
     * @return LHGeneralDiscountCnt Number of protected Inclusive Edition machines (Lighthouse machines)
     */
    public Long getLHGeneralDiscountCnt() {
        return this.LHGeneralDiscountCnt;
    }

    /**
     * Set Number of protected Inclusive Edition machines (Lighthouse machines)
     * @param LHGeneralDiscountCnt Number of protected Inclusive Edition machines (Lighthouse machines)
     */
    public void setLHGeneralDiscountCnt(Long LHGeneralDiscountCnt) {
        this.LHGeneralDiscountCnt = LHGeneralDiscountCnt;
    }

    /**
     * Get Number of new hosts compared with that yesterday 
     * @return CompareYesterdayMachineCnt Number of new hosts compared with that yesterday
     */
    public Long getCompareYesterdayMachineCnt() {
        return this.CompareYesterdayMachineCnt;
    }

    /**
     * Set Number of new hosts compared with that yesterday
     * @param CompareYesterdayMachineCnt Number of new hosts compared with that yesterday
     */
    public void setCompareYesterdayMachineCnt(Long CompareYesterdayMachineCnt) {
        this.CompareYesterdayMachineCnt = CompareYesterdayMachineCnt;
    }

    /**
     * Get Auto-cleanup Time, maximum 720 hours, minimum 0, 0 by default, 0=OFF 
     * @return MachineDestroyAfterOfflineHours Auto-cleanup Time, maximum 720 hours, minimum 0, 0 by default, 0=OFF
     */
    public Long getMachineDestroyAfterOfflineHours() {
        return this.MachineDestroyAfterOfflineHours;
    }

    /**
     * Set Auto-cleanup Time, maximum 720 hours, minimum 0, 0 by default, 0=OFF
     * @param MachineDestroyAfterOfflineHours Auto-cleanup Time, maximum 720 hours, minimum 0, 0 by default, 0=OFF
     */
    public void setMachineDestroyAfterOfflineHours(Long MachineDestroyAfterOfflineHours) {
        this.MachineDestroyAfterOfflineHours = MachineDestroyAfterOfflineHours;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeMachineGeneralResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeMachineGeneralResponse(DescribeMachineGeneralResponse source) {
        if (source.MachineCnt != null) {
            this.MachineCnt = new Long(source.MachineCnt);
        }
        if (source.TencentCloudMachineCnt != null) {
            this.TencentCloudMachineCnt = new Long(source.TencentCloudMachineCnt);
        }
        if (source.AliCloudMachineCnt != null) {
            this.AliCloudMachineCnt = new Long(source.AliCloudMachineCnt);
        }
        if (source.BaiduCloudMachineCnt != null) {
            this.BaiduCloudMachineCnt = new Long(source.BaiduCloudMachineCnt);
        }
        if (source.IDCMachineCnt != null) {
            this.IDCMachineCnt = new Long(source.IDCMachineCnt);
        }
        if (source.OtherCloudMachineCnt != null) {
            this.OtherCloudMachineCnt = new Long(source.OtherCloudMachineCnt);
        }
        if (source.ProtectMachineCnt != null) {
            this.ProtectMachineCnt = new Long(source.ProtectMachineCnt);
        }
        if (source.BaseMachineCnt != null) {
            this.BaseMachineCnt = new Long(source.BaseMachineCnt);
        }
        if (source.SpecialtyMachineCnt != null) {
            this.SpecialtyMachineCnt = new Long(source.SpecialtyMachineCnt);
        }
        if (source.FlagshipMachineCnt != null) {
            this.FlagshipMachineCnt = new Long(source.FlagshipMachineCnt);
        }
        if (source.RiskMachineCnt != null) {
            this.RiskMachineCnt = new Long(source.RiskMachineCnt);
        }
        if (source.CompareYesterdayRiskMachineCnt != null) {
            this.CompareYesterdayRiskMachineCnt = new Long(source.CompareYesterdayRiskMachineCnt);
        }
        if (source.CompareYesterdayNotProtectMachineCnt != null) {
            this.CompareYesterdayNotProtectMachineCnt = new Long(source.CompareYesterdayNotProtectMachineCnt);
        }
        if (source.CompareYesterdayDeadlineMachineCnt != null) {
            this.CompareYesterdayDeadlineMachineCnt = new Long(source.CompareYesterdayDeadlineMachineCnt);
        }
        if (source.DeadlineMachineCnt != null) {
            this.DeadlineMachineCnt = new Long(source.DeadlineMachineCnt);
        }
        if (source.NotProtectMachineCnt != null) {
            this.NotProtectMachineCnt = new Long(source.NotProtectMachineCnt);
        }
        if (source.LHGeneralDiscountCnt != null) {
            this.LHGeneralDiscountCnt = new Long(source.LHGeneralDiscountCnt);
        }
        if (source.CompareYesterdayMachineCnt != null) {
            this.CompareYesterdayMachineCnt = new Long(source.CompareYesterdayMachineCnt);
        }
        if (source.MachineDestroyAfterOfflineHours != null) {
            this.MachineDestroyAfterOfflineHours = new Long(source.MachineDestroyAfterOfflineHours);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "MachineCnt", this.MachineCnt);
        this.setParamSimple(map, prefix + "TencentCloudMachineCnt", this.TencentCloudMachineCnt);
        this.setParamSimple(map, prefix + "AliCloudMachineCnt", this.AliCloudMachineCnt);
        this.setParamSimple(map, prefix + "BaiduCloudMachineCnt", this.BaiduCloudMachineCnt);
        this.setParamSimple(map, prefix + "IDCMachineCnt", this.IDCMachineCnt);
        this.setParamSimple(map, prefix + "OtherCloudMachineCnt", this.OtherCloudMachineCnt);
        this.setParamSimple(map, prefix + "ProtectMachineCnt", this.ProtectMachineCnt);
        this.setParamSimple(map, prefix + "BaseMachineCnt", this.BaseMachineCnt);
        this.setParamSimple(map, prefix + "SpecialtyMachineCnt", this.SpecialtyMachineCnt);
        this.setParamSimple(map, prefix + "FlagshipMachineCnt", this.FlagshipMachineCnt);
        this.setParamSimple(map, prefix + "RiskMachineCnt", this.RiskMachineCnt);
        this.setParamSimple(map, prefix + "CompareYesterdayRiskMachineCnt", this.CompareYesterdayRiskMachineCnt);
        this.setParamSimple(map, prefix + "CompareYesterdayNotProtectMachineCnt", this.CompareYesterdayNotProtectMachineCnt);
        this.setParamSimple(map, prefix + "CompareYesterdayDeadlineMachineCnt", this.CompareYesterdayDeadlineMachineCnt);
        this.setParamSimple(map, prefix + "DeadlineMachineCnt", this.DeadlineMachineCnt);
        this.setParamSimple(map, prefix + "NotProtectMachineCnt", this.NotProtectMachineCnt);
        this.setParamSimple(map, prefix + "LHGeneralDiscountCnt", this.LHGeneralDiscountCnt);
        this.setParamSimple(map, prefix + "CompareYesterdayMachineCnt", this.CompareYesterdayMachineCnt);
        this.setParamSimple(map, prefix + "MachineDestroyAfterOfflineHours", this.MachineDestroyAfterOfflineHours);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

