/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeMachineRegionsResponse extends AbstractModel {

    /**
    * List of Cloud Virtual Machine regions
    */
    @SerializedName("CVM")
    @Expose
    private RegionInfo [] CVM;

    /**
    * List of BM machine regions
    */
    @SerializedName("BM")
    @Expose
    private RegionInfo [] BM;

    /**
    * List of Lighthouse regions
    */
    @SerializedName("LH")
    @Expose
    private RegionInfo [] LH;

    /**
    * List of Edge Computing Machine regions
    */
    @SerializedName("ECM")
    @Expose
    private RegionInfo [] ECM;

    /**
    * List of Hybrid Cloud regions
    */
    @SerializedName("Other")
    @Expose
    private RegionInfo [] Other;

    /**
    * List of all regions (including above regions)
    */
    @SerializedName("ALL")
    @Expose
    private RegionInfo [] ALL;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get List of Cloud Virtual Machine regions 
     * @return CVM List of Cloud Virtual Machine regions
     */
    public RegionInfo [] getCVM() {
        return this.CVM;
    }

    /**
     * Set List of Cloud Virtual Machine regions
     * @param CVM List of Cloud Virtual Machine regions
     */
    public void setCVM(RegionInfo [] CVM) {
        this.CVM = CVM;
    }

    /**
     * Get List of BM machine regions 
     * @return BM List of BM machine regions
     */
    public RegionInfo [] getBM() {
        return this.BM;
    }

    /**
     * Set List of BM machine regions
     * @param BM List of BM machine regions
     */
    public void setBM(RegionInfo [] BM) {
        this.BM = BM;
    }

    /**
     * Get List of Lighthouse regions 
     * @return LH List of Lighthouse regions
     */
    public RegionInfo [] getLH() {
        return this.LH;
    }

    /**
     * Set List of Lighthouse regions
     * @param LH List of Lighthouse regions
     */
    public void setLH(RegionInfo [] LH) {
        this.LH = LH;
    }

    /**
     * Get List of Edge Computing Machine regions 
     * @return ECM List of Edge Computing Machine regions
     */
    public RegionInfo [] getECM() {
        return this.ECM;
    }

    /**
     * Set List of Edge Computing Machine regions
     * @param ECM List of Edge Computing Machine regions
     */
    public void setECM(RegionInfo [] ECM) {
        this.ECM = ECM;
    }

    /**
     * Get List of Hybrid Cloud regions 
     * @return Other List of Hybrid Cloud regions
     */
    public RegionInfo [] getOther() {
        return this.Other;
    }

    /**
     * Set List of Hybrid Cloud regions
     * @param Other List of Hybrid Cloud regions
     */
    public void setOther(RegionInfo [] Other) {
        this.Other = Other;
    }

    /**
     * Get List of all regions (including above regions) 
     * @return ALL List of all regions (including above regions)
     */
    public RegionInfo [] getALL() {
        return this.ALL;
    }

    /**
     * Set List of all regions (including above regions)
     * @param ALL List of all regions (including above regions)
     */
    public void setALL(RegionInfo [] ALL) {
        this.ALL = ALL;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeMachineRegionsResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeMachineRegionsResponse(DescribeMachineRegionsResponse source) {
        if (source.CVM != null) {
            this.CVM = new RegionInfo[source.CVM.length];
            for (int i = 0; i < source.CVM.length; i++) {
                this.CVM[i] = new RegionInfo(source.CVM[i]);
            }
        }
        if (source.BM != null) {
            this.BM = new RegionInfo[source.BM.length];
            for (int i = 0; i < source.BM.length; i++) {
                this.BM[i] = new RegionInfo(source.BM[i]);
            }
        }
        if (source.LH != null) {
            this.LH = new RegionInfo[source.LH.length];
            for (int i = 0; i < source.LH.length; i++) {
                this.LH[i] = new RegionInfo(source.LH[i]);
            }
        }
        if (source.ECM != null) {
            this.ECM = new RegionInfo[source.ECM.length];
            for (int i = 0; i < source.ECM.length; i++) {
                this.ECM[i] = new RegionInfo(source.ECM[i]);
            }
        }
        if (source.Other != null) {
            this.Other = new RegionInfo[source.Other.length];
            for (int i = 0; i < source.Other.length; i++) {
                this.Other[i] = new RegionInfo(source.Other[i]);
            }
        }
        if (source.ALL != null) {
            this.ALL = new RegionInfo[source.ALL.length];
            for (int i = 0; i < source.ALL.length; i++) {
                this.ALL[i] = new RegionInfo(source.ALL[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "CVM.", this.CVM);
        this.setParamArrayObj(map, prefix + "BM.", this.BM);
        this.setParamArrayObj(map, prefix + "LH.", this.LH);
        this.setParamArrayObj(map, prefix + "ECM.", this.ECM);
        this.setParamArrayObj(map, prefix + "Other.", this.Other);
        this.setParamArrayObj(map, prefix + "ALL.", this.ALL);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

