/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeMachineRiskCntResponse extends AbstractModel {

    /**
    * Cross-region log-in
    */
    @SerializedName("HostLogin")
    @Expose
    private Long HostLogin;

    /**
    * Password cracking
    */
    @SerializedName("BruteAttack")
    @Expose
    private Long BruteAttack;

    /**
    * Malicious request
    */
    @SerializedName("MaliciousRequest")
    @Expose
    private Long MaliciousRequest;

    /**
    * Reverse Shell
    */
    @SerializedName("ReverseShell")
    @Expose
    private Long ReverseShell;

    /**
    * High-risk command
    */
    @SerializedName("Bash")
    @Expose
    private Long Bash;

    /**
    * Local privilege escalation
    */
    @SerializedName("PrivilegeEscalation")
    @Expose
    private Long PrivilegeEscalation;

    /**
    * Trojan
    */
    @SerializedName("Malware")
    @Expose
    private Long Malware;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Cross-region log-in 
     * @return HostLogin Cross-region log-in
     */
    public Long getHostLogin() {
        return this.HostLogin;
    }

    /**
     * Set Cross-region log-in
     * @param HostLogin Cross-region log-in
     */
    public void setHostLogin(Long HostLogin) {
        this.HostLogin = HostLogin;
    }

    /**
     * Get Password cracking 
     * @return BruteAttack Password cracking
     */
    public Long getBruteAttack() {
        return this.BruteAttack;
    }

    /**
     * Set Password cracking
     * @param BruteAttack Password cracking
     */
    public void setBruteAttack(Long BruteAttack) {
        this.BruteAttack = BruteAttack;
    }

    /**
     * Get Malicious request 
     * @return MaliciousRequest Malicious request
     */
    public Long getMaliciousRequest() {
        return this.MaliciousRequest;
    }

    /**
     * Set Malicious request
     * @param MaliciousRequest Malicious request
     */
    public void setMaliciousRequest(Long MaliciousRequest) {
        this.MaliciousRequest = MaliciousRequest;
    }

    /**
     * Get Reverse Shell 
     * @return ReverseShell Reverse Shell
     */
    public Long getReverseShell() {
        return this.ReverseShell;
    }

    /**
     * Set Reverse Shell
     * @param ReverseShell Reverse Shell
     */
    public void setReverseShell(Long ReverseShell) {
        this.ReverseShell = ReverseShell;
    }

    /**
     * Get High-risk command 
     * @return Bash High-risk command
     */
    public Long getBash() {
        return this.Bash;
    }

    /**
     * Set High-risk command
     * @param Bash High-risk command
     */
    public void setBash(Long Bash) {
        this.Bash = Bash;
    }

    /**
     * Get Local privilege escalation 
     * @return PrivilegeEscalation Local privilege escalation
     */
    public Long getPrivilegeEscalation() {
        return this.PrivilegeEscalation;
    }

    /**
     * Set Local privilege escalation
     * @param PrivilegeEscalation Local privilege escalation
     */
    public void setPrivilegeEscalation(Long PrivilegeEscalation) {
        this.PrivilegeEscalation = PrivilegeEscalation;
    }

    /**
     * Get Trojan 
     * @return Malware Trojan
     */
    public Long getMalware() {
        return this.Malware;
    }

    /**
     * Set Trojan
     * @param Malware Trojan
     */
    public void setMalware(Long Malware) {
        this.Malware = Malware;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeMachineRiskCntResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeMachineRiskCntResponse(DescribeMachineRiskCntResponse source) {
        if (source.HostLogin != null) {
            this.HostLogin = new Long(source.HostLogin);
        }
        if (source.BruteAttack != null) {
            this.BruteAttack = new Long(source.BruteAttack);
        }
        if (source.MaliciousRequest != null) {
            this.MaliciousRequest = new Long(source.MaliciousRequest);
        }
        if (source.ReverseShell != null) {
            this.ReverseShell = new Long(source.ReverseShell);
        }
        if (source.Bash != null) {
            this.Bash = new Long(source.Bash);
        }
        if (source.PrivilegeEscalation != null) {
            this.PrivilegeEscalation = new Long(source.PrivilegeEscalation);
        }
        if (source.Malware != null) {
            this.Malware = new Long(source.Malware);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "HostLogin", this.HostLogin);
        this.setParamSimple(map, prefix + "BruteAttack", this.BruteAttack);
        this.setParamSimple(map, prefix + "MaliciousRequest", this.MaliciousRequest);
        this.setParamSimple(map, prefix + "ReverseShell", this.ReverseShell);
        this.setParamSimple(map, prefix + "Bash", this.Bash);
        this.setParamSimple(map, prefix + "PrivilegeEscalation", this.PrivilegeEscalation);
        this.setParamSimple(map, prefix + "Malware", this.Malware);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

