/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeMalwareRiskWarningResponse extends AbstractModel {

    /**
    * Whether automatic scanning is enabled. True: enabled; false: disabled.
    */
    @SerializedName("IsCheckRisk")
    @Expose
    private Boolean IsCheckRisk;

    /**
    * List of risky files
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("List")
    @Expose
    private MalwareRisk [] List;

    /**
    * Whether to show the prompt. True: show prompt; false: do not show prompt.
    */
    @SerializedName("IsPop")
    @Expose
    private Boolean IsPop;

    /**
    * Information on Abnormal Process List
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("ProcessList")
    @Expose
    private MalwareRisk [] ProcessList;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Whether automatic scanning is enabled. True: enabled; false: disabled. 
     * @return IsCheckRisk Whether automatic scanning is enabled. True: enabled; false: disabled.
     */
    public Boolean getIsCheckRisk() {
        return this.IsCheckRisk;
    }

    /**
     * Set Whether automatic scanning is enabled. True: enabled; false: disabled.
     * @param IsCheckRisk Whether automatic scanning is enabled. True: enabled; false: disabled.
     */
    public void setIsCheckRisk(Boolean IsCheckRisk) {
        this.IsCheckRisk = IsCheckRisk;
    }

    /**
     * Get List of risky files
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return List List of risky files
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public MalwareRisk [] getList() {
        return this.List;
    }

    /**
     * Set List of risky files
Note: This field may return null, indicating that no valid values can be obtained.
     * @param List List of risky files
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setList(MalwareRisk [] List) {
        this.List = List;
    }

    /**
     * Get Whether to show the prompt. True: show prompt; false: do not show prompt. 
     * @return IsPop Whether to show the prompt. True: show prompt; false: do not show prompt.
     */
    public Boolean getIsPop() {
        return this.IsPop;
    }

    /**
     * Set Whether to show the prompt. True: show prompt; false: do not show prompt.
     * @param IsPop Whether to show the prompt. True: show prompt; false: do not show prompt.
     */
    public void setIsPop(Boolean IsPop) {
        this.IsPop = IsPop;
    }

    /**
     * Get Information on Abnormal Process List
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return ProcessList Information on Abnormal Process List
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public MalwareRisk [] getProcessList() {
        return this.ProcessList;
    }

    /**
     * Set Information on Abnormal Process List
Note: This field may return null, indicating that no valid values can be obtained.
     * @param ProcessList Information on Abnormal Process List
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setProcessList(MalwareRisk [] ProcessList) {
        this.ProcessList = ProcessList;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeMalwareRiskWarningResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeMalwareRiskWarningResponse(DescribeMalwareRiskWarningResponse source) {
        if (source.IsCheckRisk != null) {
            this.IsCheckRisk = new Boolean(source.IsCheckRisk);
        }
        if (source.List != null) {
            this.List = new MalwareRisk[source.List.length];
            for (int i = 0; i < source.List.length; i++) {
                this.List[i] = new MalwareRisk(source.List[i]);
            }
        }
        if (source.IsPop != null) {
            this.IsPop = new Boolean(source.IsPop);
        }
        if (source.ProcessList != null) {
            this.ProcessList = new MalwareRisk[source.ProcessList.length];
            for (int i = 0; i < source.ProcessList.length; i++) {
                this.ProcessList[i] = new MalwareRisk(source.ProcessList[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "IsCheckRisk", this.IsCheckRisk);
        this.setParamArrayObj(map, prefix + "List.", this.List);
        this.setParamSimple(map, prefix + "IsPop", this.IsPop);
        this.setParamArrayObj(map, prefix + "ProcessList.", this.ProcessList);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

