/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeMalwareTimingScanSettingResponse extends AbstractModel {

    /**
    * Detection mode: 0 - full disk detection; 1 - rapid detection
    */
    @SerializedName("CheckPattern")
    @Expose
    private Long CheckPattern;

    /**
    * Detection cycle; start time
    */
    @SerializedName("StartTime")
    @Expose
    private String StartTime;

    /**
    * Detection cycle; timeout end time
    */
    @SerializedName("EndTime")
    @Expose
    private String EndTime;

    /**
    * Whether all servers: 1 - all; 2 - specified
    */
    @SerializedName("IsGlobal")
    @Expose
    private Long IsGlobal;

    /**
    * When you select servers, host quuid is required.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("QuuidList")
    @Expose
    private String [] QuuidList;

    /**
    * Monitoring mode: 0 - standard; 1 - deep
    */
    @SerializedName("MonitoringPattern")
    @Expose
    private Long MonitoringPattern;

    /**
    * Cycle: 1 - daily
    */
    @SerializedName("Cycle")
    @Expose
    private Long Cycle;

    /**
    * Scheduled detection switch: 0 - disable; 1 - enable
    */
    @SerializedName("EnableScan")
    @Expose
    private Long EnableScan;

    /**
    * Unique ID
    */
    @SerializedName("Id")
    @Expose
    private Long Id;

    /**
    * Real-time monitoring: 0 - disable 1 - enable
    */
    @SerializedName("RealTimeMonitoring")
    @Expose
    private Long RealTimeMonitoring;

    /**
    * Whether to isolate automatically: 1 - yes; 0 - no
    */
    @SerializedName("AutoIsolation")
    @Expose
    private Long AutoIsolation;

    /**
    * One-click scan timeout duration, such as 1800 seconds
    */
    @SerializedName("ClickTimeout")
    @Expose
    private Long ClickTimeout;

    /**
    * Whether to terminate the process: 1: terminate; 0: not terminate. It is effective only if automatic isolation is enabled.
    */
    @SerializedName("KillProcess")
    @Expose
    private Long KillProcess;

    /**
    * 1 - standard mode (only critical and high-risk are reported.); 2 - enhanced mode (critical, high-risk, and medium-risk are reported.); 3 - strict mode (critical, high-risk, medium-risk, low-risk, and prompt are reported.)
    */
    @SerializedName("EngineType")
    @Expose
    private Long EngineType;

    /**
    * Heuristic Engine: 0 - OFF, 1 - ON
    */
    @SerializedName("EnableInspiredEngine")
    @Expose
    private Long EnableInspiredEngine;

    /**
    * Whether to enable malicious process killing [0: Not Enabled; 1: Enabled]
    */
    @SerializedName("EnableMemShellScan")
    @Expose
    private Long EnableMemShellScan;

    /**
    * Protection mode: 0 - standard; 1 - enhanced
    */
    @SerializedName("ProtectMode")
    @Expose
    private Long ProtectMode;

    /**
    * Scope of detection: 0 - malicious files other than scripts; 1 - all malicious files
    */
    @SerializedName("ProtectFileScope")
    @Expose
    private Long ProtectFileScope;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Detection mode: 0 - full disk detection; 1 - rapid detection 
     * @return CheckPattern Detection mode: 0 - full disk detection; 1 - rapid detection
     */
    public Long getCheckPattern() {
        return this.CheckPattern;
    }

    /**
     * Set Detection mode: 0 - full disk detection; 1 - rapid detection
     * @param CheckPattern Detection mode: 0 - full disk detection; 1 - rapid detection
     */
    public void setCheckPattern(Long CheckPattern) {
        this.CheckPattern = CheckPattern;
    }

    /**
     * Get Detection cycle; start time 
     * @return StartTime Detection cycle; start time
     */
    public String getStartTime() {
        return this.StartTime;
    }

    /**
     * Set Detection cycle; start time
     * @param StartTime Detection cycle; start time
     */
    public void setStartTime(String StartTime) {
        this.StartTime = StartTime;
    }

    /**
     * Get Detection cycle; timeout end time 
     * @return EndTime Detection cycle; timeout end time
     */
    public String getEndTime() {
        return this.EndTime;
    }

    /**
     * Set Detection cycle; timeout end time
     * @param EndTime Detection cycle; timeout end time
     */
    public void setEndTime(String EndTime) {
        this.EndTime = EndTime;
    }

    /**
     * Get Whether all servers: 1 - all; 2 - specified 
     * @return IsGlobal Whether all servers: 1 - all; 2 - specified
     */
    public Long getIsGlobal() {
        return this.IsGlobal;
    }

    /**
     * Set Whether all servers: 1 - all; 2 - specified
     * @param IsGlobal Whether all servers: 1 - all; 2 - specified
     */
    public void setIsGlobal(Long IsGlobal) {
        this.IsGlobal = IsGlobal;
    }

    /**
     * Get When you select servers, host quuid is required.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return QuuidList When you select servers, host quuid is required.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String [] getQuuidList() {
        return this.QuuidList;
    }

    /**
     * Set When you select servers, host quuid is required.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param QuuidList When you select servers, host quuid is required.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setQuuidList(String [] QuuidList) {
        this.QuuidList = QuuidList;
    }

    /**
     * Get Monitoring mode: 0 - standard; 1 - deep 
     * @return MonitoringPattern Monitoring mode: 0 - standard; 1 - deep
     */
    public Long getMonitoringPattern() {
        return this.MonitoringPattern;
    }

    /**
     * Set Monitoring mode: 0 - standard; 1 - deep
     * @param MonitoringPattern Monitoring mode: 0 - standard; 1 - deep
     */
    public void setMonitoringPattern(Long MonitoringPattern) {
        this.MonitoringPattern = MonitoringPattern;
    }

    /**
     * Get Cycle: 1 - daily 
     * @return Cycle Cycle: 1 - daily
     */
    public Long getCycle() {
        return this.Cycle;
    }

    /**
     * Set Cycle: 1 - daily
     * @param Cycle Cycle: 1 - daily
     */
    public void setCycle(Long Cycle) {
        this.Cycle = Cycle;
    }

    /**
     * Get Scheduled detection switch: 0 - disable; 1 - enable 
     * @return EnableScan Scheduled detection switch: 0 - disable; 1 - enable
     */
    public Long getEnableScan() {
        return this.EnableScan;
    }

    /**
     * Set Scheduled detection switch: 0 - disable; 1 - enable
     * @param EnableScan Scheduled detection switch: 0 - disable; 1 - enable
     */
    public void setEnableScan(Long EnableScan) {
        this.EnableScan = EnableScan;
    }

    /**
     * Get Unique ID 
     * @return Id Unique ID
     */
    public Long getId() {
        return this.Id;
    }

    /**
     * Set Unique ID
     * @param Id Unique ID
     */
    public void setId(Long Id) {
        this.Id = Id;
    }

    /**
     * Get Real-time monitoring: 0 - disable 1 - enable 
     * @return RealTimeMonitoring Real-time monitoring: 0 - disable 1 - enable
     */
    public Long getRealTimeMonitoring() {
        return this.RealTimeMonitoring;
    }

    /**
     * Set Real-time monitoring: 0 - disable 1 - enable
     * @param RealTimeMonitoring Real-time monitoring: 0 - disable 1 - enable
     */
    public void setRealTimeMonitoring(Long RealTimeMonitoring) {
        this.RealTimeMonitoring = RealTimeMonitoring;
    }

    /**
     * Get Whether to isolate automatically: 1 - yes; 0 - no 
     * @return AutoIsolation Whether to isolate automatically: 1 - yes; 0 - no
     */
    public Long getAutoIsolation() {
        return this.AutoIsolation;
    }

    /**
     * Set Whether to isolate automatically: 1 - yes; 0 - no
     * @param AutoIsolation Whether to isolate automatically: 1 - yes; 0 - no
     */
    public void setAutoIsolation(Long AutoIsolation) {
        this.AutoIsolation = AutoIsolation;
    }

    /**
     * Get One-click scan timeout duration, such as 1800 seconds 
     * @return ClickTimeout One-click scan timeout duration, such as 1800 seconds
     */
    public Long getClickTimeout() {
        return this.ClickTimeout;
    }

    /**
     * Set One-click scan timeout duration, such as 1800 seconds
     * @param ClickTimeout One-click scan timeout duration, such as 1800 seconds
     */
    public void setClickTimeout(Long ClickTimeout) {
        this.ClickTimeout = ClickTimeout;
    }

    /**
     * Get Whether to terminate the process: 1: terminate; 0: not terminate. It is effective only if automatic isolation is enabled. 
     * @return KillProcess Whether to terminate the process: 1: terminate; 0: not terminate. It is effective only if automatic isolation is enabled.
     */
    public Long getKillProcess() {
        return this.KillProcess;
    }

    /**
     * Set Whether to terminate the process: 1: terminate; 0: not terminate. It is effective only if automatic isolation is enabled.
     * @param KillProcess Whether to terminate the process: 1: terminate; 0: not terminate. It is effective only if automatic isolation is enabled.
     */
    public void setKillProcess(Long KillProcess) {
        this.KillProcess = KillProcess;
    }

    /**
     * Get 1 - standard mode (only critical and high-risk are reported.); 2 - enhanced mode (critical, high-risk, and medium-risk are reported.); 3 - strict mode (critical, high-risk, medium-risk, low-risk, and prompt are reported.) 
     * @return EngineType 1 - standard mode (only critical and high-risk are reported.); 2 - enhanced mode (critical, high-risk, and medium-risk are reported.); 3 - strict mode (critical, high-risk, medium-risk, low-risk, and prompt are reported.)
     */
    public Long getEngineType() {
        return this.EngineType;
    }

    /**
     * Set 1 - standard mode (only critical and high-risk are reported.); 2 - enhanced mode (critical, high-risk, and medium-risk are reported.); 3 - strict mode (critical, high-risk, medium-risk, low-risk, and prompt are reported.)
     * @param EngineType 1 - standard mode (only critical and high-risk are reported.); 2 - enhanced mode (critical, high-risk, and medium-risk are reported.); 3 - strict mode (critical, high-risk, medium-risk, low-risk, and prompt are reported.)
     */
    public void setEngineType(Long EngineType) {
        this.EngineType = EngineType;
    }

    /**
     * Get Heuristic Engine: 0 - OFF, 1 - ON 
     * @return EnableInspiredEngine Heuristic Engine: 0 - OFF, 1 - ON
     */
    public Long getEnableInspiredEngine() {
        return this.EnableInspiredEngine;
    }

    /**
     * Set Heuristic Engine: 0 - OFF, 1 - ON
     * @param EnableInspiredEngine Heuristic Engine: 0 - OFF, 1 - ON
     */
    public void setEnableInspiredEngine(Long EnableInspiredEngine) {
        this.EnableInspiredEngine = EnableInspiredEngine;
    }

    /**
     * Get Whether to enable malicious process killing [0: Not Enabled; 1: Enabled] 
     * @return EnableMemShellScan Whether to enable malicious process killing [0: Not Enabled; 1: Enabled]
     */
    public Long getEnableMemShellScan() {
        return this.EnableMemShellScan;
    }

    /**
     * Set Whether to enable malicious process killing [0: Not Enabled; 1: Enabled]
     * @param EnableMemShellScan Whether to enable malicious process killing [0: Not Enabled; 1: Enabled]
     */
    public void setEnableMemShellScan(Long EnableMemShellScan) {
        this.EnableMemShellScan = EnableMemShellScan;
    }

    /**
     * Get Protection mode: 0 - standard; 1 - enhanced 
     * @return ProtectMode Protection mode: 0 - standard; 1 - enhanced
     */
    public Long getProtectMode() {
        return this.ProtectMode;
    }

    /**
     * Set Protection mode: 0 - standard; 1 - enhanced
     * @param ProtectMode Protection mode: 0 - standard; 1 - enhanced
     */
    public void setProtectMode(Long ProtectMode) {
        this.ProtectMode = ProtectMode;
    }

    /**
     * Get Scope of detection: 0 - malicious files other than scripts; 1 - all malicious files 
     * @return ProtectFileScope Scope of detection: 0 - malicious files other than scripts; 1 - all malicious files
     */
    public Long getProtectFileScope() {
        return this.ProtectFileScope;
    }

    /**
     * Set Scope of detection: 0 - malicious files other than scripts; 1 - all malicious files
     * @param ProtectFileScope Scope of detection: 0 - malicious files other than scripts; 1 - all malicious files
     */
    public void setProtectFileScope(Long ProtectFileScope) {
        this.ProtectFileScope = ProtectFileScope;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeMalwareTimingScanSettingResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeMalwareTimingScanSettingResponse(DescribeMalwareTimingScanSettingResponse source) {
        if (source.CheckPattern != null) {
            this.CheckPattern = new Long(source.CheckPattern);
        }
        if (source.StartTime != null) {
            this.StartTime = new String(source.StartTime);
        }
        if (source.EndTime != null) {
            this.EndTime = new String(source.EndTime);
        }
        if (source.IsGlobal != null) {
            this.IsGlobal = new Long(source.IsGlobal);
        }
        if (source.QuuidList != null) {
            this.QuuidList = new String[source.QuuidList.length];
            for (int i = 0; i < source.QuuidList.length; i++) {
                this.QuuidList[i] = new String(source.QuuidList[i]);
            }
        }
        if (source.MonitoringPattern != null) {
            this.MonitoringPattern = new Long(source.MonitoringPattern);
        }
        if (source.Cycle != null) {
            this.Cycle = new Long(source.Cycle);
        }
        if (source.EnableScan != null) {
            this.EnableScan = new Long(source.EnableScan);
        }
        if (source.Id != null) {
            this.Id = new Long(source.Id);
        }
        if (source.RealTimeMonitoring != null) {
            this.RealTimeMonitoring = new Long(source.RealTimeMonitoring);
        }
        if (source.AutoIsolation != null) {
            this.AutoIsolation = new Long(source.AutoIsolation);
        }
        if (source.ClickTimeout != null) {
            this.ClickTimeout = new Long(source.ClickTimeout);
        }
        if (source.KillProcess != null) {
            this.KillProcess = new Long(source.KillProcess);
        }
        if (source.EngineType != null) {
            this.EngineType = new Long(source.EngineType);
        }
        if (source.EnableInspiredEngine != null) {
            this.EnableInspiredEngine = new Long(source.EnableInspiredEngine);
        }
        if (source.EnableMemShellScan != null) {
            this.EnableMemShellScan = new Long(source.EnableMemShellScan);
        }
        if (source.ProtectMode != null) {
            this.ProtectMode = new Long(source.ProtectMode);
        }
        if (source.ProtectFileScope != null) {
            this.ProtectFileScope = new Long(source.ProtectFileScope);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "CheckPattern", this.CheckPattern);
        this.setParamSimple(map, prefix + "StartTime", this.StartTime);
        this.setParamSimple(map, prefix + "EndTime", this.EndTime);
        this.setParamSimple(map, prefix + "IsGlobal", this.IsGlobal);
        this.setParamArraySimple(map, prefix + "QuuidList.", this.QuuidList);
        this.setParamSimple(map, prefix + "MonitoringPattern", this.MonitoringPattern);
        this.setParamSimple(map, prefix + "Cycle", this.Cycle);
        this.setParamSimple(map, prefix + "EnableScan", this.EnableScan);
        this.setParamSimple(map, prefix + "Id", this.Id);
        this.setParamSimple(map, prefix + "RealTimeMonitoring", this.RealTimeMonitoring);
        this.setParamSimple(map, prefix + "AutoIsolation", this.AutoIsolation);
        this.setParamSimple(map, prefix + "ClickTimeout", this.ClickTimeout);
        this.setParamSimple(map, prefix + "KillProcess", this.KillProcess);
        this.setParamSimple(map, prefix + "EngineType", this.EngineType);
        this.setParamSimple(map, prefix + "EnableInspiredEngine", this.EnableInspiredEngine);
        this.setParamSimple(map, prefix + "EnableMemShellScan", this.EnableMemShellScan);
        this.setParamSimple(map, prefix + "ProtectMode", this.ProtectMode);
        this.setParamSimple(map, prefix + "ProtectFileScope", this.ProtectFileScope);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

