/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeMalwareWhiteListAffectListRequest extends AbstractModel {

    /**
    * Allowlist rule ID
    */
    @SerializedName("WhiteListId")
    @Expose
    private Long WhiteListId;

    /**
    * Offset, which defaults to 0
    */
    @SerializedName("Offset")
    @Expose
    private Long Offset;

    /**
    * Quantity of returns. The maximum value is 100.
    */
    @SerializedName("Limit")
    @Expose
    private Long Limit;

    /**
    * Filter criteria
<li>HostIp - String - required: no - host IP query</li>
<li>FileName - String - required: no - file name query</li>
<li>FileDirectory - String - required: no - file directory query </li>
<li>FileExtension - String - required: no - file extension query</li>
<li>Mode - String - required: no - rule type: 0 MD5; 1 customize</li>
<li>Md5 - String - required: no - MD5 query</li>
    */
    @SerializedName("Filters")
    @Expose
    private Filter [] Filters;

    /**
    * Sorting Method: [ASC: Ascending Order, DESC: Descending Order]
    */
    @SerializedName("Order")
    @Expose
    private String Order;

    /**
    * Optional sorting column: [CreateTime]
    */
    @SerializedName("By")
    @Expose
    private String By;

    /**
     * Get Allowlist rule ID 
     * @return WhiteListId Allowlist rule ID
     */
    public Long getWhiteListId() {
        return this.WhiteListId;
    }

    /**
     * Set Allowlist rule ID
     * @param WhiteListId Allowlist rule ID
     */
    public void setWhiteListId(Long WhiteListId) {
        this.WhiteListId = WhiteListId;
    }

    /**
     * Get Offset, which defaults to 0 
     * @return Offset Offset, which defaults to 0
     */
    public Long getOffset() {
        return this.Offset;
    }

    /**
     * Set Offset, which defaults to 0
     * @param Offset Offset, which defaults to 0
     */
    public void setOffset(Long Offset) {
        this.Offset = Offset;
    }

    /**
     * Get Quantity of returns. The maximum value is 100. 
     * @return Limit Quantity of returns. The maximum value is 100.
     */
    public Long getLimit() {
        return this.Limit;
    }

    /**
     * Set Quantity of returns. The maximum value is 100.
     * @param Limit Quantity of returns. The maximum value is 100.
     */
    public void setLimit(Long Limit) {
        this.Limit = Limit;
    }

    /**
     * Get Filter criteria
<li>HostIp - String - required: no - host IP query</li>
<li>FileName - String - required: no - file name query</li>
<li>FileDirectory - String - required: no - file directory query </li>
<li>FileExtension - String - required: no - file extension query</li>
<li>Mode - String - required: no - rule type: 0 MD5; 1 customize</li>
<li>Md5 - String - required: no - MD5 query</li> 
     * @return Filters Filter criteria
<li>HostIp - String - required: no - host IP query</li>
<li>FileName - String - required: no - file name query</li>
<li>FileDirectory - String - required: no - file directory query </li>
<li>FileExtension - String - required: no - file extension query</li>
<li>Mode - String - required: no - rule type: 0 MD5; 1 customize</li>
<li>Md5 - String - required: no - MD5 query</li>
     */
    public Filter [] getFilters() {
        return this.Filters;
    }

    /**
     * Set Filter criteria
<li>HostIp - String - required: no - host IP query</li>
<li>FileName - String - required: no - file name query</li>
<li>FileDirectory - String - required: no - file directory query </li>
<li>FileExtension - String - required: no - file extension query</li>
<li>Mode - String - required: no - rule type: 0 MD5; 1 customize</li>
<li>Md5 - String - required: no - MD5 query</li>
     * @param Filters Filter criteria
<li>HostIp - String - required: no - host IP query</li>
<li>FileName - String - required: no - file name query</li>
<li>FileDirectory - String - required: no - file directory query </li>
<li>FileExtension - String - required: no - file extension query</li>
<li>Mode - String - required: no - rule type: 0 MD5; 1 customize</li>
<li>Md5 - String - required: no - MD5 query</li>
     */
    public void setFilters(Filter [] Filters) {
        this.Filters = Filters;
    }

    /**
     * Get Sorting Method: [ASC: Ascending Order, DESC: Descending Order] 
     * @return Order Sorting Method: [ASC: Ascending Order, DESC: Descending Order]
     */
    public String getOrder() {
        return this.Order;
    }

    /**
     * Set Sorting Method: [ASC: Ascending Order, DESC: Descending Order]
     * @param Order Sorting Method: [ASC: Ascending Order, DESC: Descending Order]
     */
    public void setOrder(String Order) {
        this.Order = Order;
    }

    /**
     * Get Optional sorting column: [CreateTime] 
     * @return By Optional sorting column: [CreateTime]
     */
    public String getBy() {
        return this.By;
    }

    /**
     * Set Optional sorting column: [CreateTime]
     * @param By Optional sorting column: [CreateTime]
     */
    public void setBy(String By) {
        this.By = By;
    }

    public DescribeMalwareWhiteListAffectListRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeMalwareWhiteListAffectListRequest(DescribeMalwareWhiteListAffectListRequest source) {
        if (source.WhiteListId != null) {
            this.WhiteListId = new Long(source.WhiteListId);
        }
        if (source.Offset != null) {
            this.Offset = new Long(source.Offset);
        }
        if (source.Limit != null) {
            this.Limit = new Long(source.Limit);
        }
        if (source.Filters != null) {
            this.Filters = new Filter[source.Filters.length];
            for (int i = 0; i < source.Filters.length; i++) {
                this.Filters[i] = new Filter(source.Filters[i]);
            }
        }
        if (source.Order != null) {
            this.Order = new String(source.Order);
        }
        if (source.By != null) {
            this.By = new String(source.By);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "WhiteListId", this.WhiteListId);
        this.setParamSimple(map, prefix + "Offset", this.Offset);
        this.setParamSimple(map, prefix + "Limit", this.Limit);
        this.setParamArrayObj(map, prefix + "Filters.", this.Filters);
        this.setParamSimple(map, prefix + "Order", this.Order);
        this.setParamSimple(map, prefix + "By", this.By);

    }
}

