/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeOverviewStatisticsResponse extends AbstractModel {

    /**
    * Number of servers online
    */
    @SerializedName("OnlineMachineNum")
    @Expose
    private Long OnlineMachineNum;

    /**
    * Number of professional servers
    */
    @SerializedName("ProVersionMachineNum")
    @Expose
    private Long ProVersionMachineNum;

    /**
    * Number of Trojan files
    */
    @SerializedName("MalwareNum")
    @Expose
    private Long MalwareNum;

    /**
    * Number of cross-region log-in
    */
    @SerializedName("NonlocalLoginNum")
    @Expose
    private Long NonlocalLoginNum;

    /**
    * Number of successful brute force cracking
    */
    @SerializedName("BruteAttackSuccessNum")
    @Expose
    private Long BruteAttackSuccessNum;

    /**
    * Number of vulnerabilities
    */
    @SerializedName("VulNum")
    @Expose
    private Long VulNum;

    /**
    * Number of security baselines
    */
    @SerializedName("BaseLineNum")
    @Expose
    private Long BaseLineNum;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Number of servers online 
     * @return OnlineMachineNum Number of servers online
     */
    public Long getOnlineMachineNum() {
        return this.OnlineMachineNum;
    }

    /**
     * Set Number of servers online
     * @param OnlineMachineNum Number of servers online
     */
    public void setOnlineMachineNum(Long OnlineMachineNum) {
        this.OnlineMachineNum = OnlineMachineNum;
    }

    /**
     * Get Number of professional servers 
     * @return ProVersionMachineNum Number of professional servers
     */
    public Long getProVersionMachineNum() {
        return this.ProVersionMachineNum;
    }

    /**
     * Set Number of professional servers
     * @param ProVersionMachineNum Number of professional servers
     */
    public void setProVersionMachineNum(Long ProVersionMachineNum) {
        this.ProVersionMachineNum = ProVersionMachineNum;
    }

    /**
     * Get Number of Trojan files 
     * @return MalwareNum Number of Trojan files
     */
    public Long getMalwareNum() {
        return this.MalwareNum;
    }

    /**
     * Set Number of Trojan files
     * @param MalwareNum Number of Trojan files
     */
    public void setMalwareNum(Long MalwareNum) {
        this.MalwareNum = MalwareNum;
    }

    /**
     * Get Number of cross-region log-in 
     * @return NonlocalLoginNum Number of cross-region log-in
     */
    public Long getNonlocalLoginNum() {
        return this.NonlocalLoginNum;
    }

    /**
     * Set Number of cross-region log-in
     * @param NonlocalLoginNum Number of cross-region log-in
     */
    public void setNonlocalLoginNum(Long NonlocalLoginNum) {
        this.NonlocalLoginNum = NonlocalLoginNum;
    }

    /**
     * Get Number of successful brute force cracking 
     * @return BruteAttackSuccessNum Number of successful brute force cracking
     */
    public Long getBruteAttackSuccessNum() {
        return this.BruteAttackSuccessNum;
    }

    /**
     * Set Number of successful brute force cracking
     * @param BruteAttackSuccessNum Number of successful brute force cracking
     */
    public void setBruteAttackSuccessNum(Long BruteAttackSuccessNum) {
        this.BruteAttackSuccessNum = BruteAttackSuccessNum;
    }

    /**
     * Get Number of vulnerabilities 
     * @return VulNum Number of vulnerabilities
     */
    public Long getVulNum() {
        return this.VulNum;
    }

    /**
     * Set Number of vulnerabilities
     * @param VulNum Number of vulnerabilities
     */
    public void setVulNum(Long VulNum) {
        this.VulNum = VulNum;
    }

    /**
     * Get Number of security baselines 
     * @return BaseLineNum Number of security baselines
     */
    public Long getBaseLineNum() {
        return this.BaseLineNum;
    }

    /**
     * Set Number of security baselines
     * @param BaseLineNum Number of security baselines
     */
    public void setBaseLineNum(Long BaseLineNum) {
        this.BaseLineNum = BaseLineNum;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeOverviewStatisticsResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeOverviewStatisticsResponse(DescribeOverviewStatisticsResponse source) {
        if (source.OnlineMachineNum != null) {
            this.OnlineMachineNum = new Long(source.OnlineMachineNum);
        }
        if (source.ProVersionMachineNum != null) {
            this.ProVersionMachineNum = new Long(source.ProVersionMachineNum);
        }
        if (source.MalwareNum != null) {
            this.MalwareNum = new Long(source.MalwareNum);
        }
        if (source.NonlocalLoginNum != null) {
            this.NonlocalLoginNum = new Long(source.NonlocalLoginNum);
        }
        if (source.BruteAttackSuccessNum != null) {
            this.BruteAttackSuccessNum = new Long(source.BruteAttackSuccessNum);
        }
        if (source.VulNum != null) {
            this.VulNum = new Long(source.VulNum);
        }
        if (source.BaseLineNum != null) {
            this.BaseLineNum = new Long(source.BaseLineNum);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "OnlineMachineNum", this.OnlineMachineNum);
        this.setParamSimple(map, prefix + "ProVersionMachineNum", this.ProVersionMachineNum);
        this.setParamSimple(map, prefix + "MalwareNum", this.MalwareNum);
        this.setParamSimple(map, prefix + "NonlocalLoginNum", this.NonlocalLoginNum);
        this.setParamSimple(map, prefix + "BruteAttackSuccessNum", this.BruteAttackSuccessNum);
        this.setParamSimple(map, prefix + "VulNum", this.VulNum);
        this.setParamSimple(map, prefix + "BaseLineNum", this.BaseLineNum);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

