/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeRansomDefenseStateResponse extends AbstractModel {

    /**
    * Number of Activated Defense Policies
    */
    @SerializedName("StrategyCount")
    @Expose
    private Long StrategyCount;

    /**
    * Number of Protected Machines
    */
    @SerializedName("MachineCount")
    @Expose
    private Long MachineCount;

    /**
    * Total snapshot capacity
    */
    @SerializedName("SnapshotSize")
    @Expose
    private Long SnapshotSize;

    /**
    * Number of Backup Recovery Tasks
    */
    @SerializedName("RollBackTaskCount")
    @Expose
    private Long RollBackTaskCount;

    /**
    * Number of Snapshot Creation Tasks in Progress
    */
    @SerializedName("ProgressingSnapshotTaskCount")
    @Expose
    private Long ProgressingSnapshotTaskCount;

    /**
    * Number of Backup Recovery Tasks in Progress
    */
    @SerializedName("ProgressingRollBackTaskCount")
    @Expose
    private Long ProgressingRollBackTaskCount;

    /**
    * Total Number of Machines
    */
    @SerializedName("MachineTotal")
    @Expose
    private Long MachineTotal;

    /**
    * Total number of policies
    */
    @SerializedName("StrategyTotal")
    @Expose
    private Long StrategyTotal;

    /**
    * Account Status. 0 - Without Overdue Payment; 1 - With Overdue Payment
    */
    @SerializedName("BalanceStatus")
    @Expose
    private Long BalanceStatus;

    /**
    * Number of Backed-Up Hosts
    */
    @SerializedName("BackupMachineCount")
    @Expose
    private Long BackupMachineCount;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Number of Activated Defense Policies 
     * @return StrategyCount Number of Activated Defense Policies
     */
    public Long getStrategyCount() {
        return this.StrategyCount;
    }

    /**
     * Set Number of Activated Defense Policies
     * @param StrategyCount Number of Activated Defense Policies
     */
    public void setStrategyCount(Long StrategyCount) {
        this.StrategyCount = StrategyCount;
    }

    /**
     * Get Number of Protected Machines 
     * @return MachineCount Number of Protected Machines
     */
    public Long getMachineCount() {
        return this.MachineCount;
    }

    /**
     * Set Number of Protected Machines
     * @param MachineCount Number of Protected Machines
     */
    public void setMachineCount(Long MachineCount) {
        this.MachineCount = MachineCount;
    }

    /**
     * Get Total snapshot capacity 
     * @return SnapshotSize Total snapshot capacity
     */
    public Long getSnapshotSize() {
        return this.SnapshotSize;
    }

    /**
     * Set Total snapshot capacity
     * @param SnapshotSize Total snapshot capacity
     */
    public void setSnapshotSize(Long SnapshotSize) {
        this.SnapshotSize = SnapshotSize;
    }

    /**
     * Get Number of Backup Recovery Tasks 
     * @return RollBackTaskCount Number of Backup Recovery Tasks
     */
    public Long getRollBackTaskCount() {
        return this.RollBackTaskCount;
    }

    /**
     * Set Number of Backup Recovery Tasks
     * @param RollBackTaskCount Number of Backup Recovery Tasks
     */
    public void setRollBackTaskCount(Long RollBackTaskCount) {
        this.RollBackTaskCount = RollBackTaskCount;
    }

    /**
     * Get Number of Snapshot Creation Tasks in Progress 
     * @return ProgressingSnapshotTaskCount Number of Snapshot Creation Tasks in Progress
     */
    public Long getProgressingSnapshotTaskCount() {
        return this.ProgressingSnapshotTaskCount;
    }

    /**
     * Set Number of Snapshot Creation Tasks in Progress
     * @param ProgressingSnapshotTaskCount Number of Snapshot Creation Tasks in Progress
     */
    public void setProgressingSnapshotTaskCount(Long ProgressingSnapshotTaskCount) {
        this.ProgressingSnapshotTaskCount = ProgressingSnapshotTaskCount;
    }

    /**
     * Get Number of Backup Recovery Tasks in Progress 
     * @return ProgressingRollBackTaskCount Number of Backup Recovery Tasks in Progress
     */
    public Long getProgressingRollBackTaskCount() {
        return this.ProgressingRollBackTaskCount;
    }

    /**
     * Set Number of Backup Recovery Tasks in Progress
     * @param ProgressingRollBackTaskCount Number of Backup Recovery Tasks in Progress
     */
    public void setProgressingRollBackTaskCount(Long ProgressingRollBackTaskCount) {
        this.ProgressingRollBackTaskCount = ProgressingRollBackTaskCount;
    }

    /**
     * Get Total Number of Machines 
     * @return MachineTotal Total Number of Machines
     */
    public Long getMachineTotal() {
        return this.MachineTotal;
    }

    /**
     * Set Total Number of Machines
     * @param MachineTotal Total Number of Machines
     */
    public void setMachineTotal(Long MachineTotal) {
        this.MachineTotal = MachineTotal;
    }

    /**
     * Get Total number of policies 
     * @return StrategyTotal Total number of policies
     */
    public Long getStrategyTotal() {
        return this.StrategyTotal;
    }

    /**
     * Set Total number of policies
     * @param StrategyTotal Total number of policies
     */
    public void setStrategyTotal(Long StrategyTotal) {
        this.StrategyTotal = StrategyTotal;
    }

    /**
     * Get Account Status. 0 - Without Overdue Payment; 1 - With Overdue Payment 
     * @return BalanceStatus Account Status. 0 - Without Overdue Payment; 1 - With Overdue Payment
     */
    public Long getBalanceStatus() {
        return this.BalanceStatus;
    }

    /**
     * Set Account Status. 0 - Without Overdue Payment; 1 - With Overdue Payment
     * @param BalanceStatus Account Status. 0 - Without Overdue Payment; 1 - With Overdue Payment
     */
    public void setBalanceStatus(Long BalanceStatus) {
        this.BalanceStatus = BalanceStatus;
    }

    /**
     * Get Number of Backed-Up Hosts 
     * @return BackupMachineCount Number of Backed-Up Hosts
     */
    public Long getBackupMachineCount() {
        return this.BackupMachineCount;
    }

    /**
     * Set Number of Backed-Up Hosts
     * @param BackupMachineCount Number of Backed-Up Hosts
     */
    public void setBackupMachineCount(Long BackupMachineCount) {
        this.BackupMachineCount = BackupMachineCount;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeRansomDefenseStateResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeRansomDefenseStateResponse(DescribeRansomDefenseStateResponse source) {
        if (source.StrategyCount != null) {
            this.StrategyCount = new Long(source.StrategyCount);
        }
        if (source.MachineCount != null) {
            this.MachineCount = new Long(source.MachineCount);
        }
        if (source.SnapshotSize != null) {
            this.SnapshotSize = new Long(source.SnapshotSize);
        }
        if (source.RollBackTaskCount != null) {
            this.RollBackTaskCount = new Long(source.RollBackTaskCount);
        }
        if (source.ProgressingSnapshotTaskCount != null) {
            this.ProgressingSnapshotTaskCount = new Long(source.ProgressingSnapshotTaskCount);
        }
        if (source.ProgressingRollBackTaskCount != null) {
            this.ProgressingRollBackTaskCount = new Long(source.ProgressingRollBackTaskCount);
        }
        if (source.MachineTotal != null) {
            this.MachineTotal = new Long(source.MachineTotal);
        }
        if (source.StrategyTotal != null) {
            this.StrategyTotal = new Long(source.StrategyTotal);
        }
        if (source.BalanceStatus != null) {
            this.BalanceStatus = new Long(source.BalanceStatus);
        }
        if (source.BackupMachineCount != null) {
            this.BackupMachineCount = new Long(source.BackupMachineCount);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "StrategyCount", this.StrategyCount);
        this.setParamSimple(map, prefix + "MachineCount", this.MachineCount);
        this.setParamSimple(map, prefix + "SnapshotSize", this.SnapshotSize);
        this.setParamSimple(map, prefix + "RollBackTaskCount", this.RollBackTaskCount);
        this.setParamSimple(map, prefix + "ProgressingSnapshotTaskCount", this.ProgressingSnapshotTaskCount);
        this.setParamSimple(map, prefix + "ProgressingRollBackTaskCount", this.ProgressingRollBackTaskCount);
        this.setParamSimple(map, prefix + "MachineTotal", this.MachineTotal);
        this.setParamSimple(map, prefix + "StrategyTotal", this.StrategyTotal);
        this.setParamSimple(map, prefix + "BalanceStatus", this.BalanceStatus);
        this.setParamSimple(map, prefix + "BackupMachineCount", this.BackupMachineCount);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

