/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeRansomDefenseTrendResponse extends AbstractModel {

    /**
    * Number of Ransom Incidents
    */
    @SerializedName("EventCount")
    @Expose
    private Long EventCount;

    /**
    * Number of Affected Industries
    */
    @SerializedName("IndustryCount")
    @Expose
    private Long IndustryCount;

    /**
    * Number of Companies with Ransom Protection
    */
    @SerializedName("CompanyCount")
    @Expose
    private Long CompanyCount;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Number of Ransom Incidents 
     * @return EventCount Number of Ransom Incidents
     */
    public Long getEventCount() {
        return this.EventCount;
    }

    /**
     * Set Number of Ransom Incidents
     * @param EventCount Number of Ransom Incidents
     */
    public void setEventCount(Long EventCount) {
        this.EventCount = EventCount;
    }

    /**
     * Get Number of Affected Industries 
     * @return IndustryCount Number of Affected Industries
     */
    public Long getIndustryCount() {
        return this.IndustryCount;
    }

    /**
     * Set Number of Affected Industries
     * @param IndustryCount Number of Affected Industries
     */
    public void setIndustryCount(Long IndustryCount) {
        this.IndustryCount = IndustryCount;
    }

    /**
     * Get Number of Companies with Ransom Protection 
     * @return CompanyCount Number of Companies with Ransom Protection
     */
    public Long getCompanyCount() {
        return this.CompanyCount;
    }

    /**
     * Set Number of Companies with Ransom Protection
     * @param CompanyCount Number of Companies with Ransom Protection
     */
    public void setCompanyCount(Long CompanyCount) {
        this.CompanyCount = CompanyCount;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeRansomDefenseTrendResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeRansomDefenseTrendResponse(DescribeRansomDefenseTrendResponse source) {
        if (source.EventCount != null) {
            this.EventCount = new Long(source.EventCount);
        }
        if (source.IndustryCount != null) {
            this.IndustryCount = new Long(source.IndustryCount);
        }
        if (source.CompanyCount != null) {
            this.CompanyCount = new Long(source.CompanyCount);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "EventCount", this.EventCount);
        this.setParamSimple(map, prefix + "IndustryCount", this.IndustryCount);
        this.setParamSimple(map, prefix + "CompanyCount", this.CompanyCount);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

