/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeScanMalwareScheduleResponse extends AbstractModel {

    /**
    * Scan progress (unit: %)
    */
    @SerializedName("Schedule")
    @Expose
    private Long Schedule;

    /**
    * Number of risk files, which is only available after the scan is completed.
    */
    @SerializedName("RiskFileNumber")
    @Expose
    private Long RiskFileNumber;

    /**
    * Whether scan in progress
    */
    @SerializedName("IsSchedule")
    @Expose
    private Boolean IsSchedule;

    /**
    * 0 - never scanned; 1 - scan in progress; 2 - scan completed; 3 - stop in progress; 4 - stop completed
    */
    @SerializedName("ScanStatus")
    @Expose
    private Long ScanStatus;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Scan progress (unit: %) 
     * @return Schedule Scan progress (unit: %)
     */
    public Long getSchedule() {
        return this.Schedule;
    }

    /**
     * Set Scan progress (unit: %)
     * @param Schedule Scan progress (unit: %)
     */
    public void setSchedule(Long Schedule) {
        this.Schedule = Schedule;
    }

    /**
     * Get Number of risk files, which is only available after the scan is completed. 
     * @return RiskFileNumber Number of risk files, which is only available after the scan is completed.
     */
    public Long getRiskFileNumber() {
        return this.RiskFileNumber;
    }

    /**
     * Set Number of risk files, which is only available after the scan is completed.
     * @param RiskFileNumber Number of risk files, which is only available after the scan is completed.
     */
    public void setRiskFileNumber(Long RiskFileNumber) {
        this.RiskFileNumber = RiskFileNumber;
    }

    /**
     * Get Whether scan in progress 
     * @return IsSchedule Whether scan in progress
     */
    public Boolean getIsSchedule() {
        return this.IsSchedule;
    }

    /**
     * Set Whether scan in progress
     * @param IsSchedule Whether scan in progress
     */
    public void setIsSchedule(Boolean IsSchedule) {
        this.IsSchedule = IsSchedule;
    }

    /**
     * Get 0 - never scanned; 1 - scan in progress; 2 - scan completed; 3 - stop in progress; 4 - stop completed 
     * @return ScanStatus 0 - never scanned; 1 - scan in progress; 2 - scan completed; 3 - stop in progress; 4 - stop completed
     */
    public Long getScanStatus() {
        return this.ScanStatus;
    }

    /**
     * Set 0 - never scanned; 1 - scan in progress; 2 - scan completed; 3 - stop in progress; 4 - stop completed
     * @param ScanStatus 0 - never scanned; 1 - scan in progress; 2 - scan completed; 3 - stop in progress; 4 - stop completed
     */
    public void setScanStatus(Long ScanStatus) {
        this.ScanStatus = ScanStatus;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeScanMalwareScheduleResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeScanMalwareScheduleResponse(DescribeScanMalwareScheduleResponse source) {
        if (source.Schedule != null) {
            this.Schedule = new Long(source.Schedule);
        }
        if (source.RiskFileNumber != null) {
            this.RiskFileNumber = new Long(source.RiskFileNumber);
        }
        if (source.IsSchedule != null) {
            this.IsSchedule = new Boolean(source.IsSchedule);
        }
        if (source.ScanStatus != null) {
            this.ScanStatus = new Long(source.ScanStatus);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Schedule", this.Schedule);
        this.setParamSimple(map, prefix + "RiskFileNumber", this.RiskFileNumber);
        this.setParamSimple(map, prefix + "IsSchedule", this.IsSchedule);
        this.setParamSimple(map, prefix + "ScanStatus", this.ScanStatus);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

