/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeScanTaskDetailsResponse extends AbstractModel {

    /**
    * List of scan task information
    */
    @SerializedName("ScanTaskDetailList")
    @Expose
    private ScanTaskDetails [] ScanTaskDetailList;

    /**
    * Total number
    */
    @SerializedName("TotalCount")
    @Expose
    private Long TotalCount;

    /**
    * Total number of scanned machines
    */
    @SerializedName("ScanMachineCount")
    @Expose
    private Long ScanMachineCount;

    /**
    * Number of machines with risks detected
    */
    @SerializedName("RiskMachineCount")
    @Expose
    private Long RiskMachineCount;

    /**
    * Scan start time
    */
    @SerializedName("ScanBeginTime")
    @Expose
    private String ScanBeginTime;

    /**
    * Scan end time
    */
    @SerializedName("ScanEndTime")
    @Expose
    private String ScanEndTime;

    /**
    * Scan time
    */
    @SerializedName("ScanTime")
    @Expose
    private Long ScanTime;

    /**
    * Scan progress
    */
    @SerializedName("ScanProgress")
    @Expose
    private Long ScanProgress;

    /**
    * Remaining scan time
    */
    @SerializedName("ScanLeftTime")
    @Expose
    private Long ScanLeftTime;

    /**
    * Scan content
    */
    @SerializedName("ScanContent")
    @Expose
    private String [] ScanContent;

    /**
    * Vulnerability information
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("VulInfo")
    @Expose
    private VulDetailInfo [] VulInfo;

    /**
    * Number of risk events
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("RiskEventCount")
    @Expose
    private Long RiskEventCount;

    /**
    * 0: one-click scan; 1: scheduled scan.Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Type")
    @Expose
    private Long Type;

    /**
    * Whether all tasks are being stopped. true: yes.Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("StoppingAll")
    @Expose
    private Boolean StoppingAll;

    /**
    * Number of vulnerabilities scanned
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("VulCount")
    @Expose
    private Long VulCount;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get List of scan task information 
     * @return ScanTaskDetailList List of scan task information
     */
    public ScanTaskDetails [] getScanTaskDetailList() {
        return this.ScanTaskDetailList;
    }

    /**
     * Set List of scan task information
     * @param ScanTaskDetailList List of scan task information
     */
    public void setScanTaskDetailList(ScanTaskDetails [] ScanTaskDetailList) {
        this.ScanTaskDetailList = ScanTaskDetailList;
    }

    /**
     * Get Total number 
     * @return TotalCount Total number
     */
    public Long getTotalCount() {
        return this.TotalCount;
    }

    /**
     * Set Total number
     * @param TotalCount Total number
     */
    public void setTotalCount(Long TotalCount) {
        this.TotalCount = TotalCount;
    }

    /**
     * Get Total number of scanned machines 
     * @return ScanMachineCount Total number of scanned machines
     */
    public Long getScanMachineCount() {
        return this.ScanMachineCount;
    }

    /**
     * Set Total number of scanned machines
     * @param ScanMachineCount Total number of scanned machines
     */
    public void setScanMachineCount(Long ScanMachineCount) {
        this.ScanMachineCount = ScanMachineCount;
    }

    /**
     * Get Number of machines with risks detected 
     * @return RiskMachineCount Number of machines with risks detected
     */
    public Long getRiskMachineCount() {
        return this.RiskMachineCount;
    }

    /**
     * Set Number of machines with risks detected
     * @param RiskMachineCount Number of machines with risks detected
     */
    public void setRiskMachineCount(Long RiskMachineCount) {
        this.RiskMachineCount = RiskMachineCount;
    }

    /**
     * Get Scan start time 
     * @return ScanBeginTime Scan start time
     */
    public String getScanBeginTime() {
        return this.ScanBeginTime;
    }

    /**
     * Set Scan start time
     * @param ScanBeginTime Scan start time
     */
    public void setScanBeginTime(String ScanBeginTime) {
        this.ScanBeginTime = ScanBeginTime;
    }

    /**
     * Get Scan end time 
     * @return ScanEndTime Scan end time
     */
    public String getScanEndTime() {
        return this.ScanEndTime;
    }

    /**
     * Set Scan end time
     * @param ScanEndTime Scan end time
     */
    public void setScanEndTime(String ScanEndTime) {
        this.ScanEndTime = ScanEndTime;
    }

    /**
     * Get Scan time 
     * @return ScanTime Scan time
     */
    public Long getScanTime() {
        return this.ScanTime;
    }

    /**
     * Set Scan time
     * @param ScanTime Scan time
     */
    public void setScanTime(Long ScanTime) {
        this.ScanTime = ScanTime;
    }

    /**
     * Get Scan progress 
     * @return ScanProgress Scan progress
     */
    public Long getScanProgress() {
        return this.ScanProgress;
    }

    /**
     * Set Scan progress
     * @param ScanProgress Scan progress
     */
    public void setScanProgress(Long ScanProgress) {
        this.ScanProgress = ScanProgress;
    }

    /**
     * Get Remaining scan time 
     * @return ScanLeftTime Remaining scan time
     */
    public Long getScanLeftTime() {
        return this.ScanLeftTime;
    }

    /**
     * Set Remaining scan time
     * @param ScanLeftTime Remaining scan time
     */
    public void setScanLeftTime(Long ScanLeftTime) {
        this.ScanLeftTime = ScanLeftTime;
    }

    /**
     * Get Scan content 
     * @return ScanContent Scan content
     */
    public String [] getScanContent() {
        return this.ScanContent;
    }

    /**
     * Set Scan content
     * @param ScanContent Scan content
     */
    public void setScanContent(String [] ScanContent) {
        this.ScanContent = ScanContent;
    }

    /**
     * Get Vulnerability information
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return VulInfo Vulnerability information
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public VulDetailInfo [] getVulInfo() {
        return this.VulInfo;
    }

    /**
     * Set Vulnerability information
Note: This field may return null, indicating that no valid values can be obtained.
     * @param VulInfo Vulnerability information
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setVulInfo(VulDetailInfo [] VulInfo) {
        this.VulInfo = VulInfo;
    }

    /**
     * Get Number of risk events
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return RiskEventCount Number of risk events
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getRiskEventCount() {
        return this.RiskEventCount;
    }

    /**
     * Set Number of risk events
Note: This field may return null, indicating that no valid values can be obtained.
     * @param RiskEventCount Number of risk events
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setRiskEventCount(Long RiskEventCount) {
        this.RiskEventCount = RiskEventCount;
    }

    /**
     * Get 0: one-click scan; 1: scheduled scan.Note: This field may return null, indicating that no valid values can be obtained. 
     * @return Type 0: one-click scan; 1: scheduled scan.Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getType() {
        return this.Type;
    }

    /**
     * Set 0: one-click scan; 1: scheduled scan.Note: This field may return null, indicating that no valid values can be obtained.
     * @param Type 0: one-click scan; 1: scheduled scan.Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setType(Long Type) {
        this.Type = Type;
    }

    /**
     * Get Whether all tasks are being stopped. true: yes.Note: This field may return null, indicating that no valid values can be obtained. 
     * @return StoppingAll Whether all tasks are being stopped. true: yes.Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Boolean getStoppingAll() {
        return this.StoppingAll;
    }

    /**
     * Set Whether all tasks are being stopped. true: yes.Note: This field may return null, indicating that no valid values can be obtained.
     * @param StoppingAll Whether all tasks are being stopped. true: yes.Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setStoppingAll(Boolean StoppingAll) {
        this.StoppingAll = StoppingAll;
    }

    /**
     * Get Number of vulnerabilities scanned
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return VulCount Number of vulnerabilities scanned
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getVulCount() {
        return this.VulCount;
    }

    /**
     * Set Number of vulnerabilities scanned
Note: This field may return null, indicating that no valid values can be obtained.
     * @param VulCount Number of vulnerabilities scanned
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setVulCount(Long VulCount) {
        this.VulCount = VulCount;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeScanTaskDetailsResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeScanTaskDetailsResponse(DescribeScanTaskDetailsResponse source) {
        if (source.ScanTaskDetailList != null) {
            this.ScanTaskDetailList = new ScanTaskDetails[source.ScanTaskDetailList.length];
            for (int i = 0; i < source.ScanTaskDetailList.length; i++) {
                this.ScanTaskDetailList[i] = new ScanTaskDetails(source.ScanTaskDetailList[i]);
            }
        }
        if (source.TotalCount != null) {
            this.TotalCount = new Long(source.TotalCount);
        }
        if (source.ScanMachineCount != null) {
            this.ScanMachineCount = new Long(source.ScanMachineCount);
        }
        if (source.RiskMachineCount != null) {
            this.RiskMachineCount = new Long(source.RiskMachineCount);
        }
        if (source.ScanBeginTime != null) {
            this.ScanBeginTime = new String(source.ScanBeginTime);
        }
        if (source.ScanEndTime != null) {
            this.ScanEndTime = new String(source.ScanEndTime);
        }
        if (source.ScanTime != null) {
            this.ScanTime = new Long(source.ScanTime);
        }
        if (source.ScanProgress != null) {
            this.ScanProgress = new Long(source.ScanProgress);
        }
        if (source.ScanLeftTime != null) {
            this.ScanLeftTime = new Long(source.ScanLeftTime);
        }
        if (source.ScanContent != null) {
            this.ScanContent = new String[source.ScanContent.length];
            for (int i = 0; i < source.ScanContent.length; i++) {
                this.ScanContent[i] = new String(source.ScanContent[i]);
            }
        }
        if (source.VulInfo != null) {
            this.VulInfo = new VulDetailInfo[source.VulInfo.length];
            for (int i = 0; i < source.VulInfo.length; i++) {
                this.VulInfo[i] = new VulDetailInfo(source.VulInfo[i]);
            }
        }
        if (source.RiskEventCount != null) {
            this.RiskEventCount = new Long(source.RiskEventCount);
        }
        if (source.Type != null) {
            this.Type = new Long(source.Type);
        }
        if (source.StoppingAll != null) {
            this.StoppingAll = new Boolean(source.StoppingAll);
        }
        if (source.VulCount != null) {
            this.VulCount = new Long(source.VulCount);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "ScanTaskDetailList.", this.ScanTaskDetailList);
        this.setParamSimple(map, prefix + "TotalCount", this.TotalCount);
        this.setParamSimple(map, prefix + "ScanMachineCount", this.ScanMachineCount);
        this.setParamSimple(map, prefix + "RiskMachineCount", this.RiskMachineCount);
        this.setParamSimple(map, prefix + "ScanBeginTime", this.ScanBeginTime);
        this.setParamSimple(map, prefix + "ScanEndTime", this.ScanEndTime);
        this.setParamSimple(map, prefix + "ScanTime", this.ScanTime);
        this.setParamSimple(map, prefix + "ScanProgress", this.ScanProgress);
        this.setParamSimple(map, prefix + "ScanLeftTime", this.ScanLeftTime);
        this.setParamArraySimple(map, prefix + "ScanContent.", this.ScanContent);
        this.setParamArrayObj(map, prefix + "VulInfo.", this.VulInfo);
        this.setParamSimple(map, prefix + "RiskEventCount", this.RiskEventCount);
        this.setParamSimple(map, prefix + "Type", this.Type);
        this.setParamSimple(map, prefix + "StoppingAll", this.StoppingAll);
        this.setParamSimple(map, prefix + "VulCount", this.VulCount);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

