/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeScanVulSettingResponse extends AbstractModel {

    /**
    * Vulnerability type: 1 - web-cms vulnerabilities; 2 - application vulnerabilities; 4 - Linux software vulnerabilities; 5 - Windows system vulnerabilities
    */
    @SerializedName("VulCategories")
    @Expose
    private String VulCategories;

    /**
    * Severity level: 1 - low-risk; 2 - medium-risk; 3 - high-risk; 4 - critical (multiple selections are separated by English commas)
    */
    @SerializedName("VulLevels")
    @Expose
    private String VulLevels;

    /**
    * Regular detection interval (days)
    */
    @SerializedName("TimerInterval")
    @Expose
    private Long TimerInterval;

    /**
    * Regular detection time, such as 00:00
    */
    @SerializedName("TimerTime")
    @Expose
    private String TimerTime;

    /**
    * Whether an emergency vulnerability: 0 - no; 1 - yes
    */
    @SerializedName("VulEmergency")
    @Expose
    private Long VulEmergency;

    /**
    * Start time
    */
    @SerializedName("StartTime")
    @Expose
    private String StartTime;

    /**
    * Whether enabled
    */
    @SerializedName("EnableScan")
    @Expose
    private Long EnableScan;

    /**
    * End time
    */
    @SerializedName("EndTime")
    @Expose
    private String EndTime;

    /**
    * One-click scan timeout duration, such as 1800 seconds
    */
    @SerializedName("ClickTimeout")
    @Expose
    private Long ClickTimeout;

    /**
    * If empty, scan hosts with all Professional, Premium, and General Discount editions by default; if not empty, only scan the selected hosts.
    */
    @SerializedName("Uuids")
    @Expose
    private String [] Uuids;

    /**
    * 
    */
    @SerializedName("ScanMethod")
    @Expose
    private Long ScanMethod;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Vulnerability type: 1 - web-cms vulnerabilities; 2 - application vulnerabilities; 4 - Linux software vulnerabilities; 5 - Windows system vulnerabilities 
     * @return VulCategories Vulnerability type: 1 - web-cms vulnerabilities; 2 - application vulnerabilities; 4 - Linux software vulnerabilities; 5 - Windows system vulnerabilities
     */
    public String getVulCategories() {
        return this.VulCategories;
    }

    /**
     * Set Vulnerability type: 1 - web-cms vulnerabilities; 2 - application vulnerabilities; 4 - Linux software vulnerabilities; 5 - Windows system vulnerabilities
     * @param VulCategories Vulnerability type: 1 - web-cms vulnerabilities; 2 - application vulnerabilities; 4 - Linux software vulnerabilities; 5 - Windows system vulnerabilities
     */
    public void setVulCategories(String VulCategories) {
        this.VulCategories = VulCategories;
    }

    /**
     * Get Severity level: 1 - low-risk; 2 - medium-risk; 3 - high-risk; 4 - critical (multiple selections are separated by English commas) 
     * @return VulLevels Severity level: 1 - low-risk; 2 - medium-risk; 3 - high-risk; 4 - critical (multiple selections are separated by English commas)
     */
    public String getVulLevels() {
        return this.VulLevels;
    }

    /**
     * Set Severity level: 1 - low-risk; 2 - medium-risk; 3 - high-risk; 4 - critical (multiple selections are separated by English commas)
     * @param VulLevels Severity level: 1 - low-risk; 2 - medium-risk; 3 - high-risk; 4 - critical (multiple selections are separated by English commas)
     */
    public void setVulLevels(String VulLevels) {
        this.VulLevels = VulLevels;
    }

    /**
     * Get Regular detection interval (days) 
     * @return TimerInterval Regular detection interval (days)
     */
    public Long getTimerInterval() {
        return this.TimerInterval;
    }

    /**
     * Set Regular detection interval (days)
     * @param TimerInterval Regular detection interval (days)
     */
    public void setTimerInterval(Long TimerInterval) {
        this.TimerInterval = TimerInterval;
    }

    /**
     * Get Regular detection time, such as 00:00 
     * @return TimerTime Regular detection time, such as 00:00
     */
    public String getTimerTime() {
        return this.TimerTime;
    }

    /**
     * Set Regular detection time, such as 00:00
     * @param TimerTime Regular detection time, such as 00:00
     */
    public void setTimerTime(String TimerTime) {
        this.TimerTime = TimerTime;
    }

    /**
     * Get Whether an emergency vulnerability: 0 - no; 1 - yes 
     * @return VulEmergency Whether an emergency vulnerability: 0 - no; 1 - yes
     */
    public Long getVulEmergency() {
        return this.VulEmergency;
    }

    /**
     * Set Whether an emergency vulnerability: 0 - no; 1 - yes
     * @param VulEmergency Whether an emergency vulnerability: 0 - no; 1 - yes
     */
    public void setVulEmergency(Long VulEmergency) {
        this.VulEmergency = VulEmergency;
    }

    /**
     * Get Start time 
     * @return StartTime Start time
     */
    public String getStartTime() {
        return this.StartTime;
    }

    /**
     * Set Start time
     * @param StartTime Start time
     */
    public void setStartTime(String StartTime) {
        this.StartTime = StartTime;
    }

    /**
     * Get Whether enabled 
     * @return EnableScan Whether enabled
     */
    public Long getEnableScan() {
        return this.EnableScan;
    }

    /**
     * Set Whether enabled
     * @param EnableScan Whether enabled
     */
    public void setEnableScan(Long EnableScan) {
        this.EnableScan = EnableScan;
    }

    /**
     * Get End time 
     * @return EndTime End time
     */
    public String getEndTime() {
        return this.EndTime;
    }

    /**
     * Set End time
     * @param EndTime End time
     */
    public void setEndTime(String EndTime) {
        this.EndTime = EndTime;
    }

    /**
     * Get One-click scan timeout duration, such as 1800 seconds 
     * @return ClickTimeout One-click scan timeout duration, such as 1800 seconds
     */
    public Long getClickTimeout() {
        return this.ClickTimeout;
    }

    /**
     * Set One-click scan timeout duration, such as 1800 seconds
     * @param ClickTimeout One-click scan timeout duration, such as 1800 seconds
     */
    public void setClickTimeout(Long ClickTimeout) {
        this.ClickTimeout = ClickTimeout;
    }

    /**
     * Get If empty, scan hosts with all Professional, Premium, and General Discount editions by default; if not empty, only scan the selected hosts. 
     * @return Uuids If empty, scan hosts with all Professional, Premium, and General Discount editions by default; if not empty, only scan the selected hosts.
     */
    public String [] getUuids() {
        return this.Uuids;
    }

    /**
     * Set If empty, scan hosts with all Professional, Premium, and General Discount editions by default; if not empty, only scan the selected hosts.
     * @param Uuids If empty, scan hosts with all Professional, Premium, and General Discount editions by default; if not empty, only scan the selected hosts.
     */
    public void setUuids(String [] Uuids) {
        this.Uuids = Uuids;
    }

    /**
     * Get  
     * @return ScanMethod 
     */
    public Long getScanMethod() {
        return this.ScanMethod;
    }

    /**
     * Set 
     * @param ScanMethod 
     */
    public void setScanMethod(Long ScanMethod) {
        this.ScanMethod = ScanMethod;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeScanVulSettingResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeScanVulSettingResponse(DescribeScanVulSettingResponse source) {
        if (source.VulCategories != null) {
            this.VulCategories = new String(source.VulCategories);
        }
        if (source.VulLevels != null) {
            this.VulLevels = new String(source.VulLevels);
        }
        if (source.TimerInterval != null) {
            this.TimerInterval = new Long(source.TimerInterval);
        }
        if (source.TimerTime != null) {
            this.TimerTime = new String(source.TimerTime);
        }
        if (source.VulEmergency != null) {
            this.VulEmergency = new Long(source.VulEmergency);
        }
        if (source.StartTime != null) {
            this.StartTime = new String(source.StartTime);
        }
        if (source.EnableScan != null) {
            this.EnableScan = new Long(source.EnableScan);
        }
        if (source.EndTime != null) {
            this.EndTime = new String(source.EndTime);
        }
        if (source.ClickTimeout != null) {
            this.ClickTimeout = new Long(source.ClickTimeout);
        }
        if (source.Uuids != null) {
            this.Uuids = new String[source.Uuids.length];
            for (int i = 0; i < source.Uuids.length; i++) {
                this.Uuids[i] = new String(source.Uuids[i]);
            }
        }
        if (source.ScanMethod != null) {
            this.ScanMethod = new Long(source.ScanMethod);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "VulCategories", this.VulCategories);
        this.setParamSimple(map, prefix + "VulLevels", this.VulLevels);
        this.setParamSimple(map, prefix + "TimerInterval", this.TimerInterval);
        this.setParamSimple(map, prefix + "TimerTime", this.TimerTime);
        this.setParamSimple(map, prefix + "VulEmergency", this.VulEmergency);
        this.setParamSimple(map, prefix + "StartTime", this.StartTime);
        this.setParamSimple(map, prefix + "EnableScan", this.EnableScan);
        this.setParamSimple(map, prefix + "EndTime", this.EndTime);
        this.setParamSimple(map, prefix + "ClickTimeout", this.ClickTimeout);
        this.setParamArraySimple(map, prefix + "Uuids.", this.Uuids);
        this.setParamSimple(map, prefix + "ScanMethod", this.ScanMethod);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

