/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeScreenGeneralStatResponse extends AbstractModel {

    /**
    * Value of name: online, shutdown/offline, not installed
Value: indicates the corresponding quantity
    */
    @SerializedName("Machines")
    @Expose
    private ScreenNameValue [] Machines;

    /**
    * Value of name: Ultimate Edition, Pro Edition, Basic Edition
Value: indicates the corresponding number
    */
    @SerializedName("Protection")
    @Expose
    private ScreenNameValue [] Protection;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Value of name: online, shutdown/offline, not installed
Value: indicates the corresponding quantity 
     * @return Machines Value of name: online, shutdown/offline, not installed
Value: indicates the corresponding quantity
     */
    public ScreenNameValue [] getMachines() {
        return this.Machines;
    }

    /**
     * Set Value of name: online, shutdown/offline, not installed
Value: indicates the corresponding quantity
     * @param Machines Value of name: online, shutdown/offline, not installed
Value: indicates the corresponding quantity
     */
    public void setMachines(ScreenNameValue [] Machines) {
        this.Machines = Machines;
    }

    /**
     * Get Value of name: Ultimate Edition, Pro Edition, Basic Edition
Value: indicates the corresponding number 
     * @return Protection Value of name: Ultimate Edition, Pro Edition, Basic Edition
Value: indicates the corresponding number
     */
    public ScreenNameValue [] getProtection() {
        return this.Protection;
    }

    /**
     * Set Value of name: Ultimate Edition, Pro Edition, Basic Edition
Value: indicates the corresponding number
     * @param Protection Value of name: Ultimate Edition, Pro Edition, Basic Edition
Value: indicates the corresponding number
     */
    public void setProtection(ScreenNameValue [] Protection) {
        this.Protection = Protection;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeScreenGeneralStatResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeScreenGeneralStatResponse(DescribeScreenGeneralStatResponse source) {
        if (source.Machines != null) {
            this.Machines = new ScreenNameValue[source.Machines.length];
            for (int i = 0; i < source.Machines.length; i++) {
                this.Machines[i] = new ScreenNameValue(source.Machines[i]);
            }
        }
        if (source.Protection != null) {
            this.Protection = new ScreenNameValue[source.Protection.length];
            for (int i = 0; i < source.Protection.length; i++) {
                this.Protection[i] = new ScreenNameValue(source.Protection[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "Machines.", this.Machines);
        this.setParamArrayObj(map, prefix + "Protection.", this.Protection);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

