/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeScreenHostInvasionResponse extends AbstractModel {

    /**
    * List of network attack event
    */
    @SerializedName("DefendAttackLog")
    @Expose
    private ScreenDefendAttackLog [] DefendAttackLog;

    /**
    * List of intrusion detection event
    */
    @SerializedName("InvasionEvents")
    @Expose
    private ScreenInvasion [] InvasionEvents;

    /**
    * List of vulnerability event
    */
    @SerializedName("Vul")
    @Expose
    private ScreenVulInfo [] Vul;

    /**
    * List of baseline event
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Baseline")
    @Expose
    private ScreenBaselineInfo [] Baseline;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get List of network attack event 
     * @return DefendAttackLog List of network attack event
     */
    public ScreenDefendAttackLog [] getDefendAttackLog() {
        return this.DefendAttackLog;
    }

    /**
     * Set List of network attack event
     * @param DefendAttackLog List of network attack event
     */
    public void setDefendAttackLog(ScreenDefendAttackLog [] DefendAttackLog) {
        this.DefendAttackLog = DefendAttackLog;
    }

    /**
     * Get List of intrusion detection event 
     * @return InvasionEvents List of intrusion detection event
     */
    public ScreenInvasion [] getInvasionEvents() {
        return this.InvasionEvents;
    }

    /**
     * Set List of intrusion detection event
     * @param InvasionEvents List of intrusion detection event
     */
    public void setInvasionEvents(ScreenInvasion [] InvasionEvents) {
        this.InvasionEvents = InvasionEvents;
    }

    /**
     * Get List of vulnerability event 
     * @return Vul List of vulnerability event
     */
    public ScreenVulInfo [] getVul() {
        return this.Vul;
    }

    /**
     * Set List of vulnerability event
     * @param Vul List of vulnerability event
     */
    public void setVul(ScreenVulInfo [] Vul) {
        this.Vul = Vul;
    }

    /**
     * Get List of baseline event
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return Baseline List of baseline event
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public ScreenBaselineInfo [] getBaseline() {
        return this.Baseline;
    }

    /**
     * Set List of baseline event
Note: This field may return null, indicating that no valid values can be obtained.
     * @param Baseline List of baseline event
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setBaseline(ScreenBaselineInfo [] Baseline) {
        this.Baseline = Baseline;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeScreenHostInvasionResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeScreenHostInvasionResponse(DescribeScreenHostInvasionResponse source) {
        if (source.DefendAttackLog != null) {
            this.DefendAttackLog = new ScreenDefendAttackLog[source.DefendAttackLog.length];
            for (int i = 0; i < source.DefendAttackLog.length; i++) {
                this.DefendAttackLog[i] = new ScreenDefendAttackLog(source.DefendAttackLog[i]);
            }
        }
        if (source.InvasionEvents != null) {
            this.InvasionEvents = new ScreenInvasion[source.InvasionEvents.length];
            for (int i = 0; i < source.InvasionEvents.length; i++) {
                this.InvasionEvents[i] = new ScreenInvasion(source.InvasionEvents[i]);
            }
        }
        if (source.Vul != null) {
            this.Vul = new ScreenVulInfo[source.Vul.length];
            for (int i = 0; i < source.Vul.length; i++) {
                this.Vul[i] = new ScreenVulInfo(source.Vul[i]);
            }
        }
        if (source.Baseline != null) {
            this.Baseline = new ScreenBaselineInfo[source.Baseline.length];
            for (int i = 0; i < source.Baseline.length; i++) {
                this.Baseline[i] = new ScreenBaselineInfo(source.Baseline[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "DefendAttackLog.", this.DefendAttackLog);
        this.setParamArrayObj(map, prefix + "InvasionEvents.", this.InvasionEvents);
        this.setParamArrayObj(map, prefix + "Vul.", this.Vul);
        this.setParamArrayObj(map, prefix + "Baseline.", this.Baseline);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

