/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeSecurityEventStatResponse extends AbstractModel {

    /**
    * Trojan event statistics
    */
    @SerializedName("MalwareStat")
    @Expose
    private EventStat MalwareStat;

    /**
    * Statistics of cross-region log-in events
    */
    @SerializedName("HostLoginStat")
    @Expose
    private EventStat HostLoginStat;

    /**
    * Statistics of brute force cracking events
    */
    @SerializedName("BruteAttackStat")
    @Expose
    private EventStat BruteAttackStat;

    /**
    * Malicious request event statistics
    */
    @SerializedName("MaliciousRequestStat")
    @Expose
    private EventStat MaliciousRequestStat;

    /**
    * Statistics of local privilege escalation events
    */
    @SerializedName("PrivilegeStat")
    @Expose
    private EventStat PrivilegeStat;

    /**
    * Reverse shell event statistics
    */
    @SerializedName("ReverseShellStat")
    @Expose
    private EventStat ReverseShellStat;

    /**
    * Statistics of high-risk command events
    */
    @SerializedName("HighRiskBashStat")
    @Expose
    private EventStat HighRiskBashStat;

    /**
    * Network attack event statistics
    */
    @SerializedName("AttackLogsStat")
    @Expose
    private EventStat AttackLogsStat;

    /**
    * Statistics of high-risk vulnerability events
    */
    @SerializedName("VulHighStat")
    @Expose
    private EventStat VulHighStat;

    /**
    * Statistics of medium-risk vulnerability events
    */
    @SerializedName("VulNormalStat")
    @Expose
    private EventStat VulNormalStat;

    /**
    * Statistics of low-risk vulnerability events
    */
    @SerializedName("VulLowStat")
    @Expose
    private EventStat VulLowStat;

    /**
    * Statistics of high-risk baseline vulnerability events
    */
    @SerializedName("BaselineHighStat")
    @Expose
    private EventStat BaselineHighStat;

    /**
    * Statistics of medium-risk baseline vulnerability events
    */
    @SerializedName("BaselineNormalStat")
    @Expose
    private EventStat BaselineNormalStat;

    /**
    * Statistics of low-risk baseline vulnerability events
    */
    @SerializedName("BaselineLowStat")
    @Expose
    private EventStat BaselineLowStat;

    /**
    * Total number of machines with unfixed security events
    */
    @SerializedName("MachineTotalAffectNum")
    @Expose
    private Long MachineTotalAffectNum;

    /**
    * Total number of machines with unfixed intrusion security events
    */
    @SerializedName("InvasionTotalAffectNum")
    @Expose
    private Long InvasionTotalAffectNum;

    /**
    * Total number of machines with unfixed vulnerability security events
    */
    @SerializedName("VulTotalAffectNum")
    @Expose
    private Long VulTotalAffectNum;

    /**
    * Total number of machines with unfixed baseline security events
    */
    @SerializedName("BaseLineTotalAffectNum")
    @Expose
    private Long BaseLineTotalAffectNum;

    /**
    * Total number of machines with unfixed network attack security events
    */
    @SerializedName("CyberAttackTotalAffectNum")
    @Expose
    private Long CyberAttackTotalAffectNum;

    /**
    * Critical vulnerability event statistics
    */
    @SerializedName("VulRiskStat")
    @Expose
    private EventStat VulRiskStat;

    /**
    * Statistics of critical baseline vulnerability events
    */
    @SerializedName("BaselineRiskStat")
    @Expose
    private EventStat BaselineRiskStat;

    /**
    * Statistics on the number of vulnerabilities
    */
    @SerializedName("VulStat")
    @Expose
    private EventStat VulStat;

    /**
    * Security score
    */
    @SerializedName("Score")
    @Expose
    private Long Score;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Trojan event statistics 
     * @return MalwareStat Trojan event statistics
     */
    public EventStat getMalwareStat() {
        return this.MalwareStat;
    }

    /**
     * Set Trojan event statistics
     * @param MalwareStat Trojan event statistics
     */
    public void setMalwareStat(EventStat MalwareStat) {
        this.MalwareStat = MalwareStat;
    }

    /**
     * Get Statistics of cross-region log-in events 
     * @return HostLoginStat Statistics of cross-region log-in events
     */
    public EventStat getHostLoginStat() {
        return this.HostLoginStat;
    }

    /**
     * Set Statistics of cross-region log-in events
     * @param HostLoginStat Statistics of cross-region log-in events
     */
    public void setHostLoginStat(EventStat HostLoginStat) {
        this.HostLoginStat = HostLoginStat;
    }

    /**
     * Get Statistics of brute force cracking events 
     * @return BruteAttackStat Statistics of brute force cracking events
     */
    public EventStat getBruteAttackStat() {
        return this.BruteAttackStat;
    }

    /**
     * Set Statistics of brute force cracking events
     * @param BruteAttackStat Statistics of brute force cracking events
     */
    public void setBruteAttackStat(EventStat BruteAttackStat) {
        this.BruteAttackStat = BruteAttackStat;
    }

    /**
     * Get Malicious request event statistics 
     * @return MaliciousRequestStat Malicious request event statistics
     */
    public EventStat getMaliciousRequestStat() {
        return this.MaliciousRequestStat;
    }

    /**
     * Set Malicious request event statistics
     * @param MaliciousRequestStat Malicious request event statistics
     */
    public void setMaliciousRequestStat(EventStat MaliciousRequestStat) {
        this.MaliciousRequestStat = MaliciousRequestStat;
    }

    /**
     * Get Statistics of local privilege escalation events 
     * @return PrivilegeStat Statistics of local privilege escalation events
     */
    public EventStat getPrivilegeStat() {
        return this.PrivilegeStat;
    }

    /**
     * Set Statistics of local privilege escalation events
     * @param PrivilegeStat Statistics of local privilege escalation events
     */
    public void setPrivilegeStat(EventStat PrivilegeStat) {
        this.PrivilegeStat = PrivilegeStat;
    }

    /**
     * Get Reverse shell event statistics 
     * @return ReverseShellStat Reverse shell event statistics
     */
    public EventStat getReverseShellStat() {
        return this.ReverseShellStat;
    }

    /**
     * Set Reverse shell event statistics
     * @param ReverseShellStat Reverse shell event statistics
     */
    public void setReverseShellStat(EventStat ReverseShellStat) {
        this.ReverseShellStat = ReverseShellStat;
    }

    /**
     * Get Statistics of high-risk command events 
     * @return HighRiskBashStat Statistics of high-risk command events
     */
    public EventStat getHighRiskBashStat() {
        return this.HighRiskBashStat;
    }

    /**
     * Set Statistics of high-risk command events
     * @param HighRiskBashStat Statistics of high-risk command events
     */
    public void setHighRiskBashStat(EventStat HighRiskBashStat) {
        this.HighRiskBashStat = HighRiskBashStat;
    }

    /**
     * Get Network attack event statistics 
     * @return AttackLogsStat Network attack event statistics
     */
    public EventStat getAttackLogsStat() {
        return this.AttackLogsStat;
    }

    /**
     * Set Network attack event statistics
     * @param AttackLogsStat Network attack event statistics
     */
    public void setAttackLogsStat(EventStat AttackLogsStat) {
        this.AttackLogsStat = AttackLogsStat;
    }

    /**
     * Get Statistics of high-risk vulnerability events 
     * @return VulHighStat Statistics of high-risk vulnerability events
     */
    public EventStat getVulHighStat() {
        return this.VulHighStat;
    }

    /**
     * Set Statistics of high-risk vulnerability events
     * @param VulHighStat Statistics of high-risk vulnerability events
     */
    public void setVulHighStat(EventStat VulHighStat) {
        this.VulHighStat = VulHighStat;
    }

    /**
     * Get Statistics of medium-risk vulnerability events 
     * @return VulNormalStat Statistics of medium-risk vulnerability events
     */
    public EventStat getVulNormalStat() {
        return this.VulNormalStat;
    }

    /**
     * Set Statistics of medium-risk vulnerability events
     * @param VulNormalStat Statistics of medium-risk vulnerability events
     */
    public void setVulNormalStat(EventStat VulNormalStat) {
        this.VulNormalStat = VulNormalStat;
    }

    /**
     * Get Statistics of low-risk vulnerability events 
     * @return VulLowStat Statistics of low-risk vulnerability events
     */
    public EventStat getVulLowStat() {
        return this.VulLowStat;
    }

    /**
     * Set Statistics of low-risk vulnerability events
     * @param VulLowStat Statistics of low-risk vulnerability events
     */
    public void setVulLowStat(EventStat VulLowStat) {
        this.VulLowStat = VulLowStat;
    }

    /**
     * Get Statistics of high-risk baseline vulnerability events 
     * @return BaselineHighStat Statistics of high-risk baseline vulnerability events
     */
    public EventStat getBaselineHighStat() {
        return this.BaselineHighStat;
    }

    /**
     * Set Statistics of high-risk baseline vulnerability events
     * @param BaselineHighStat Statistics of high-risk baseline vulnerability events
     */
    public void setBaselineHighStat(EventStat BaselineHighStat) {
        this.BaselineHighStat = BaselineHighStat;
    }

    /**
     * Get Statistics of medium-risk baseline vulnerability events 
     * @return BaselineNormalStat Statistics of medium-risk baseline vulnerability events
     */
    public EventStat getBaselineNormalStat() {
        return this.BaselineNormalStat;
    }

    /**
     * Set Statistics of medium-risk baseline vulnerability events
     * @param BaselineNormalStat Statistics of medium-risk baseline vulnerability events
     */
    public void setBaselineNormalStat(EventStat BaselineNormalStat) {
        this.BaselineNormalStat = BaselineNormalStat;
    }

    /**
     * Get Statistics of low-risk baseline vulnerability events 
     * @return BaselineLowStat Statistics of low-risk baseline vulnerability events
     */
    public EventStat getBaselineLowStat() {
        return this.BaselineLowStat;
    }

    /**
     * Set Statistics of low-risk baseline vulnerability events
     * @param BaselineLowStat Statistics of low-risk baseline vulnerability events
     */
    public void setBaselineLowStat(EventStat BaselineLowStat) {
        this.BaselineLowStat = BaselineLowStat;
    }

    /**
     * Get Total number of machines with unfixed security events 
     * @return MachineTotalAffectNum Total number of machines with unfixed security events
     */
    public Long getMachineTotalAffectNum() {
        return this.MachineTotalAffectNum;
    }

    /**
     * Set Total number of machines with unfixed security events
     * @param MachineTotalAffectNum Total number of machines with unfixed security events
     */
    public void setMachineTotalAffectNum(Long MachineTotalAffectNum) {
        this.MachineTotalAffectNum = MachineTotalAffectNum;
    }

    /**
     * Get Total number of machines with unfixed intrusion security events 
     * @return InvasionTotalAffectNum Total number of machines with unfixed intrusion security events
     */
    public Long getInvasionTotalAffectNum() {
        return this.InvasionTotalAffectNum;
    }

    /**
     * Set Total number of machines with unfixed intrusion security events
     * @param InvasionTotalAffectNum Total number of machines with unfixed intrusion security events
     */
    public void setInvasionTotalAffectNum(Long InvasionTotalAffectNum) {
        this.InvasionTotalAffectNum = InvasionTotalAffectNum;
    }

    /**
     * Get Total number of machines with unfixed vulnerability security events 
     * @return VulTotalAffectNum Total number of machines with unfixed vulnerability security events
     */
    public Long getVulTotalAffectNum() {
        return this.VulTotalAffectNum;
    }

    /**
     * Set Total number of machines with unfixed vulnerability security events
     * @param VulTotalAffectNum Total number of machines with unfixed vulnerability security events
     */
    public void setVulTotalAffectNum(Long VulTotalAffectNum) {
        this.VulTotalAffectNum = VulTotalAffectNum;
    }

    /**
     * Get Total number of machines with unfixed baseline security events 
     * @return BaseLineTotalAffectNum Total number of machines with unfixed baseline security events
     */
    public Long getBaseLineTotalAffectNum() {
        return this.BaseLineTotalAffectNum;
    }

    /**
     * Set Total number of machines with unfixed baseline security events
     * @param BaseLineTotalAffectNum Total number of machines with unfixed baseline security events
     */
    public void setBaseLineTotalAffectNum(Long BaseLineTotalAffectNum) {
        this.BaseLineTotalAffectNum = BaseLineTotalAffectNum;
    }

    /**
     * Get Total number of machines with unfixed network attack security events 
     * @return CyberAttackTotalAffectNum Total number of machines with unfixed network attack security events
     */
    public Long getCyberAttackTotalAffectNum() {
        return this.CyberAttackTotalAffectNum;
    }

    /**
     * Set Total number of machines with unfixed network attack security events
     * @param CyberAttackTotalAffectNum Total number of machines with unfixed network attack security events
     */
    public void setCyberAttackTotalAffectNum(Long CyberAttackTotalAffectNum) {
        this.CyberAttackTotalAffectNum = CyberAttackTotalAffectNum;
    }

    /**
     * Get Critical vulnerability event statistics 
     * @return VulRiskStat Critical vulnerability event statistics
     */
    public EventStat getVulRiskStat() {
        return this.VulRiskStat;
    }

    /**
     * Set Critical vulnerability event statistics
     * @param VulRiskStat Critical vulnerability event statistics
     */
    public void setVulRiskStat(EventStat VulRiskStat) {
        this.VulRiskStat = VulRiskStat;
    }

    /**
     * Get Statistics of critical baseline vulnerability events 
     * @return BaselineRiskStat Statistics of critical baseline vulnerability events
     */
    public EventStat getBaselineRiskStat() {
        return this.BaselineRiskStat;
    }

    /**
     * Set Statistics of critical baseline vulnerability events
     * @param BaselineRiskStat Statistics of critical baseline vulnerability events
     */
    public void setBaselineRiskStat(EventStat BaselineRiskStat) {
        this.BaselineRiskStat = BaselineRiskStat;
    }

    /**
     * Get Statistics on the number of vulnerabilities 
     * @return VulStat Statistics on the number of vulnerabilities
     */
    public EventStat getVulStat() {
        return this.VulStat;
    }

    /**
     * Set Statistics on the number of vulnerabilities
     * @param VulStat Statistics on the number of vulnerabilities
     */
    public void setVulStat(EventStat VulStat) {
        this.VulStat = VulStat;
    }

    /**
     * Get Security score 
     * @return Score Security score
     */
    public Long getScore() {
        return this.Score;
    }

    /**
     * Set Security score
     * @param Score Security score
     */
    public void setScore(Long Score) {
        this.Score = Score;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeSecurityEventStatResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeSecurityEventStatResponse(DescribeSecurityEventStatResponse source) {
        if (source.MalwareStat != null) {
            this.MalwareStat = new EventStat(source.MalwareStat);
        }
        if (source.HostLoginStat != null) {
            this.HostLoginStat = new EventStat(source.HostLoginStat);
        }
        if (source.BruteAttackStat != null) {
            this.BruteAttackStat = new EventStat(source.BruteAttackStat);
        }
        if (source.MaliciousRequestStat != null) {
            this.MaliciousRequestStat = new EventStat(source.MaliciousRequestStat);
        }
        if (source.PrivilegeStat != null) {
            this.PrivilegeStat = new EventStat(source.PrivilegeStat);
        }
        if (source.ReverseShellStat != null) {
            this.ReverseShellStat = new EventStat(source.ReverseShellStat);
        }
        if (source.HighRiskBashStat != null) {
            this.HighRiskBashStat = new EventStat(source.HighRiskBashStat);
        }
        if (source.AttackLogsStat != null) {
            this.AttackLogsStat = new EventStat(source.AttackLogsStat);
        }
        if (source.VulHighStat != null) {
            this.VulHighStat = new EventStat(source.VulHighStat);
        }
        if (source.VulNormalStat != null) {
            this.VulNormalStat = new EventStat(source.VulNormalStat);
        }
        if (source.VulLowStat != null) {
            this.VulLowStat = new EventStat(source.VulLowStat);
        }
        if (source.BaselineHighStat != null) {
            this.BaselineHighStat = new EventStat(source.BaselineHighStat);
        }
        if (source.BaselineNormalStat != null) {
            this.BaselineNormalStat = new EventStat(source.BaselineNormalStat);
        }
        if (source.BaselineLowStat != null) {
            this.BaselineLowStat = new EventStat(source.BaselineLowStat);
        }
        if (source.MachineTotalAffectNum != null) {
            this.MachineTotalAffectNum = new Long(source.MachineTotalAffectNum);
        }
        if (source.InvasionTotalAffectNum != null) {
            this.InvasionTotalAffectNum = new Long(source.InvasionTotalAffectNum);
        }
        if (source.VulTotalAffectNum != null) {
            this.VulTotalAffectNum = new Long(source.VulTotalAffectNum);
        }
        if (source.BaseLineTotalAffectNum != null) {
            this.BaseLineTotalAffectNum = new Long(source.BaseLineTotalAffectNum);
        }
        if (source.CyberAttackTotalAffectNum != null) {
            this.CyberAttackTotalAffectNum = new Long(source.CyberAttackTotalAffectNum);
        }
        if (source.VulRiskStat != null) {
            this.VulRiskStat = new EventStat(source.VulRiskStat);
        }
        if (source.BaselineRiskStat != null) {
            this.BaselineRiskStat = new EventStat(source.BaselineRiskStat);
        }
        if (source.VulStat != null) {
            this.VulStat = new EventStat(source.VulStat);
        }
        if (source.Score != null) {
            this.Score = new Long(source.Score);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamObj(map, prefix + "MalwareStat.", this.MalwareStat);
        this.setParamObj(map, prefix + "HostLoginStat.", this.HostLoginStat);
        this.setParamObj(map, prefix + "BruteAttackStat.", this.BruteAttackStat);
        this.setParamObj(map, prefix + "MaliciousRequestStat.", this.MaliciousRequestStat);
        this.setParamObj(map, prefix + "PrivilegeStat.", this.PrivilegeStat);
        this.setParamObj(map, prefix + "ReverseShellStat.", this.ReverseShellStat);
        this.setParamObj(map, prefix + "HighRiskBashStat.", this.HighRiskBashStat);
        this.setParamObj(map, prefix + "AttackLogsStat.", this.AttackLogsStat);
        this.setParamObj(map, prefix + "VulHighStat.", this.VulHighStat);
        this.setParamObj(map, prefix + "VulNormalStat.", this.VulNormalStat);
        this.setParamObj(map, prefix + "VulLowStat.", this.VulLowStat);
        this.setParamObj(map, prefix + "BaselineHighStat.", this.BaselineHighStat);
        this.setParamObj(map, prefix + "BaselineNormalStat.", this.BaselineNormalStat);
        this.setParamObj(map, prefix + "BaselineLowStat.", this.BaselineLowStat);
        this.setParamSimple(map, prefix + "MachineTotalAffectNum", this.MachineTotalAffectNum);
        this.setParamSimple(map, prefix + "InvasionTotalAffectNum", this.InvasionTotalAffectNum);
        this.setParamSimple(map, prefix + "VulTotalAffectNum", this.VulTotalAffectNum);
        this.setParamSimple(map, prefix + "BaseLineTotalAffectNum", this.BaseLineTotalAffectNum);
        this.setParamSimple(map, prefix + "CyberAttackTotalAffectNum", this.CyberAttackTotalAffectNum);
        this.setParamObj(map, prefix + "VulRiskStat.", this.VulRiskStat);
        this.setParamObj(map, prefix + "BaselineRiskStat.", this.BaselineRiskStat);
        this.setParamObj(map, prefix + "VulStat.", this.VulStat);
        this.setParamSimple(map, prefix + "Score", this.Score);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

