/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeSecurityTrendsResponse extends AbstractModel {

    /**
    * Array of counted Trojan events
    */
    @SerializedName("Malwares")
    @Expose
    private SecurityTrend [] Malwares;

    /**
    * Array of counted cross-region log-in events
    */
    @SerializedName("NonLocalLoginPlaces")
    @Expose
    private SecurityTrend [] NonLocalLoginPlaces;

    /**
    * Array of counted password cracking events
    */
    @SerializedName("BruteAttacks")
    @Expose
    private SecurityTrend [] BruteAttacks;

    /**
    * Array of counted vulnerabilities
    */
    @SerializedName("Vuls")
    @Expose
    private SecurityTrend [] Vuls;

    /**
    * Array of counted baselines
    */
    @SerializedName("BaseLines")
    @Expose
    private SecurityTrend [] BaseLines;

    /**
    * Array of counted malicious requests
    */
    @SerializedName("MaliciousRequests")
    @Expose
    private SecurityTrend [] MaliciousRequests;

    /**
    * Array of counted high-risk command
    */
    @SerializedName("HighRiskBashs")
    @Expose
    private SecurityTrend [] HighRiskBashs;

    /**
    * Array of counted reverse shell
    */
    @SerializedName("ReverseShells")
    @Expose
    private SecurityTrend [] ReverseShells;

    /**
    * Array of counted local privilege escalation
    */
    @SerializedName("PrivilegeEscalations")
    @Expose
    private SecurityTrend [] PrivilegeEscalations;

    /**
    * Array of counted network attacks
    */
    @SerializedName("CyberAttacks")
    @Expose
    private SecurityTrend [] CyberAttacks;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Array of counted Trojan events 
     * @return Malwares Array of counted Trojan events
     */
    public SecurityTrend [] getMalwares() {
        return this.Malwares;
    }

    /**
     * Set Array of counted Trojan events
     * @param Malwares Array of counted Trojan events
     */
    public void setMalwares(SecurityTrend [] Malwares) {
        this.Malwares = Malwares;
    }

    /**
     * Get Array of counted cross-region log-in events 
     * @return NonLocalLoginPlaces Array of counted cross-region log-in events
     */
    public SecurityTrend [] getNonLocalLoginPlaces() {
        return this.NonLocalLoginPlaces;
    }

    /**
     * Set Array of counted cross-region log-in events
     * @param NonLocalLoginPlaces Array of counted cross-region log-in events
     */
    public void setNonLocalLoginPlaces(SecurityTrend [] NonLocalLoginPlaces) {
        this.NonLocalLoginPlaces = NonLocalLoginPlaces;
    }

    /**
     * Get Array of counted password cracking events 
     * @return BruteAttacks Array of counted password cracking events
     */
    public SecurityTrend [] getBruteAttacks() {
        return this.BruteAttacks;
    }

    /**
     * Set Array of counted password cracking events
     * @param BruteAttacks Array of counted password cracking events
     */
    public void setBruteAttacks(SecurityTrend [] BruteAttacks) {
        this.BruteAttacks = BruteAttacks;
    }

    /**
     * Get Array of counted vulnerabilities 
     * @return Vuls Array of counted vulnerabilities
     */
    public SecurityTrend [] getVuls() {
        return this.Vuls;
    }

    /**
     * Set Array of counted vulnerabilities
     * @param Vuls Array of counted vulnerabilities
     */
    public void setVuls(SecurityTrend [] Vuls) {
        this.Vuls = Vuls;
    }

    /**
     * Get Array of counted baselines 
     * @return BaseLines Array of counted baselines
     */
    public SecurityTrend [] getBaseLines() {
        return this.BaseLines;
    }

    /**
     * Set Array of counted baselines
     * @param BaseLines Array of counted baselines
     */
    public void setBaseLines(SecurityTrend [] BaseLines) {
        this.BaseLines = BaseLines;
    }

    /**
     * Get Array of counted malicious requests 
     * @return MaliciousRequests Array of counted malicious requests
     */
    public SecurityTrend [] getMaliciousRequests() {
        return this.MaliciousRequests;
    }

    /**
     * Set Array of counted malicious requests
     * @param MaliciousRequests Array of counted malicious requests
     */
    public void setMaliciousRequests(SecurityTrend [] MaliciousRequests) {
        this.MaliciousRequests = MaliciousRequests;
    }

    /**
     * Get Array of counted high-risk command 
     * @return HighRiskBashs Array of counted high-risk command
     */
    public SecurityTrend [] getHighRiskBashs() {
        return this.HighRiskBashs;
    }

    /**
     * Set Array of counted high-risk command
     * @param HighRiskBashs Array of counted high-risk command
     */
    public void setHighRiskBashs(SecurityTrend [] HighRiskBashs) {
        this.HighRiskBashs = HighRiskBashs;
    }

    /**
     * Get Array of counted reverse shell 
     * @return ReverseShells Array of counted reverse shell
     */
    public SecurityTrend [] getReverseShells() {
        return this.ReverseShells;
    }

    /**
     * Set Array of counted reverse shell
     * @param ReverseShells Array of counted reverse shell
     */
    public void setReverseShells(SecurityTrend [] ReverseShells) {
        this.ReverseShells = ReverseShells;
    }

    /**
     * Get Array of counted local privilege escalation 
     * @return PrivilegeEscalations Array of counted local privilege escalation
     */
    public SecurityTrend [] getPrivilegeEscalations() {
        return this.PrivilegeEscalations;
    }

    /**
     * Set Array of counted local privilege escalation
     * @param PrivilegeEscalations Array of counted local privilege escalation
     */
    public void setPrivilegeEscalations(SecurityTrend [] PrivilegeEscalations) {
        this.PrivilegeEscalations = PrivilegeEscalations;
    }

    /**
     * Get Array of counted network attacks 
     * @return CyberAttacks Array of counted network attacks
     */
    public SecurityTrend [] getCyberAttacks() {
        return this.CyberAttacks;
    }

    /**
     * Set Array of counted network attacks
     * @param CyberAttacks Array of counted network attacks
     */
    public void setCyberAttacks(SecurityTrend [] CyberAttacks) {
        this.CyberAttacks = CyberAttacks;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeSecurityTrendsResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeSecurityTrendsResponse(DescribeSecurityTrendsResponse source) {
        if (source.Malwares != null) {
            this.Malwares = new SecurityTrend[source.Malwares.length];
            for (int i = 0; i < source.Malwares.length; i++) {
                this.Malwares[i] = new SecurityTrend(source.Malwares[i]);
            }
        }
        if (source.NonLocalLoginPlaces != null) {
            this.NonLocalLoginPlaces = new SecurityTrend[source.NonLocalLoginPlaces.length];
            for (int i = 0; i < source.NonLocalLoginPlaces.length; i++) {
                this.NonLocalLoginPlaces[i] = new SecurityTrend(source.NonLocalLoginPlaces[i]);
            }
        }
        if (source.BruteAttacks != null) {
            this.BruteAttacks = new SecurityTrend[source.BruteAttacks.length];
            for (int i = 0; i < source.BruteAttacks.length; i++) {
                this.BruteAttacks[i] = new SecurityTrend(source.BruteAttacks[i]);
            }
        }
        if (source.Vuls != null) {
            this.Vuls = new SecurityTrend[source.Vuls.length];
            for (int i = 0; i < source.Vuls.length; i++) {
                this.Vuls[i] = new SecurityTrend(source.Vuls[i]);
            }
        }
        if (source.BaseLines != null) {
            this.BaseLines = new SecurityTrend[source.BaseLines.length];
            for (int i = 0; i < source.BaseLines.length; i++) {
                this.BaseLines[i] = new SecurityTrend(source.BaseLines[i]);
            }
        }
        if (source.MaliciousRequests != null) {
            this.MaliciousRequests = new SecurityTrend[source.MaliciousRequests.length];
            for (int i = 0; i < source.MaliciousRequests.length; i++) {
                this.MaliciousRequests[i] = new SecurityTrend(source.MaliciousRequests[i]);
            }
        }
        if (source.HighRiskBashs != null) {
            this.HighRiskBashs = new SecurityTrend[source.HighRiskBashs.length];
            for (int i = 0; i < source.HighRiskBashs.length; i++) {
                this.HighRiskBashs[i] = new SecurityTrend(source.HighRiskBashs[i]);
            }
        }
        if (source.ReverseShells != null) {
            this.ReverseShells = new SecurityTrend[source.ReverseShells.length];
            for (int i = 0; i < source.ReverseShells.length; i++) {
                this.ReverseShells[i] = new SecurityTrend(source.ReverseShells[i]);
            }
        }
        if (source.PrivilegeEscalations != null) {
            this.PrivilegeEscalations = new SecurityTrend[source.PrivilegeEscalations.length];
            for (int i = 0; i < source.PrivilegeEscalations.length; i++) {
                this.PrivilegeEscalations[i] = new SecurityTrend(source.PrivilegeEscalations[i]);
            }
        }
        if (source.CyberAttacks != null) {
            this.CyberAttacks = new SecurityTrend[source.CyberAttacks.length];
            for (int i = 0; i < source.CyberAttacks.length; i++) {
                this.CyberAttacks[i] = new SecurityTrend(source.CyberAttacks[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "Malwares.", this.Malwares);
        this.setParamArrayObj(map, prefix + "NonLocalLoginPlaces.", this.NonLocalLoginPlaces);
        this.setParamArrayObj(map, prefix + "BruteAttacks.", this.BruteAttacks);
        this.setParamArrayObj(map, prefix + "Vuls.", this.Vuls);
        this.setParamArrayObj(map, prefix + "BaseLines.", this.BaseLines);
        this.setParamArrayObj(map, prefix + "MaliciousRequests.", this.MaliciousRequests);
        this.setParamArrayObj(map, prefix + "HighRiskBashs.", this.HighRiskBashs);
        this.setParamArrayObj(map, prefix + "ReverseShells.", this.ReverseShells);
        this.setParamArrayObj(map, prefix + "PrivilegeEscalations.", this.PrivilegeEscalations);
        this.setParamArrayObj(map, prefix + "CyberAttacks.", this.CyberAttacks);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

