/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeVdbAndPocInfoResponse extends AbstractModel {

    /**
    * Virus database update time
    */
    @SerializedName("VdbUpdateTime")
    @Expose
    private String VdbUpdateTime;

    /**
    * Vulnerability database update time
    */
    @SerializedName("PocUpdateTime")
    @Expose
    private String PocUpdateTime;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Virus database update time 
     * @return VdbUpdateTime Virus database update time
     */
    public String getVdbUpdateTime() {
        return this.VdbUpdateTime;
    }

    /**
     * Set Virus database update time
     * @param VdbUpdateTime Virus database update time
     */
    public void setVdbUpdateTime(String VdbUpdateTime) {
        this.VdbUpdateTime = VdbUpdateTime;
    }

    /**
     * Get Vulnerability database update time 
     * @return PocUpdateTime Vulnerability database update time
     */
    public String getPocUpdateTime() {
        return this.PocUpdateTime;
    }

    /**
     * Set Vulnerability database update time
     * @param PocUpdateTime Vulnerability database update time
     */
    public void setPocUpdateTime(String PocUpdateTime) {
        this.PocUpdateTime = PocUpdateTime;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeVdbAndPocInfoResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeVdbAndPocInfoResponse(DescribeVdbAndPocInfoResponse source) {
        if (source.VdbUpdateTime != null) {
            this.VdbUpdateTime = new String(source.VdbUpdateTime);
        }
        if (source.PocUpdateTime != null) {
            this.PocUpdateTime = new String(source.PocUpdateTime);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "VdbUpdateTime", this.VdbUpdateTime);
        this.setParamSimple(map, prefix + "PocUpdateTime", this.PocUpdateTime);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

