/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeVersionStatisticsResponse extends AbstractModel {

    /**
    * Number of Basic editions
    */
    @SerializedName("BasicVersionNum")
    @Expose
    private Long BasicVersionNum;

    /**
    * Number of Professional editions
    */
    @SerializedName("ProVersionNum")
    @Expose
    private Long ProVersionNum;

    /**
    * Number of Ultimate editions
    */
    @SerializedName("UltimateVersionNum")
    @Expose
    private Long UltimateVersionNum;

    /**
    * Number of General Discount Editions
    */
    @SerializedName("GeneralVersionNum")
    @Expose
    private Long GeneralVersionNum;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Number of Basic editions 
     * @return BasicVersionNum Number of Basic editions
     */
    public Long getBasicVersionNum() {
        return this.BasicVersionNum;
    }

    /**
     * Set Number of Basic editions
     * @param BasicVersionNum Number of Basic editions
     */
    public void setBasicVersionNum(Long BasicVersionNum) {
        this.BasicVersionNum = BasicVersionNum;
    }

    /**
     * Get Number of Professional editions 
     * @return ProVersionNum Number of Professional editions
     */
    public Long getProVersionNum() {
        return this.ProVersionNum;
    }

    /**
     * Set Number of Professional editions
     * @param ProVersionNum Number of Professional editions
     */
    public void setProVersionNum(Long ProVersionNum) {
        this.ProVersionNum = ProVersionNum;
    }

    /**
     * Get Number of Ultimate editions 
     * @return UltimateVersionNum Number of Ultimate editions
     */
    public Long getUltimateVersionNum() {
        return this.UltimateVersionNum;
    }

    /**
     * Set Number of Ultimate editions
     * @param UltimateVersionNum Number of Ultimate editions
     */
    public void setUltimateVersionNum(Long UltimateVersionNum) {
        this.UltimateVersionNum = UltimateVersionNum;
    }

    /**
     * Get Number of General Discount Editions 
     * @return GeneralVersionNum Number of General Discount Editions
     */
    public Long getGeneralVersionNum() {
        return this.GeneralVersionNum;
    }

    /**
     * Set Number of General Discount Editions
     * @param GeneralVersionNum Number of General Discount Editions
     */
    public void setGeneralVersionNum(Long GeneralVersionNum) {
        this.GeneralVersionNum = GeneralVersionNum;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeVersionStatisticsResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeVersionStatisticsResponse(DescribeVersionStatisticsResponse source) {
        if (source.BasicVersionNum != null) {
            this.BasicVersionNum = new Long(source.BasicVersionNum);
        }
        if (source.ProVersionNum != null) {
            this.ProVersionNum = new Long(source.ProVersionNum);
        }
        if (source.UltimateVersionNum != null) {
            this.UltimateVersionNum = new Long(source.UltimateVersionNum);
        }
        if (source.GeneralVersionNum != null) {
            this.GeneralVersionNum = new Long(source.GeneralVersionNum);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "BasicVersionNum", this.BasicVersionNum);
        this.setParamSimple(map, prefix + "ProVersionNum", this.ProVersionNum);
        this.setParamSimple(map, prefix + "UltimateVersionNum", this.UltimateVersionNum);
        this.setParamSimple(map, prefix + "GeneralVersionNum", this.GeneralVersionNum);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

