/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeVulCountByDatesResponse extends AbstractModel {

    /**
    * Obtain the number of vulnerabilities for corresponding days in batch
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("VulCount")
    @Expose
    private Long [] VulCount;

    /**
    * Obtain the number of hosts for corresponding days in batch
    */
    @SerializedName("HostCount")
    @Expose
    private Long [] HostCount;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Obtain the number of vulnerabilities for corresponding days in batch
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return VulCount Obtain the number of vulnerabilities for corresponding days in batch
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long [] getVulCount() {
        return this.VulCount;
    }

    /**
     * Set Obtain the number of vulnerabilities for corresponding days in batch
Note: This field may return null, indicating that no valid values can be obtained.
     * @param VulCount Obtain the number of vulnerabilities for corresponding days in batch
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setVulCount(Long [] VulCount) {
        this.VulCount = VulCount;
    }

    /**
     * Get Obtain the number of hosts for corresponding days in batch 
     * @return HostCount Obtain the number of hosts for corresponding days in batch
     */
    public Long [] getHostCount() {
        return this.HostCount;
    }

    /**
     * Set Obtain the number of hosts for corresponding days in batch
     * @param HostCount Obtain the number of hosts for corresponding days in batch
     */
    public void setHostCount(Long [] HostCount) {
        this.HostCount = HostCount;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeVulCountByDatesResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeVulCountByDatesResponse(DescribeVulCountByDatesResponse source) {
        if (source.VulCount != null) {
            this.VulCount = new Long[source.VulCount.length];
            for (int i = 0; i < source.VulCount.length; i++) {
                this.VulCount[i] = new Long(source.VulCount[i]);
            }
        }
        if (source.HostCount != null) {
            this.HostCount = new Long[source.HostCount.length];
            for (int i = 0; i < source.HostCount.length; i++) {
                this.HostCount[i] = new Long(source.HostCount[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArraySimple(map, prefix + "VulCount.", this.VulCount);
        this.setParamArraySimple(map, prefix + "HostCount.", this.HostCount);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

