/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeVulDefenceSettingResponse extends AbstractModel {

    /**
    * Defense switch: 0 - off; 1 - on
    */
    @SerializedName("Enable")
    @Expose
    private Long Enable;

    /**
    * Scope of impact: 1 - all ultimate edition hosts across the network; 0 - hosts in the QUUID list
    */
    @SerializedName("Scope")
    @Expose
    private Long Scope;

    /**
    * List of affected host QUUIDs
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Quuids")
    @Expose
    private String [] Quuids;

    /**
    * Current number of ultimate edition hosts
    */
    @SerializedName("FlagshipCount")
    @Expose
    private Long FlagshipCount;

    /**
    * List of affected host IDs
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("InstanceIds")
    @Expose
    private String [] InstanceIds;

    /**
    * Whether new ultimate edition hosts automatically join: 1 - yes; 0 - no
    */
    @SerializedName("AutoInclude")
    @Expose
    private Long AutoInclude;

    /**
    * List of excluded host IDs
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("ExcludeInstanceIds")
    @Expose
    private String [] ExcludeInstanceIds;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Defense switch: 0 - off; 1 - on 
     * @return Enable Defense switch: 0 - off; 1 - on
     */
    public Long getEnable() {
        return this.Enable;
    }

    /**
     * Set Defense switch: 0 - off; 1 - on
     * @param Enable Defense switch: 0 - off; 1 - on
     */
    public void setEnable(Long Enable) {
        this.Enable = Enable;
    }

    /**
     * Get Scope of impact: 1 - all ultimate edition hosts across the network; 0 - hosts in the QUUID list 
     * @return Scope Scope of impact: 1 - all ultimate edition hosts across the network; 0 - hosts in the QUUID list
     */
    public Long getScope() {
        return this.Scope;
    }

    /**
     * Set Scope of impact: 1 - all ultimate edition hosts across the network; 0 - hosts in the QUUID list
     * @param Scope Scope of impact: 1 - all ultimate edition hosts across the network; 0 - hosts in the QUUID list
     */
    public void setScope(Long Scope) {
        this.Scope = Scope;
    }

    /**
     * Get List of affected host QUUIDs
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return Quuids List of affected host QUUIDs
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String [] getQuuids() {
        return this.Quuids;
    }

    /**
     * Set List of affected host QUUIDs
Note: This field may return null, indicating that no valid values can be obtained.
     * @param Quuids List of affected host QUUIDs
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setQuuids(String [] Quuids) {
        this.Quuids = Quuids;
    }

    /**
     * Get Current number of ultimate edition hosts 
     * @return FlagshipCount Current number of ultimate edition hosts
     */
    public Long getFlagshipCount() {
        return this.FlagshipCount;
    }

    /**
     * Set Current number of ultimate edition hosts
     * @param FlagshipCount Current number of ultimate edition hosts
     */
    public void setFlagshipCount(Long FlagshipCount) {
        this.FlagshipCount = FlagshipCount;
    }

    /**
     * Get List of affected host IDs
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return InstanceIds List of affected host IDs
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String [] getInstanceIds() {
        return this.InstanceIds;
    }

    /**
     * Set List of affected host IDs
Note: This field may return null, indicating that no valid values can be obtained.
     * @param InstanceIds List of affected host IDs
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setInstanceIds(String [] InstanceIds) {
        this.InstanceIds = InstanceIds;
    }

    /**
     * Get Whether new ultimate edition hosts automatically join: 1 - yes; 0 - no 
     * @return AutoInclude Whether new ultimate edition hosts automatically join: 1 - yes; 0 - no
     */
    public Long getAutoInclude() {
        return this.AutoInclude;
    }

    /**
     * Set Whether new ultimate edition hosts automatically join: 1 - yes; 0 - no
     * @param AutoInclude Whether new ultimate edition hosts automatically join: 1 - yes; 0 - no
     */
    public void setAutoInclude(Long AutoInclude) {
        this.AutoInclude = AutoInclude;
    }

    /**
     * Get List of excluded host IDs
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return ExcludeInstanceIds List of excluded host IDs
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String [] getExcludeInstanceIds() {
        return this.ExcludeInstanceIds;
    }

    /**
     * Set List of excluded host IDs
Note: This field may return null, indicating that no valid values can be obtained.
     * @param ExcludeInstanceIds List of excluded host IDs
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setExcludeInstanceIds(String [] ExcludeInstanceIds) {
        this.ExcludeInstanceIds = ExcludeInstanceIds;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeVulDefenceSettingResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeVulDefenceSettingResponse(DescribeVulDefenceSettingResponse source) {
        if (source.Enable != null) {
            this.Enable = new Long(source.Enable);
        }
        if (source.Scope != null) {
            this.Scope = new Long(source.Scope);
        }
        if (source.Quuids != null) {
            this.Quuids = new String[source.Quuids.length];
            for (int i = 0; i < source.Quuids.length; i++) {
                this.Quuids[i] = new String(source.Quuids[i]);
            }
        }
        if (source.FlagshipCount != null) {
            this.FlagshipCount = new Long(source.FlagshipCount);
        }
        if (source.InstanceIds != null) {
            this.InstanceIds = new String[source.InstanceIds.length];
            for (int i = 0; i < source.InstanceIds.length; i++) {
                this.InstanceIds[i] = new String(source.InstanceIds[i]);
            }
        }
        if (source.AutoInclude != null) {
            this.AutoInclude = new Long(source.AutoInclude);
        }
        if (source.ExcludeInstanceIds != null) {
            this.ExcludeInstanceIds = new String[source.ExcludeInstanceIds.length];
            for (int i = 0; i < source.ExcludeInstanceIds.length; i++) {
                this.ExcludeInstanceIds[i] = new String(source.ExcludeInstanceIds[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Enable", this.Enable);
        this.setParamSimple(map, prefix + "Scope", this.Scope);
        this.setParamArraySimple(map, prefix + "Quuids.", this.Quuids);
        this.setParamSimple(map, prefix + "FlagshipCount", this.FlagshipCount);
        this.setParamArraySimple(map, prefix + "InstanceIds.", this.InstanceIds);
        this.setParamSimple(map, prefix + "AutoInclude", this.AutoInclude);
        this.setParamArraySimple(map, prefix + "ExcludeInstanceIds.", this.ExcludeInstanceIds);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

