/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeVulFixStatusResponse extends AbstractModel {

    /**
    * Fixing start time
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("FixStartTime")
    @Expose
    private String FixStartTime;

    /**
    * Fixing end time. If this parameter is left blank, fixing is not ended.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("FixEndTime")
    @Expose
    private String FixEndTime;

    /**
    * Number of successfully fixed hosts
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("FixSuccessCnt")
    @Expose
    private Long FixSuccessCnt;

    /**
    * Number of hosts failed to be fixed
    */
    @SerializedName("FixFailCnt")
    @Expose
    private Long FixFailCnt;

    /**
    * Total number of hosts
    */
    @SerializedName("HostCnt")
    @Expose
    private Long HostCnt;

    /**
    * Fixing task ID
    */
    @SerializedName("FixId")
    @Expose
    private Long FixId;

    /**
    * Status list of snapshots to be fixed
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("SnapshotList")
    @Expose
    private VulFixStatusSnapshotInfo [] SnapshotList;

    /**
    * Details list of vulnerabilities to be fixed
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("VulFixList")
    @Expose
    private VulFixStatusInfo [] VulFixList;

    /**
    * Snapshot creation progress (0-100)
    */
    @SerializedName("SnapshotProgress")
    @Expose
    private Long SnapshotProgress;

    /**
    * Fixing progress (0-100)
    */
    @SerializedName("FixProgress")
    @Expose
    private Long FixProgress;

    /**
    * Estimated remaining time (seconds)
    */
    @SerializedName("RemainingTime")
    @Expose
    private Long RemainingTime;

    /**
    * Whether the snapshot is retried. 0: no; 1: yes.
    */
    @SerializedName("IsRetrySnapshot")
    @Expose
    private Long IsRetrySnapshot;

    /**
    * Number of snapshots failed to be created
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("SnapshotFailCnt")
    @Expose
    private Long SnapshotFailCnt;

    /**
    * Whether retry is allowed. 0: not allowed; 1: allowed.Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("IsAllowRetry")
    @Expose
    private Long IsAllowRetry;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Fixing start time
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return FixStartTime Fixing start time
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String getFixStartTime() {
        return this.FixStartTime;
    }

    /**
     * Set Fixing start time
Note: This field may return null, indicating that no valid values can be obtained.
     * @param FixStartTime Fixing start time
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setFixStartTime(String FixStartTime) {
        this.FixStartTime = FixStartTime;
    }

    /**
     * Get Fixing end time. If this parameter is left blank, fixing is not ended.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return FixEndTime Fixing end time. If this parameter is left blank, fixing is not ended.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String getFixEndTime() {
        return this.FixEndTime;
    }

    /**
     * Set Fixing end time. If this parameter is left blank, fixing is not ended.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param FixEndTime Fixing end time. If this parameter is left blank, fixing is not ended.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setFixEndTime(String FixEndTime) {
        this.FixEndTime = FixEndTime;
    }

    /**
     * Get Number of successfully fixed hosts
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return FixSuccessCnt Number of successfully fixed hosts
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getFixSuccessCnt() {
        return this.FixSuccessCnt;
    }

    /**
     * Set Number of successfully fixed hosts
Note: This field may return null, indicating that no valid values can be obtained.
     * @param FixSuccessCnt Number of successfully fixed hosts
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setFixSuccessCnt(Long FixSuccessCnt) {
        this.FixSuccessCnt = FixSuccessCnt;
    }

    /**
     * Get Number of hosts failed to be fixed 
     * @return FixFailCnt Number of hosts failed to be fixed
     */
    public Long getFixFailCnt() {
        return this.FixFailCnt;
    }

    /**
     * Set Number of hosts failed to be fixed
     * @param FixFailCnt Number of hosts failed to be fixed
     */
    public void setFixFailCnt(Long FixFailCnt) {
        this.FixFailCnt = FixFailCnt;
    }

    /**
     * Get Total number of hosts 
     * @return HostCnt Total number of hosts
     */
    public Long getHostCnt() {
        return this.HostCnt;
    }

    /**
     * Set Total number of hosts
     * @param HostCnt Total number of hosts
     */
    public void setHostCnt(Long HostCnt) {
        this.HostCnt = HostCnt;
    }

    /**
     * Get Fixing task ID 
     * @return FixId Fixing task ID
     */
    public Long getFixId() {
        return this.FixId;
    }

    /**
     * Set Fixing task ID
     * @param FixId Fixing task ID
     */
    public void setFixId(Long FixId) {
        this.FixId = FixId;
    }

    /**
     * Get Status list of snapshots to be fixed
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return SnapshotList Status list of snapshots to be fixed
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public VulFixStatusSnapshotInfo [] getSnapshotList() {
        return this.SnapshotList;
    }

    /**
     * Set Status list of snapshots to be fixed
Note: This field may return null, indicating that no valid values can be obtained.
     * @param SnapshotList Status list of snapshots to be fixed
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setSnapshotList(VulFixStatusSnapshotInfo [] SnapshotList) {
        this.SnapshotList = SnapshotList;
    }

    /**
     * Get Details list of vulnerabilities to be fixed
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return VulFixList Details list of vulnerabilities to be fixed
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public VulFixStatusInfo [] getVulFixList() {
        return this.VulFixList;
    }

    /**
     * Set Details list of vulnerabilities to be fixed
Note: This field may return null, indicating that no valid values can be obtained.
     * @param VulFixList Details list of vulnerabilities to be fixed
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setVulFixList(VulFixStatusInfo [] VulFixList) {
        this.VulFixList = VulFixList;
    }

    /**
     * Get Snapshot creation progress (0-100) 
     * @return SnapshotProgress Snapshot creation progress (0-100)
     */
    public Long getSnapshotProgress() {
        return this.SnapshotProgress;
    }

    /**
     * Set Snapshot creation progress (0-100)
     * @param SnapshotProgress Snapshot creation progress (0-100)
     */
    public void setSnapshotProgress(Long SnapshotProgress) {
        this.SnapshotProgress = SnapshotProgress;
    }

    /**
     * Get Fixing progress (0-100) 
     * @return FixProgress Fixing progress (0-100)
     */
    public Long getFixProgress() {
        return this.FixProgress;
    }

    /**
     * Set Fixing progress (0-100)
     * @param FixProgress Fixing progress (0-100)
     */
    public void setFixProgress(Long FixProgress) {
        this.FixProgress = FixProgress;
    }

    /**
     * Get Estimated remaining time (seconds) 
     * @return RemainingTime Estimated remaining time (seconds)
     */
    public Long getRemainingTime() {
        return this.RemainingTime;
    }

    /**
     * Set Estimated remaining time (seconds)
     * @param RemainingTime Estimated remaining time (seconds)
     */
    public void setRemainingTime(Long RemainingTime) {
        this.RemainingTime = RemainingTime;
    }

    /**
     * Get Whether the snapshot is retried. 0: no; 1: yes. 
     * @return IsRetrySnapshot Whether the snapshot is retried. 0: no; 1: yes.
     */
    public Long getIsRetrySnapshot() {
        return this.IsRetrySnapshot;
    }

    /**
     * Set Whether the snapshot is retried. 0: no; 1: yes.
     * @param IsRetrySnapshot Whether the snapshot is retried. 0: no; 1: yes.
     */
    public void setIsRetrySnapshot(Long IsRetrySnapshot) {
        this.IsRetrySnapshot = IsRetrySnapshot;
    }

    /**
     * Get Number of snapshots failed to be created
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return SnapshotFailCnt Number of snapshots failed to be created
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getSnapshotFailCnt() {
        return this.SnapshotFailCnt;
    }

    /**
     * Set Number of snapshots failed to be created
Note: This field may return null, indicating that no valid values can be obtained.
     * @param SnapshotFailCnt Number of snapshots failed to be created
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setSnapshotFailCnt(Long SnapshotFailCnt) {
        this.SnapshotFailCnt = SnapshotFailCnt;
    }

    /**
     * Get Whether retry is allowed. 0: not allowed; 1: allowed.Note: This field may return null, indicating that no valid values can be obtained. 
     * @return IsAllowRetry Whether retry is allowed. 0: not allowed; 1: allowed.Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getIsAllowRetry() {
        return this.IsAllowRetry;
    }

    /**
     * Set Whether retry is allowed. 0: not allowed; 1: allowed.Note: This field may return null, indicating that no valid values can be obtained.
     * @param IsAllowRetry Whether retry is allowed. 0: not allowed; 1: allowed.Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setIsAllowRetry(Long IsAllowRetry) {
        this.IsAllowRetry = IsAllowRetry;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeVulFixStatusResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeVulFixStatusResponse(DescribeVulFixStatusResponse source) {
        if (source.FixStartTime != null) {
            this.FixStartTime = new String(source.FixStartTime);
        }
        if (source.FixEndTime != null) {
            this.FixEndTime = new String(source.FixEndTime);
        }
        if (source.FixSuccessCnt != null) {
            this.FixSuccessCnt = new Long(source.FixSuccessCnt);
        }
        if (source.FixFailCnt != null) {
            this.FixFailCnt = new Long(source.FixFailCnt);
        }
        if (source.HostCnt != null) {
            this.HostCnt = new Long(source.HostCnt);
        }
        if (source.FixId != null) {
            this.FixId = new Long(source.FixId);
        }
        if (source.SnapshotList != null) {
            this.SnapshotList = new VulFixStatusSnapshotInfo[source.SnapshotList.length];
            for (int i = 0; i < source.SnapshotList.length; i++) {
                this.SnapshotList[i] = new VulFixStatusSnapshotInfo(source.SnapshotList[i]);
            }
        }
        if (source.VulFixList != null) {
            this.VulFixList = new VulFixStatusInfo[source.VulFixList.length];
            for (int i = 0; i < source.VulFixList.length; i++) {
                this.VulFixList[i] = new VulFixStatusInfo(source.VulFixList[i]);
            }
        }
        if (source.SnapshotProgress != null) {
            this.SnapshotProgress = new Long(source.SnapshotProgress);
        }
        if (source.FixProgress != null) {
            this.FixProgress = new Long(source.FixProgress);
        }
        if (source.RemainingTime != null) {
            this.RemainingTime = new Long(source.RemainingTime);
        }
        if (source.IsRetrySnapshot != null) {
            this.IsRetrySnapshot = new Long(source.IsRetrySnapshot);
        }
        if (source.SnapshotFailCnt != null) {
            this.SnapshotFailCnt = new Long(source.SnapshotFailCnt);
        }
        if (source.IsAllowRetry != null) {
            this.IsAllowRetry = new Long(source.IsAllowRetry);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "FixStartTime", this.FixStartTime);
        this.setParamSimple(map, prefix + "FixEndTime", this.FixEndTime);
        this.setParamSimple(map, prefix + "FixSuccessCnt", this.FixSuccessCnt);
        this.setParamSimple(map, prefix + "FixFailCnt", this.FixFailCnt);
        this.setParamSimple(map, prefix + "HostCnt", this.HostCnt);
        this.setParamSimple(map, prefix + "FixId", this.FixId);
        this.setParamArrayObj(map, prefix + "SnapshotList.", this.SnapshotList);
        this.setParamArrayObj(map, prefix + "VulFixList.", this.VulFixList);
        this.setParamSimple(map, prefix + "SnapshotProgress", this.SnapshotProgress);
        this.setParamSimple(map, prefix + "FixProgress", this.FixProgress);
        this.setParamSimple(map, prefix + "RemainingTime", this.RemainingTime);
        this.setParamSimple(map, prefix + "IsRetrySnapshot", this.IsRetrySnapshot);
        this.setParamSimple(map, prefix + "SnapshotFailCnt", this.SnapshotFailCnt);
        this.setParamSimple(map, prefix + "IsAllowRetry", this.IsAllowRetry);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

