/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeVulHostCountScanTimeResponse extends AbstractModel {

    /**
    * Total number of vulnerabilities
    */
    @SerializedName("TotalVulCount")
    @Expose
    private Long TotalVulCount;

    /**
    * Number of hosts affected by vulnerabilities
    */
    @SerializedName("VulHostCount")
    @Expose
    private Long VulHostCount;

    /**
    * Scan time
    */
    @SerializedName("ScanTime")
    @Expose
    private String ScanTime;

    /**
    * Whether the detection is carried out for the first time
    */
    @SerializedName("IfFirstScan")
    @Expose
    private Boolean IfFirstScan;

    /**
    * ID of the ongoing task. The value is 0 if no such task exists.
    */
    @SerializedName("TaskId")
    @Expose
    private Long TaskId;

    /**
    * Last vulnerability fixing time
    */
    @SerializedName("LastFixTime")
    @Expose
    private String LastFixTime;

    /**
    * Whether vulnerabilities supporting automatic fixing exist
    */
    @SerializedName("hadAutoFixVul")
    @Expose
    private Boolean hadAutoFixVul;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Total number of vulnerabilities 
     * @return TotalVulCount Total number of vulnerabilities
     */
    public Long getTotalVulCount() {
        return this.TotalVulCount;
    }

    /**
     * Set Total number of vulnerabilities
     * @param TotalVulCount Total number of vulnerabilities
     */
    public void setTotalVulCount(Long TotalVulCount) {
        this.TotalVulCount = TotalVulCount;
    }

    /**
     * Get Number of hosts affected by vulnerabilities 
     * @return VulHostCount Number of hosts affected by vulnerabilities
     */
    public Long getVulHostCount() {
        return this.VulHostCount;
    }

    /**
     * Set Number of hosts affected by vulnerabilities
     * @param VulHostCount Number of hosts affected by vulnerabilities
     */
    public void setVulHostCount(Long VulHostCount) {
        this.VulHostCount = VulHostCount;
    }

    /**
     * Get Scan time 
     * @return ScanTime Scan time
     */
    public String getScanTime() {
        return this.ScanTime;
    }

    /**
     * Set Scan time
     * @param ScanTime Scan time
     */
    public void setScanTime(String ScanTime) {
        this.ScanTime = ScanTime;
    }

    /**
     * Get Whether the detection is carried out for the first time 
     * @return IfFirstScan Whether the detection is carried out for the first time
     */
    public Boolean getIfFirstScan() {
        return this.IfFirstScan;
    }

    /**
     * Set Whether the detection is carried out for the first time
     * @param IfFirstScan Whether the detection is carried out for the first time
     */
    public void setIfFirstScan(Boolean IfFirstScan) {
        this.IfFirstScan = IfFirstScan;
    }

    /**
     * Get ID of the ongoing task. The value is 0 if no such task exists. 
     * @return TaskId ID of the ongoing task. The value is 0 if no such task exists.
     */
    public Long getTaskId() {
        return this.TaskId;
    }

    /**
     * Set ID of the ongoing task. The value is 0 if no such task exists.
     * @param TaskId ID of the ongoing task. The value is 0 if no such task exists.
     */
    public void setTaskId(Long TaskId) {
        this.TaskId = TaskId;
    }

    /**
     * Get Last vulnerability fixing time 
     * @return LastFixTime Last vulnerability fixing time
     */
    public String getLastFixTime() {
        return this.LastFixTime;
    }

    /**
     * Set Last vulnerability fixing time
     * @param LastFixTime Last vulnerability fixing time
     */
    public void setLastFixTime(String LastFixTime) {
        this.LastFixTime = LastFixTime;
    }

    /**
     * Get Whether vulnerabilities supporting automatic fixing exist 
     * @return hadAutoFixVul Whether vulnerabilities supporting automatic fixing exist
     */
    public Boolean gethadAutoFixVul() {
        return this.hadAutoFixVul;
    }

    /**
     * Set Whether vulnerabilities supporting automatic fixing exist
     * @param hadAutoFixVul Whether vulnerabilities supporting automatic fixing exist
     */
    public void sethadAutoFixVul(Boolean hadAutoFixVul) {
        this.hadAutoFixVul = hadAutoFixVul;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeVulHostCountScanTimeResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeVulHostCountScanTimeResponse(DescribeVulHostCountScanTimeResponse source) {
        if (source.TotalVulCount != null) {
            this.TotalVulCount = new Long(source.TotalVulCount);
        }
        if (source.VulHostCount != null) {
            this.VulHostCount = new Long(source.VulHostCount);
        }
        if (source.ScanTime != null) {
            this.ScanTime = new String(source.ScanTime);
        }
        if (source.IfFirstScan != null) {
            this.IfFirstScan = new Boolean(source.IfFirstScan);
        }
        if (source.TaskId != null) {
            this.TaskId = new Long(source.TaskId);
        }
        if (source.LastFixTime != null) {
            this.LastFixTime = new String(source.LastFixTime);
        }
        if (source.hadAutoFixVul != null) {
            this.hadAutoFixVul = new Boolean(source.hadAutoFixVul);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "TotalVulCount", this.TotalVulCount);
        this.setParamSimple(map, prefix + "VulHostCount", this.VulHostCount);
        this.setParamSimple(map, prefix + "ScanTime", this.ScanTime);
        this.setParamSimple(map, prefix + "IfFirstScan", this.IfFirstScan);
        this.setParamSimple(map, prefix + "TaskId", this.TaskId);
        this.setParamSimple(map, prefix + "LastFixTime", this.LastFixTime);
        this.setParamSimple(map, prefix + "hadAutoFixVul", this.hadAutoFixVul);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

