/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeVulListResponse extends AbstractModel {

    /**
    * Vulnerability list
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("VulInfoList")
    @Expose
    private VulInfoList [] VulInfoList;

    /**
    * Total number of vulnerabilities
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("TotalCount")
    @Expose
    private Long TotalCount;

    /**
    * Total number of focused vulnerabilities
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("FollowVulCount")
    @Expose
    private Long FollowVulCount;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Vulnerability list
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return VulInfoList Vulnerability list
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public VulInfoList [] getVulInfoList() {
        return this.VulInfoList;
    }

    /**
     * Set Vulnerability list
Note: This field may return null, indicating that no valid values can be obtained.
     * @param VulInfoList Vulnerability list
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setVulInfoList(VulInfoList [] VulInfoList) {
        this.VulInfoList = VulInfoList;
    }

    /**
     * Get Total number of vulnerabilities
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return TotalCount Total number of vulnerabilities
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getTotalCount() {
        return this.TotalCount;
    }

    /**
     * Set Total number of vulnerabilities
Note: This field may return null, indicating that no valid values can be obtained.
     * @param TotalCount Total number of vulnerabilities
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setTotalCount(Long TotalCount) {
        this.TotalCount = TotalCount;
    }

    /**
     * Get Total number of focused vulnerabilities
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return FollowVulCount Total number of focused vulnerabilities
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getFollowVulCount() {
        return this.FollowVulCount;
    }

    /**
     * Set Total number of focused vulnerabilities
Note: This field may return null, indicating that no valid values can be obtained.
     * @param FollowVulCount Total number of focused vulnerabilities
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setFollowVulCount(Long FollowVulCount) {
        this.FollowVulCount = FollowVulCount;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeVulListResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeVulListResponse(DescribeVulListResponse source) {
        if (source.VulInfoList != null) {
            this.VulInfoList = new VulInfoList[source.VulInfoList.length];
            for (int i = 0; i < source.VulInfoList.length; i++) {
                this.VulInfoList[i] = new VulInfoList(source.VulInfoList[i]);
            }
        }
        if (source.TotalCount != null) {
            this.TotalCount = new Long(source.TotalCount);
        }
        if (source.FollowVulCount != null) {
            this.FollowVulCount = new Long(source.FollowVulCount);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "VulInfoList.", this.VulInfoList);
        this.setParamSimple(map, prefix + "TotalCount", this.TotalCount);
        this.setParamSimple(map, prefix + "FollowVulCount", this.FollowVulCount);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

