/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeVulOverviewResponse extends AbstractModel {

    /**
    * Statistics on focused vulnerabilities
    */
    @SerializedName("FollowVul")
    @Expose
    private VulOverview FollowVul;

    /**
    * Statistics on all vulnerabilities
    */
    @SerializedName("AllVul")
    @Expose
    private VulOverview AllVul;

    /**
    * Statistics on affected hosts
    */
    @SerializedName("EffectHost")
    @Expose
    private VulOverview EffectHost;

    /**
    * Statistics on vulnerability attack event (past 1 month)
    */
    @SerializedName("VulAttackEvent")
    @Expose
    private VulOverview VulAttackEvent;

    /**
    * Statistics on defended attacks (past 1 month)
    */
    @SerializedName("VulDefenceEvent")
    @Expose
    private VulOverview VulDefenceEvent;

    /**
    * Vulnerability database statistics
    */
    @SerializedName("VulStore")
    @Expose
    private VulOverview VulStore;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Statistics on focused vulnerabilities 
     * @return FollowVul Statistics on focused vulnerabilities
     */
    public VulOverview getFollowVul() {
        return this.FollowVul;
    }

    /**
     * Set Statistics on focused vulnerabilities
     * @param FollowVul Statistics on focused vulnerabilities
     */
    public void setFollowVul(VulOverview FollowVul) {
        this.FollowVul = FollowVul;
    }

    /**
     * Get Statistics on all vulnerabilities 
     * @return AllVul Statistics on all vulnerabilities
     */
    public VulOverview getAllVul() {
        return this.AllVul;
    }

    /**
     * Set Statistics on all vulnerabilities
     * @param AllVul Statistics on all vulnerabilities
     */
    public void setAllVul(VulOverview AllVul) {
        this.AllVul = AllVul;
    }

    /**
     * Get Statistics on affected hosts 
     * @return EffectHost Statistics on affected hosts
     */
    public VulOverview getEffectHost() {
        return this.EffectHost;
    }

    /**
     * Set Statistics on affected hosts
     * @param EffectHost Statistics on affected hosts
     */
    public void setEffectHost(VulOverview EffectHost) {
        this.EffectHost = EffectHost;
    }

    /**
     * Get Statistics on vulnerability attack event (past 1 month) 
     * @return VulAttackEvent Statistics on vulnerability attack event (past 1 month)
     */
    public VulOverview getVulAttackEvent() {
        return this.VulAttackEvent;
    }

    /**
     * Set Statistics on vulnerability attack event (past 1 month)
     * @param VulAttackEvent Statistics on vulnerability attack event (past 1 month)
     */
    public void setVulAttackEvent(VulOverview VulAttackEvent) {
        this.VulAttackEvent = VulAttackEvent;
    }

    /**
     * Get Statistics on defended attacks (past 1 month) 
     * @return VulDefenceEvent Statistics on defended attacks (past 1 month)
     */
    public VulOverview getVulDefenceEvent() {
        return this.VulDefenceEvent;
    }

    /**
     * Set Statistics on defended attacks (past 1 month)
     * @param VulDefenceEvent Statistics on defended attacks (past 1 month)
     */
    public void setVulDefenceEvent(VulOverview VulDefenceEvent) {
        this.VulDefenceEvent = VulDefenceEvent;
    }

    /**
     * Get Vulnerability database statistics 
     * @return VulStore Vulnerability database statistics
     */
    public VulOverview getVulStore() {
        return this.VulStore;
    }

    /**
     * Set Vulnerability database statistics
     * @param VulStore Vulnerability database statistics
     */
    public void setVulStore(VulOverview VulStore) {
        this.VulStore = VulStore;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeVulOverviewResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeVulOverviewResponse(DescribeVulOverviewResponse source) {
        if (source.FollowVul != null) {
            this.FollowVul = new VulOverview(source.FollowVul);
        }
        if (source.AllVul != null) {
            this.AllVul = new VulOverview(source.AllVul);
        }
        if (source.EffectHost != null) {
            this.EffectHost = new VulOverview(source.EffectHost);
        }
        if (source.VulAttackEvent != null) {
            this.VulAttackEvent = new VulOverview(source.VulAttackEvent);
        }
        if (source.VulDefenceEvent != null) {
            this.VulDefenceEvent = new VulOverview(source.VulDefenceEvent);
        }
        if (source.VulStore != null) {
            this.VulStore = new VulOverview(source.VulStore);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamObj(map, prefix + "FollowVul.", this.FollowVul);
        this.setParamObj(map, prefix + "AllVul.", this.AllVul);
        this.setParamObj(map, prefix + "EffectHost.", this.EffectHost);
        this.setParamObj(map, prefix + "VulAttackEvent.", this.VulAttackEvent);
        this.setParamObj(map, prefix + "VulDefenceEvent.", this.VulDefenceEvent);
        this.setParamObj(map, prefix + "VulStore.", this.VulStore);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

