/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeVulStoreListResponse extends AbstractModel {

    /**
    * Vulnerability information
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("List")
    @Expose
    private VulStoreListInfo [] List;

    /**
    * Total number
    */
    @SerializedName("TotalCount")
    @Expose
    private Long TotalCount;

    /**
    * Remaining Searches for Today
    */
    @SerializedName("Remaining")
    @Expose
    private Long Remaining;

    /**
    * Free Search Count
    */
    @SerializedName("FreeSearchTimes")
    @Expose
    private Long FreeSearchTimes;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Vulnerability information
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return List Vulnerability information
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public VulStoreListInfo [] getList() {
        return this.List;
    }

    /**
     * Set Vulnerability information
Note: This field may return null, indicating that no valid values can be obtained.
     * @param List Vulnerability information
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setList(VulStoreListInfo [] List) {
        this.List = List;
    }

    /**
     * Get Total number 
     * @return TotalCount Total number
     */
    public Long getTotalCount() {
        return this.TotalCount;
    }

    /**
     * Set Total number
     * @param TotalCount Total number
     */
    public void setTotalCount(Long TotalCount) {
        this.TotalCount = TotalCount;
    }

    /**
     * Get Remaining Searches for Today 
     * @return Remaining Remaining Searches for Today
     */
    public Long getRemaining() {
        return this.Remaining;
    }

    /**
     * Set Remaining Searches for Today
     * @param Remaining Remaining Searches for Today
     */
    public void setRemaining(Long Remaining) {
        this.Remaining = Remaining;
    }

    /**
     * Get Free Search Count 
     * @return FreeSearchTimes Free Search Count
     */
    public Long getFreeSearchTimes() {
        return this.FreeSearchTimes;
    }

    /**
     * Set Free Search Count
     * @param FreeSearchTimes Free Search Count
     */
    public void setFreeSearchTimes(Long FreeSearchTimes) {
        this.FreeSearchTimes = FreeSearchTimes;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeVulStoreListResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeVulStoreListResponse(DescribeVulStoreListResponse source) {
        if (source.List != null) {
            this.List = new VulStoreListInfo[source.List.length];
            for (int i = 0; i < source.List.length; i++) {
                this.List[i] = new VulStoreListInfo(source.List[i]);
            }
        }
        if (source.TotalCount != null) {
            this.TotalCount = new Long(source.TotalCount);
        }
        if (source.Remaining != null) {
            this.Remaining = new Long(source.Remaining);
        }
        if (source.FreeSearchTimes != null) {
            this.FreeSearchTimes = new Long(source.FreeSearchTimes);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "List.", this.List);
        this.setParamSimple(map, prefix + "TotalCount", this.TotalCount);
        this.setParamSimple(map, prefix + "Remaining", this.Remaining);
        this.setParamSimple(map, prefix + "FreeSearchTimes", this.FreeSearchTimes);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

