/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class MalWareList extends AbstractModel {

    /**
    * Server IP address
    */
    @SerializedName("HostIp")
    @Expose
    private String HostIp;

    /**
    * UUID
    */
    @SerializedName("Uuid")
    @Expose
    private String Uuid;

    /**
    * Path
    */
    @SerializedName("FilePath")
    @Expose
    private String FilePath;

    /**
    * Description
    */
    @SerializedName("VirusName")
    @Expose
    private String VirusName;

    /**
    * Status: 4-Pending, 5-Trusted, 6-Isolated, 8-Files Deleted, 14-Processed.
    */
    @SerializedName("Status")
    @Expose
    private Long Status;

    /**
    * Unique ID
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Id")
    @Expose
    private Long Id;

    /**
    * Host alias
    */
    @SerializedName("Alias")
    @Expose
    private String Alias;

    /**
    * Feature tag. This field has been deprecated, and no tag will be returned. Tags are returned in the details.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Tags")
    @Expose
    private String [] Tags;

    /**
    * First running time
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("FileCreateTime")
    @Expose
    private String FileCreateTime;

    /**
    * Last running time
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("FileModifierTime")
    @Expose
    private String FileModifierTime;

    /**
    * Creation time
    */
    @SerializedName("CreateTime")
    @Expose
    private String CreateTime;

    /**
    * Last scan time
    */
    @SerializedName("LatestScanTime")
    @Expose
    private String LatestScanTime;

    /**
    * Risk level. 0: unknown; 1: low; 2: medium; 3: high; 4: critical.
    */
    @SerializedName("Level")
    @Expose
    private Long Level;

    /**
    * Trojan detection platforms, separated with commas. 1: cloud security engine; 2: TAV; 3: BinaryAI; 4: abnormal behavior; 5: threat intelligence.
    */
    @SerializedName("CheckPlatform")
    @Expose
    private String CheckPlatform;

    /**
    * Whether the Trojan process exists. 0: no; 1: yes.
    */
    @SerializedName("ProcessExists")
    @Expose
    private Long ProcessExists;

    /**
    * Whether the Trojan file exists. 0: no; 1: yes.
    */
    @SerializedName("FileExists")
    @Expose
    private Long FileExists;

    /**
    * cvm quuid
    */
    @SerializedName("Quuid")
    @Expose
    private String Quuid;

    /**
    * Trojan sample MD5
    */
    @SerializedName("MD5")
    @Expose
    private String MD5;

    /**
    * Additional information
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("MachineExtraInfo")
    @Expose
    private MachineExtraInfo MachineExtraInfo;

    /**
     * Get Server IP address 
     * @return HostIp Server IP address
     */
    public String getHostIp() {
        return this.HostIp;
    }

    /**
     * Set Server IP address
     * @param HostIp Server IP address
     */
    public void setHostIp(String HostIp) {
        this.HostIp = HostIp;
    }

    /**
     * Get UUID 
     * @return Uuid UUID
     */
    public String getUuid() {
        return this.Uuid;
    }

    /**
     * Set UUID
     * @param Uuid UUID
     */
    public void setUuid(String Uuid) {
        this.Uuid = Uuid;
    }

    /**
     * Get Path 
     * @return FilePath Path
     */
    public String getFilePath() {
        return this.FilePath;
    }

    /**
     * Set Path
     * @param FilePath Path
     */
    public void setFilePath(String FilePath) {
        this.FilePath = FilePath;
    }

    /**
     * Get Description 
     * @return VirusName Description
     */
    public String getVirusName() {
        return this.VirusName;
    }

    /**
     * Set Description
     * @param VirusName Description
     */
    public void setVirusName(String VirusName) {
        this.VirusName = VirusName;
    }

    /**
     * Get Status: 4-Pending, 5-Trusted, 6-Isolated, 8-Files Deleted, 14-Processed. 
     * @return Status Status: 4-Pending, 5-Trusted, 6-Isolated, 8-Files Deleted, 14-Processed.
     */
    public Long getStatus() {
        return this.Status;
    }

    /**
     * Set Status: 4-Pending, 5-Trusted, 6-Isolated, 8-Files Deleted, 14-Processed.
     * @param Status Status: 4-Pending, 5-Trusted, 6-Isolated, 8-Files Deleted, 14-Processed.
     */
    public void setStatus(Long Status) {
        this.Status = Status;
    }

    /**
     * Get Unique ID
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return Id Unique ID
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getId() {
        return this.Id;
    }

    /**
     * Set Unique ID
Note: This field may return null, indicating that no valid values can be obtained.
     * @param Id Unique ID
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setId(Long Id) {
        this.Id = Id;
    }

    /**
     * Get Host alias 
     * @return Alias Host alias
     */
    public String getAlias() {
        return this.Alias;
    }

    /**
     * Set Host alias
     * @param Alias Host alias
     */
    public void setAlias(String Alias) {
        this.Alias = Alias;
    }

    /**
     * Get Feature tag. This field has been deprecated, and no tag will be returned. Tags are returned in the details.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return Tags Feature tag. This field has been deprecated, and no tag will be returned. Tags are returned in the details.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String [] getTags() {
        return this.Tags;
    }

    /**
     * Set Feature tag. This field has been deprecated, and no tag will be returned. Tags are returned in the details.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param Tags Feature tag. This field has been deprecated, and no tag will be returned. Tags are returned in the details.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setTags(String [] Tags) {
        this.Tags = Tags;
    }

    /**
     * Get First running time
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return FileCreateTime First running time
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String getFileCreateTime() {
        return this.FileCreateTime;
    }

    /**
     * Set First running time
Note: This field may return null, indicating that no valid values can be obtained.
     * @param FileCreateTime First running time
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setFileCreateTime(String FileCreateTime) {
        this.FileCreateTime = FileCreateTime;
    }

    /**
     * Get Last running time
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return FileModifierTime Last running time
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String getFileModifierTime() {
        return this.FileModifierTime;
    }

    /**
     * Set Last running time
Note: This field may return null, indicating that no valid values can be obtained.
     * @param FileModifierTime Last running time
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setFileModifierTime(String FileModifierTime) {
        this.FileModifierTime = FileModifierTime;
    }

    /**
     * Get Creation time 
     * @return CreateTime Creation time
     */
    public String getCreateTime() {
        return this.CreateTime;
    }

    /**
     * Set Creation time
     * @param CreateTime Creation time
     */
    public void setCreateTime(String CreateTime) {
        this.CreateTime = CreateTime;
    }

    /**
     * Get Last scan time 
     * @return LatestScanTime Last scan time
     */
    public String getLatestScanTime() {
        return this.LatestScanTime;
    }

    /**
     * Set Last scan time
     * @param LatestScanTime Last scan time
     */
    public void setLatestScanTime(String LatestScanTime) {
        this.LatestScanTime = LatestScanTime;
    }

    /**
     * Get Risk level. 0: unknown; 1: low; 2: medium; 3: high; 4: critical. 
     * @return Level Risk level. 0: unknown; 1: low; 2: medium; 3: high; 4: critical.
     */
    public Long getLevel() {
        return this.Level;
    }

    /**
     * Set Risk level. 0: unknown; 1: low; 2: medium; 3: high; 4: critical.
     * @param Level Risk level. 0: unknown; 1: low; 2: medium; 3: high; 4: critical.
     */
    public void setLevel(Long Level) {
        this.Level = Level;
    }

    /**
     * Get Trojan detection platforms, separated with commas. 1: cloud security engine; 2: TAV; 3: BinaryAI; 4: abnormal behavior; 5: threat intelligence. 
     * @return CheckPlatform Trojan detection platforms, separated with commas. 1: cloud security engine; 2: TAV; 3: BinaryAI; 4: abnormal behavior; 5: threat intelligence.
     */
    public String getCheckPlatform() {
        return this.CheckPlatform;
    }

    /**
     * Set Trojan detection platforms, separated with commas. 1: cloud security engine; 2: TAV; 3: BinaryAI; 4: abnormal behavior; 5: threat intelligence.
     * @param CheckPlatform Trojan detection platforms, separated with commas. 1: cloud security engine; 2: TAV; 3: BinaryAI; 4: abnormal behavior; 5: threat intelligence.
     */
    public void setCheckPlatform(String CheckPlatform) {
        this.CheckPlatform = CheckPlatform;
    }

    /**
     * Get Whether the Trojan process exists. 0: no; 1: yes. 
     * @return ProcessExists Whether the Trojan process exists. 0: no; 1: yes.
     */
    public Long getProcessExists() {
        return this.ProcessExists;
    }

    /**
     * Set Whether the Trojan process exists. 0: no; 1: yes.
     * @param ProcessExists Whether the Trojan process exists. 0: no; 1: yes.
     */
    public void setProcessExists(Long ProcessExists) {
        this.ProcessExists = ProcessExists;
    }

    /**
     * Get Whether the Trojan file exists. 0: no; 1: yes. 
     * @return FileExists Whether the Trojan file exists. 0: no; 1: yes.
     */
    public Long getFileExists() {
        return this.FileExists;
    }

    /**
     * Set Whether the Trojan file exists. 0: no; 1: yes.
     * @param FileExists Whether the Trojan file exists. 0: no; 1: yes.
     */
    public void setFileExists(Long FileExists) {
        this.FileExists = FileExists;
    }

    /**
     * Get cvm quuid 
     * @return Quuid cvm quuid
     */
    public String getQuuid() {
        return this.Quuid;
    }

    /**
     * Set cvm quuid
     * @param Quuid cvm quuid
     */
    public void setQuuid(String Quuid) {
        this.Quuid = Quuid;
    }

    /**
     * Get Trojan sample MD5 
     * @return MD5 Trojan sample MD5
     */
    public String getMD5() {
        return this.MD5;
    }

    /**
     * Set Trojan sample MD5
     * @param MD5 Trojan sample MD5
     */
    public void setMD5(String MD5) {
        this.MD5 = MD5;
    }

    /**
     * Get Additional information
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return MachineExtraInfo Additional information
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public MachineExtraInfo getMachineExtraInfo() {
        return this.MachineExtraInfo;
    }

    /**
     * Set Additional information
Note: This field may return null, indicating that no valid values can be obtained.
     * @param MachineExtraInfo Additional information
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setMachineExtraInfo(MachineExtraInfo MachineExtraInfo) {
        this.MachineExtraInfo = MachineExtraInfo;
    }

    public MalWareList() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public MalWareList(MalWareList source) {
        if (source.HostIp != null) {
            this.HostIp = new String(source.HostIp);
        }
        if (source.Uuid != null) {
            this.Uuid = new String(source.Uuid);
        }
        if (source.FilePath != null) {
            this.FilePath = new String(source.FilePath);
        }
        if (source.VirusName != null) {
            this.VirusName = new String(source.VirusName);
        }
        if (source.Status != null) {
            this.Status = new Long(source.Status);
        }
        if (source.Id != null) {
            this.Id = new Long(source.Id);
        }
        if (source.Alias != null) {
            this.Alias = new String(source.Alias);
        }
        if (source.Tags != null) {
            this.Tags = new String[source.Tags.length];
            for (int i = 0; i < source.Tags.length; i++) {
                this.Tags[i] = new String(source.Tags[i]);
            }
        }
        if (source.FileCreateTime != null) {
            this.FileCreateTime = new String(source.FileCreateTime);
        }
        if (source.FileModifierTime != null) {
            this.FileModifierTime = new String(source.FileModifierTime);
        }
        if (source.CreateTime != null) {
            this.CreateTime = new String(source.CreateTime);
        }
        if (source.LatestScanTime != null) {
            this.LatestScanTime = new String(source.LatestScanTime);
        }
        if (source.Level != null) {
            this.Level = new Long(source.Level);
        }
        if (source.CheckPlatform != null) {
            this.CheckPlatform = new String(source.CheckPlatform);
        }
        if (source.ProcessExists != null) {
            this.ProcessExists = new Long(source.ProcessExists);
        }
        if (source.FileExists != null) {
            this.FileExists = new Long(source.FileExists);
        }
        if (source.Quuid != null) {
            this.Quuid = new String(source.Quuid);
        }
        if (source.MD5 != null) {
            this.MD5 = new String(source.MD5);
        }
        if (source.MachineExtraInfo != null) {
            this.MachineExtraInfo = new MachineExtraInfo(source.MachineExtraInfo);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "HostIp", this.HostIp);
        this.setParamSimple(map, prefix + "Uuid", this.Uuid);
        this.setParamSimple(map, prefix + "FilePath", this.FilePath);
        this.setParamSimple(map, prefix + "VirusName", this.VirusName);
        this.setParamSimple(map, prefix + "Status", this.Status);
        this.setParamSimple(map, prefix + "Id", this.Id);
        this.setParamSimple(map, prefix + "Alias", this.Alias);
        this.setParamArraySimple(map, prefix + "Tags.", this.Tags);
        this.setParamSimple(map, prefix + "FileCreateTime", this.FileCreateTime);
        this.setParamSimple(map, prefix + "FileModifierTime", this.FileModifierTime);
        this.setParamSimple(map, prefix + "CreateTime", this.CreateTime);
        this.setParamSimple(map, prefix + "LatestScanTime", this.LatestScanTime);
        this.setParamSimple(map, prefix + "Level", this.Level);
        this.setParamSimple(map, prefix + "CheckPlatform", this.CheckPlatform);
        this.setParamSimple(map, prefix + "ProcessExists", this.ProcessExists);
        this.setParamSimple(map, prefix + "FileExists", this.FileExists);
        this.setParamSimple(map, prefix + "Quuid", this.Quuid);
        this.setParamSimple(map, prefix + "MD5", this.MD5);
        this.setParamObj(map, prefix + "MachineExtraInfo.", this.MachineExtraInfo);

    }
}

