/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class MalwareInfo extends AbstractModel {

    /**
    * Virus name
    */
    @SerializedName("VirusName")
    @Expose
    private String VirusName;

    /**
    * File size
    */
    @SerializedName("FileSize")
    @Expose
    private Long FileSize;

    /**
    * File MD5
    */
    @SerializedName("MD5")
    @Expose
    private String MD5;

    /**
    * File address
    */
    @SerializedName("FilePath")
    @Expose
    private String FilePath;

    /**
    * First running time
    */
    @SerializedName("FileCreateTime")
    @Expose
    private String FileCreateTime;

    /**
    * Last running time
    */
    @SerializedName("FileModifierTime")
    @Expose
    private String FileModifierTime;

    /**
    * Severity description
    */
    @SerializedName("HarmDescribe")
    @Expose
    private String HarmDescribe;

    /**
    * Recommended solution
    */
    @SerializedName("SuggestScheme")
    @Expose
    private String SuggestScheme;

    /**
    * Server name
    */
    @SerializedName("ServersName")
    @Expose
    private String ServersName;

    /**
    * Server IP
    */
    @SerializedName("HostIp")
    @Expose
    private String HostIp;

    /**
    * Process name
    */
    @SerializedName("ProcessName")
    @Expose
    private String ProcessName;

    /**
    * Process ID
    */
    @SerializedName("ProcessID")
    @Expose
    private String ProcessID;

    /**
    * Tag Features
    */
    @SerializedName("Tags")
    @Expose
    private String [] Tags;

    /**
    * Impact breadth // Not provided currently
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Breadth")
    @Expose
    private String Breadth;

    /**
    * Search popularity // Not provided currently
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Heat")
    @Expose
    private String Heat;

    /**
    * Unique ID
    */
    @SerializedName("Id")
    @Expose
    private Long Id;

    /**
    * File name
    */
    @SerializedName("FileName")
    @Expose
    private String FileName;

    /**
    * First detection time
    */
    @SerializedName("CreateTime")
    @Expose
    private String CreateTime;

    /**
    * Last scan time
    */
    @SerializedName("LatestScanTime")
    @Expose
    private String LatestScanTime;

    /**
    * Reference link
    */
    @SerializedName("Reference")
    @Expose
    private String Reference;

    /**
    * Public IP address
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("MachineWanIp")
    @Expose
    private String MachineWanIp;

    /**
    * Process tree in JSON format. pid: process ID; exe: file path; account: groups and users to which the process belongs; cmdline: executed commands; ssh_service: SSH service IP; ssh_source: log-in source
.Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("PsTree")
    @Expose
    private String PsTree;

    /**
    * Online status of a host: OFFLINE and ONLINE
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("MachineStatus")
    @Expose
    private String MachineStatus;

    /**
    * Status. 4: pending; 5: trusted; 6: isolated.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Status")
    @Expose
    private Long Status;

    /**
    * Risk level. 0: prompt; 1: low; 2: medium; 3: high; 4: critical.Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Level")
    @Expose
    private Long Level;

    /**
    * Trojan detection platforms, separated with commas. 1: cloud security engine; 2: TAV; 3: BinaryAI; 4: abnormal behavior; 5: threat intelligence.Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("CheckPlatform")
    @Expose
    private String CheckPlatform;

    /**
    * Host UUID
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Uuid")
    @Expose
    private String Uuid;

    /**
    * Last modification time
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("ModifyTime")
    @Expose
    private String ModifyTime;

    /**
    * Last access time
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("StrFileAccessTime")
    @Expose
    private String StrFileAccessTime;

    /**
    * Additional information
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("MachineExtraInfo")
    @Expose
    private MachineExtraInfo MachineExtraInfo;

    /**
     * Get Virus name 
     * @return VirusName Virus name
     */
    public String getVirusName() {
        return this.VirusName;
    }

    /**
     * Set Virus name
     * @param VirusName Virus name
     */
    public void setVirusName(String VirusName) {
        this.VirusName = VirusName;
    }

    /**
     * Get File size 
     * @return FileSize File size
     */
    public Long getFileSize() {
        return this.FileSize;
    }

    /**
     * Set File size
     * @param FileSize File size
     */
    public void setFileSize(Long FileSize) {
        this.FileSize = FileSize;
    }

    /**
     * Get File MD5 
     * @return MD5 File MD5
     */
    public String getMD5() {
        return this.MD5;
    }

    /**
     * Set File MD5
     * @param MD5 File MD5
     */
    public void setMD5(String MD5) {
        this.MD5 = MD5;
    }

    /**
     * Get File address 
     * @return FilePath File address
     */
    public String getFilePath() {
        return this.FilePath;
    }

    /**
     * Set File address
     * @param FilePath File address
     */
    public void setFilePath(String FilePath) {
        this.FilePath = FilePath;
    }

    /**
     * Get First running time 
     * @return FileCreateTime First running time
     */
    public String getFileCreateTime() {
        return this.FileCreateTime;
    }

    /**
     * Set First running time
     * @param FileCreateTime First running time
     */
    public void setFileCreateTime(String FileCreateTime) {
        this.FileCreateTime = FileCreateTime;
    }

    /**
     * Get Last running time 
     * @return FileModifierTime Last running time
     */
    public String getFileModifierTime() {
        return this.FileModifierTime;
    }

    /**
     * Set Last running time
     * @param FileModifierTime Last running time
     */
    public void setFileModifierTime(String FileModifierTime) {
        this.FileModifierTime = FileModifierTime;
    }

    /**
     * Get Severity description 
     * @return HarmDescribe Severity description
     */
    public String getHarmDescribe() {
        return this.HarmDescribe;
    }

    /**
     * Set Severity description
     * @param HarmDescribe Severity description
     */
    public void setHarmDescribe(String HarmDescribe) {
        this.HarmDescribe = HarmDescribe;
    }

    /**
     * Get Recommended solution 
     * @return SuggestScheme Recommended solution
     */
    public String getSuggestScheme() {
        return this.SuggestScheme;
    }

    /**
     * Set Recommended solution
     * @param SuggestScheme Recommended solution
     */
    public void setSuggestScheme(String SuggestScheme) {
        this.SuggestScheme = SuggestScheme;
    }

    /**
     * Get Server name 
     * @return ServersName Server name
     */
    public String getServersName() {
        return this.ServersName;
    }

    /**
     * Set Server name
     * @param ServersName Server name
     */
    public void setServersName(String ServersName) {
        this.ServersName = ServersName;
    }

    /**
     * Get Server IP 
     * @return HostIp Server IP
     */
    public String getHostIp() {
        return this.HostIp;
    }

    /**
     * Set Server IP
     * @param HostIp Server IP
     */
    public void setHostIp(String HostIp) {
        this.HostIp = HostIp;
    }

    /**
     * Get Process name 
     * @return ProcessName Process name
     */
    public String getProcessName() {
        return this.ProcessName;
    }

    /**
     * Set Process name
     * @param ProcessName Process name
     */
    public void setProcessName(String ProcessName) {
        this.ProcessName = ProcessName;
    }

    /**
     * Get Process ID 
     * @return ProcessID Process ID
     */
    public String getProcessID() {
        return this.ProcessID;
    }

    /**
     * Set Process ID
     * @param ProcessID Process ID
     */
    public void setProcessID(String ProcessID) {
        this.ProcessID = ProcessID;
    }

    /**
     * Get Tag Features 
     * @return Tags Tag Features
     */
    public String [] getTags() {
        return this.Tags;
    }

    /**
     * Set Tag Features
     * @param Tags Tag Features
     */
    public void setTags(String [] Tags) {
        this.Tags = Tags;
    }

    /**
     * Get Impact breadth // Not provided currently
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return Breadth Impact breadth // Not provided currently
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String getBreadth() {
        return this.Breadth;
    }

    /**
     * Set Impact breadth // Not provided currently
Note: This field may return null, indicating that no valid values can be obtained.
     * @param Breadth Impact breadth // Not provided currently
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setBreadth(String Breadth) {
        this.Breadth = Breadth;
    }

    /**
     * Get Search popularity // Not provided currently
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return Heat Search popularity // Not provided currently
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String getHeat() {
        return this.Heat;
    }

    /**
     * Set Search popularity // Not provided currently
Note: This field may return null, indicating that no valid values can be obtained.
     * @param Heat Search popularity // Not provided currently
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setHeat(String Heat) {
        this.Heat = Heat;
    }

    /**
     * Get Unique ID 
     * @return Id Unique ID
     */
    public Long getId() {
        return this.Id;
    }

    /**
     * Set Unique ID
     * @param Id Unique ID
     */
    public void setId(Long Id) {
        this.Id = Id;
    }

    /**
     * Get File name 
     * @return FileName File name
     */
    public String getFileName() {
        return this.FileName;
    }

    /**
     * Set File name
     * @param FileName File name
     */
    public void setFileName(String FileName) {
        this.FileName = FileName;
    }

    /**
     * Get First detection time 
     * @return CreateTime First detection time
     */
    public String getCreateTime() {
        return this.CreateTime;
    }

    /**
     * Set First detection time
     * @param CreateTime First detection time
     */
    public void setCreateTime(String CreateTime) {
        this.CreateTime = CreateTime;
    }

    /**
     * Get Last scan time 
     * @return LatestScanTime Last scan time
     */
    public String getLatestScanTime() {
        return this.LatestScanTime;
    }

    /**
     * Set Last scan time
     * @param LatestScanTime Last scan time
     */
    public void setLatestScanTime(String LatestScanTime) {
        this.LatestScanTime = LatestScanTime;
    }

    /**
     * Get Reference link 
     * @return Reference Reference link
     */
    public String getReference() {
        return this.Reference;
    }

    /**
     * Set Reference link
     * @param Reference Reference link
     */
    public void setReference(String Reference) {
        this.Reference = Reference;
    }

    /**
     * Get Public IP address
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return MachineWanIp Public IP address
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String getMachineWanIp() {
        return this.MachineWanIp;
    }

    /**
     * Set Public IP address
Note: This field may return null, indicating that no valid values can be obtained.
     * @param MachineWanIp Public IP address
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setMachineWanIp(String MachineWanIp) {
        this.MachineWanIp = MachineWanIp;
    }

    /**
     * Get Process tree in JSON format. pid: process ID; exe: file path; account: groups and users to which the process belongs; cmdline: executed commands; ssh_service: SSH service IP; ssh_source: log-in source
.Note: This field may return null, indicating that no valid values can be obtained. 
     * @return PsTree Process tree in JSON format. pid: process ID; exe: file path; account: groups and users to which the process belongs; cmdline: executed commands; ssh_service: SSH service IP; ssh_source: log-in source
.Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String getPsTree() {
        return this.PsTree;
    }

    /**
     * Set Process tree in JSON format. pid: process ID; exe: file path; account: groups and users to which the process belongs; cmdline: executed commands; ssh_service: SSH service IP; ssh_source: log-in source
.Note: This field may return null, indicating that no valid values can be obtained.
     * @param PsTree Process tree in JSON format. pid: process ID; exe: file path; account: groups and users to which the process belongs; cmdline: executed commands; ssh_service: SSH service IP; ssh_source: log-in source
.Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setPsTree(String PsTree) {
        this.PsTree = PsTree;
    }

    /**
     * Get Online status of a host: OFFLINE and ONLINE
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return MachineStatus Online status of a host: OFFLINE and ONLINE
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String getMachineStatus() {
        return this.MachineStatus;
    }

    /**
     * Set Online status of a host: OFFLINE and ONLINE
Note: This field may return null, indicating that no valid values can be obtained.
     * @param MachineStatus Online status of a host: OFFLINE and ONLINE
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setMachineStatus(String MachineStatus) {
        this.MachineStatus = MachineStatus;
    }

    /**
     * Get Status. 4: pending; 5: trusted; 6: isolated.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return Status Status. 4: pending; 5: trusted; 6: isolated.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getStatus() {
        return this.Status;
    }

    /**
     * Set Status. 4: pending; 5: trusted; 6: isolated.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param Status Status. 4: pending; 5: trusted; 6: isolated.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setStatus(Long Status) {
        this.Status = Status;
    }

    /**
     * Get Risk level. 0: prompt; 1: low; 2: medium; 3: high; 4: critical.Note: This field may return null, indicating that no valid values can be obtained. 
     * @return Level Risk level. 0: prompt; 1: low; 2: medium; 3: high; 4: critical.Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getLevel() {
        return this.Level;
    }

    /**
     * Set Risk level. 0: prompt; 1: low; 2: medium; 3: high; 4: critical.Note: This field may return null, indicating that no valid values can be obtained.
     * @param Level Risk level. 0: prompt; 1: low; 2: medium; 3: high; 4: critical.Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setLevel(Long Level) {
        this.Level = Level;
    }

    /**
     * Get Trojan detection platforms, separated with commas. 1: cloud security engine; 2: TAV; 3: BinaryAI; 4: abnormal behavior; 5: threat intelligence.Note: This field may return null, indicating that no valid values can be obtained. 
     * @return CheckPlatform Trojan detection platforms, separated with commas. 1: cloud security engine; 2: TAV; 3: BinaryAI; 4: abnormal behavior; 5: threat intelligence.Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String getCheckPlatform() {
        return this.CheckPlatform;
    }

    /**
     * Set Trojan detection platforms, separated with commas. 1: cloud security engine; 2: TAV; 3: BinaryAI; 4: abnormal behavior; 5: threat intelligence.Note: This field may return null, indicating that no valid values can be obtained.
     * @param CheckPlatform Trojan detection platforms, separated with commas. 1: cloud security engine; 2: TAV; 3: BinaryAI; 4: abnormal behavior; 5: threat intelligence.Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setCheckPlatform(String CheckPlatform) {
        this.CheckPlatform = CheckPlatform;
    }

    /**
     * Get Host UUID
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return Uuid Host UUID
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String getUuid() {
        return this.Uuid;
    }

    /**
     * Set Host UUID
Note: This field may return null, indicating that no valid values can be obtained.
     * @param Uuid Host UUID
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setUuid(String Uuid) {
        this.Uuid = Uuid;
    }

    /**
     * Get Last modification time
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return ModifyTime Last modification time
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String getModifyTime() {
        return this.ModifyTime;
    }

    /**
     * Set Last modification time
Note: This field may return null, indicating that no valid values can be obtained.
     * @param ModifyTime Last modification time
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setModifyTime(String ModifyTime) {
        this.ModifyTime = ModifyTime;
    }

    /**
     * Get Last access time
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return StrFileAccessTime Last access time
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String getStrFileAccessTime() {
        return this.StrFileAccessTime;
    }

    /**
     * Set Last access time
Note: This field may return null, indicating that no valid values can be obtained.
     * @param StrFileAccessTime Last access time
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setStrFileAccessTime(String StrFileAccessTime) {
        this.StrFileAccessTime = StrFileAccessTime;
    }

    /**
     * Get Additional information
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return MachineExtraInfo Additional information
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public MachineExtraInfo getMachineExtraInfo() {
        return this.MachineExtraInfo;
    }

    /**
     * Set Additional information
Note: This field may return null, indicating that no valid values can be obtained.
     * @param MachineExtraInfo Additional information
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setMachineExtraInfo(MachineExtraInfo MachineExtraInfo) {
        this.MachineExtraInfo = MachineExtraInfo;
    }

    public MalwareInfo() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public MalwareInfo(MalwareInfo source) {
        if (source.VirusName != null) {
            this.VirusName = new String(source.VirusName);
        }
        if (source.FileSize != null) {
            this.FileSize = new Long(source.FileSize);
        }
        if (source.MD5 != null) {
            this.MD5 = new String(source.MD5);
        }
        if (source.FilePath != null) {
            this.FilePath = new String(source.FilePath);
        }
        if (source.FileCreateTime != null) {
            this.FileCreateTime = new String(source.FileCreateTime);
        }
        if (source.FileModifierTime != null) {
            this.FileModifierTime = new String(source.FileModifierTime);
        }
        if (source.HarmDescribe != null) {
            this.HarmDescribe = new String(source.HarmDescribe);
        }
        if (source.SuggestScheme != null) {
            this.SuggestScheme = new String(source.SuggestScheme);
        }
        if (source.ServersName != null) {
            this.ServersName = new String(source.ServersName);
        }
        if (source.HostIp != null) {
            this.HostIp = new String(source.HostIp);
        }
        if (source.ProcessName != null) {
            this.ProcessName = new String(source.ProcessName);
        }
        if (source.ProcessID != null) {
            this.ProcessID = new String(source.ProcessID);
        }
        if (source.Tags != null) {
            this.Tags = new String[source.Tags.length];
            for (int i = 0; i < source.Tags.length; i++) {
                this.Tags[i] = new String(source.Tags[i]);
            }
        }
        if (source.Breadth != null) {
            this.Breadth = new String(source.Breadth);
        }
        if (source.Heat != null) {
            this.Heat = new String(source.Heat);
        }
        if (source.Id != null) {
            this.Id = new Long(source.Id);
        }
        if (source.FileName != null) {
            this.FileName = new String(source.FileName);
        }
        if (source.CreateTime != null) {
            this.CreateTime = new String(source.CreateTime);
        }
        if (source.LatestScanTime != null) {
            this.LatestScanTime = new String(source.LatestScanTime);
        }
        if (source.Reference != null) {
            this.Reference = new String(source.Reference);
        }
        if (source.MachineWanIp != null) {
            this.MachineWanIp = new String(source.MachineWanIp);
        }
        if (source.PsTree != null) {
            this.PsTree = new String(source.PsTree);
        }
        if (source.MachineStatus != null) {
            this.MachineStatus = new String(source.MachineStatus);
        }
        if (source.Status != null) {
            this.Status = new Long(source.Status);
        }
        if (source.Level != null) {
            this.Level = new Long(source.Level);
        }
        if (source.CheckPlatform != null) {
            this.CheckPlatform = new String(source.CheckPlatform);
        }
        if (source.Uuid != null) {
            this.Uuid = new String(source.Uuid);
        }
        if (source.ModifyTime != null) {
            this.ModifyTime = new String(source.ModifyTime);
        }
        if (source.StrFileAccessTime != null) {
            this.StrFileAccessTime = new String(source.StrFileAccessTime);
        }
        if (source.MachineExtraInfo != null) {
            this.MachineExtraInfo = new MachineExtraInfo(source.MachineExtraInfo);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "VirusName", this.VirusName);
        this.setParamSimple(map, prefix + "FileSize", this.FileSize);
        this.setParamSimple(map, prefix + "MD5", this.MD5);
        this.setParamSimple(map, prefix + "FilePath", this.FilePath);
        this.setParamSimple(map, prefix + "FileCreateTime", this.FileCreateTime);
        this.setParamSimple(map, prefix + "FileModifierTime", this.FileModifierTime);
        this.setParamSimple(map, prefix + "HarmDescribe", this.HarmDescribe);
        this.setParamSimple(map, prefix + "SuggestScheme", this.SuggestScheme);
        this.setParamSimple(map, prefix + "ServersName", this.ServersName);
        this.setParamSimple(map, prefix + "HostIp", this.HostIp);
        this.setParamSimple(map, prefix + "ProcessName", this.ProcessName);
        this.setParamSimple(map, prefix + "ProcessID", this.ProcessID);
        this.setParamArraySimple(map, prefix + "Tags.", this.Tags);
        this.setParamSimple(map, prefix + "Breadth", this.Breadth);
        this.setParamSimple(map, prefix + "Heat", this.Heat);
        this.setParamSimple(map, prefix + "Id", this.Id);
        this.setParamSimple(map, prefix + "FileName", this.FileName);
        this.setParamSimple(map, prefix + "CreateTime", this.CreateTime);
        this.setParamSimple(map, prefix + "LatestScanTime", this.LatestScanTime);
        this.setParamSimple(map, prefix + "Reference", this.Reference);
        this.setParamSimple(map, prefix + "MachineWanIp", this.MachineWanIp);
        this.setParamSimple(map, prefix + "PsTree", this.PsTree);
        this.setParamSimple(map, prefix + "MachineStatus", this.MachineStatus);
        this.setParamSimple(map, prefix + "Status", this.Status);
        this.setParamSimple(map, prefix + "Level", this.Level);
        this.setParamSimple(map, prefix + "CheckPlatform", this.CheckPlatform);
        this.setParamSimple(map, prefix + "Uuid", this.Uuid);
        this.setParamSimple(map, prefix + "ModifyTime", this.ModifyTime);
        this.setParamSimple(map, prefix + "StrFileAccessTime", this.StrFileAccessTime);
        this.setParamObj(map, prefix + "MachineExtraInfo.", this.MachineExtraInfo);

    }
}

