/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class MalwareRiskOverview extends AbstractModel {

    /**
    * Number of affected hosts
    */
    @SerializedName("HostCount")
    @Expose
    private Long HostCount;

    /**
    * Exceptional Process Count
    */
    @SerializedName("ProcessCount")
    @Expose
    private Long ProcessCount;

    /**
    * Number of Malicious Files
    */
    @SerializedName("FileCount")
    @Expose
    private Long FileCount;

    /**
    * Is it the first Scan [false: No | true: Yes].
    */
    @SerializedName("IsFirstScan")
    @Expose
    private Boolean IsFirstScan;

    /**
    * Last scan time
    */
    @SerializedName("ScanTime")
    @Expose
    private String ScanTime;

    /**
     * Get Number of affected hosts 
     * @return HostCount Number of affected hosts
     */
    public Long getHostCount() {
        return this.HostCount;
    }

    /**
     * Set Number of affected hosts
     * @param HostCount Number of affected hosts
     */
    public void setHostCount(Long HostCount) {
        this.HostCount = HostCount;
    }

    /**
     * Get Exceptional Process Count 
     * @return ProcessCount Exceptional Process Count
     */
    public Long getProcessCount() {
        return this.ProcessCount;
    }

    /**
     * Set Exceptional Process Count
     * @param ProcessCount Exceptional Process Count
     */
    public void setProcessCount(Long ProcessCount) {
        this.ProcessCount = ProcessCount;
    }

    /**
     * Get Number of Malicious Files 
     * @return FileCount Number of Malicious Files
     */
    public Long getFileCount() {
        return this.FileCount;
    }

    /**
     * Set Number of Malicious Files
     * @param FileCount Number of Malicious Files
     */
    public void setFileCount(Long FileCount) {
        this.FileCount = FileCount;
    }

    /**
     * Get Is it the first Scan [false: No | true: Yes]. 
     * @return IsFirstScan Is it the first Scan [false: No | true: Yes].
     */
    public Boolean getIsFirstScan() {
        return this.IsFirstScan;
    }

    /**
     * Set Is it the first Scan [false: No | true: Yes].
     * @param IsFirstScan Is it the first Scan [false: No | true: Yes].
     */
    public void setIsFirstScan(Boolean IsFirstScan) {
        this.IsFirstScan = IsFirstScan;
    }

    /**
     * Get Last scan time 
     * @return ScanTime Last scan time
     */
    public String getScanTime() {
        return this.ScanTime;
    }

    /**
     * Set Last scan time
     * @param ScanTime Last scan time
     */
    public void setScanTime(String ScanTime) {
        this.ScanTime = ScanTime;
    }

    public MalwareRiskOverview() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public MalwareRiskOverview(MalwareRiskOverview source) {
        if (source.HostCount != null) {
            this.HostCount = new Long(source.HostCount);
        }
        if (source.ProcessCount != null) {
            this.ProcessCount = new Long(source.ProcessCount);
        }
        if (source.FileCount != null) {
            this.FileCount = new Long(source.FileCount);
        }
        if (source.IsFirstScan != null) {
            this.IsFirstScan = new Boolean(source.IsFirstScan);
        }
        if (source.ScanTime != null) {
            this.ScanTime = new String(source.ScanTime);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "HostCount", this.HostCount);
        this.setParamSimple(map, prefix + "ProcessCount", this.ProcessCount);
        this.setParamSimple(map, prefix + "FileCount", this.FileCount);
        this.setParamSimple(map, prefix + "IsFirstScan", this.IsFirstScan);
        this.setParamSimple(map, prefix + "ScanTime", this.ScanTime);

    }
}

