/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class MalwareWhiteListInfo extends AbstractModel {

    /**
    * Unique ID
    */
    @SerializedName("Id")
    @Expose
    private Long Id;

    /**
    * CVM QUUID (Separate multiple items with commas.)
    */
    @SerializedName("QuuidList")
    @Expose
    private String QuuidList;

    /**
    * md5 list (Separate multiple items with commas.)
    */
    @SerializedName("Md5List")
    @Expose
    private String Md5List;

    /**
    * Whether applies all hosts: 0 - no; 1 - yes
    */
    @SerializedName("IsGlobal")
    @Expose
    private Long IsGlobal;

    /**
    * Allowlist mode: 0 - MD5; 1 - customization
    */
    @SerializedName("Mode")
    @Expose
    private Long Mode;

    /**
    * Match mode: 0 - precise match; 1 - fuzzy match
    */
    @SerializedName("MatchType")
    @Expose
    private Long MatchType;

    /**
    * File name (Separate multiple items with commas.)
    */
    @SerializedName("FileName")
    @Expose
    private String FileName;

    /**
    * File directory (Separate multiple items with commas.)
    */
    @SerializedName("FileDirectory")
    @Expose
    private String FileDirectory;

    /**
    * File suffix (Separate multiple items with commas.)
    */
    @SerializedName("FileExtension")
    @Expose
    private String FileExtension;

    /**
    * Rule creation time
    */
    @SerializedName("CreateTime")
    @Expose
    private String CreateTime;

    /**
    * Affected records
    */
    @SerializedName("EventsCount")
    @Expose
    private Long EventsCount;

    /**
     * Get Unique ID 
     * @return Id Unique ID
     */
    public Long getId() {
        return this.Id;
    }

    /**
     * Set Unique ID
     * @param Id Unique ID
     */
    public void setId(Long Id) {
        this.Id = Id;
    }

    /**
     * Get CVM QUUID (Separate multiple items with commas.) 
     * @return QuuidList CVM QUUID (Separate multiple items with commas.)
     */
    public String getQuuidList() {
        return this.QuuidList;
    }

    /**
     * Set CVM QUUID (Separate multiple items with commas.)
     * @param QuuidList CVM QUUID (Separate multiple items with commas.)
     */
    public void setQuuidList(String QuuidList) {
        this.QuuidList = QuuidList;
    }

    /**
     * Get md5 list (Separate multiple items with commas.) 
     * @return Md5List md5 list (Separate multiple items with commas.)
     */
    public String getMd5List() {
        return this.Md5List;
    }

    /**
     * Set md5 list (Separate multiple items with commas.)
     * @param Md5List md5 list (Separate multiple items with commas.)
     */
    public void setMd5List(String Md5List) {
        this.Md5List = Md5List;
    }

    /**
     * Get Whether applies all hosts: 0 - no; 1 - yes 
     * @return IsGlobal Whether applies all hosts: 0 - no; 1 - yes
     */
    public Long getIsGlobal() {
        return this.IsGlobal;
    }

    /**
     * Set Whether applies all hosts: 0 - no; 1 - yes
     * @param IsGlobal Whether applies all hosts: 0 - no; 1 - yes
     */
    public void setIsGlobal(Long IsGlobal) {
        this.IsGlobal = IsGlobal;
    }

    /**
     * Get Allowlist mode: 0 - MD5; 1 - customization 
     * @return Mode Allowlist mode: 0 - MD5; 1 - customization
     */
    public Long getMode() {
        return this.Mode;
    }

    /**
     * Set Allowlist mode: 0 - MD5; 1 - customization
     * @param Mode Allowlist mode: 0 - MD5; 1 - customization
     */
    public void setMode(Long Mode) {
        this.Mode = Mode;
    }

    /**
     * Get Match mode: 0 - precise match; 1 - fuzzy match 
     * @return MatchType Match mode: 0 - precise match; 1 - fuzzy match
     */
    public Long getMatchType() {
        return this.MatchType;
    }

    /**
     * Set Match mode: 0 - precise match; 1 - fuzzy match
     * @param MatchType Match mode: 0 - precise match; 1 - fuzzy match
     */
    public void setMatchType(Long MatchType) {
        this.MatchType = MatchType;
    }

    /**
     * Get File name (Separate multiple items with commas.) 
     * @return FileName File name (Separate multiple items with commas.)
     */
    public String getFileName() {
        return this.FileName;
    }

    /**
     * Set File name (Separate multiple items with commas.)
     * @param FileName File name (Separate multiple items with commas.)
     */
    public void setFileName(String FileName) {
        this.FileName = FileName;
    }

    /**
     * Get File directory (Separate multiple items with commas.) 
     * @return FileDirectory File directory (Separate multiple items with commas.)
     */
    public String getFileDirectory() {
        return this.FileDirectory;
    }

    /**
     * Set File directory (Separate multiple items with commas.)
     * @param FileDirectory File directory (Separate multiple items with commas.)
     */
    public void setFileDirectory(String FileDirectory) {
        this.FileDirectory = FileDirectory;
    }

    /**
     * Get File suffix (Separate multiple items with commas.) 
     * @return FileExtension File suffix (Separate multiple items with commas.)
     */
    public String getFileExtension() {
        return this.FileExtension;
    }

    /**
     * Set File suffix (Separate multiple items with commas.)
     * @param FileExtension File suffix (Separate multiple items with commas.)
     */
    public void setFileExtension(String FileExtension) {
        this.FileExtension = FileExtension;
    }

    /**
     * Get Rule creation time 
     * @return CreateTime Rule creation time
     */
    public String getCreateTime() {
        return this.CreateTime;
    }

    /**
     * Set Rule creation time
     * @param CreateTime Rule creation time
     */
    public void setCreateTime(String CreateTime) {
        this.CreateTime = CreateTime;
    }

    /**
     * Get Affected records 
     * @return EventsCount Affected records
     */
    public Long getEventsCount() {
        return this.EventsCount;
    }

    /**
     * Set Affected records
     * @param EventsCount Affected records
     */
    public void setEventsCount(Long EventsCount) {
        this.EventsCount = EventsCount;
    }

    public MalwareWhiteListInfo() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public MalwareWhiteListInfo(MalwareWhiteListInfo source) {
        if (source.Id != null) {
            this.Id = new Long(source.Id);
        }
        if (source.QuuidList != null) {
            this.QuuidList = new String(source.QuuidList);
        }
        if (source.Md5List != null) {
            this.Md5List = new String(source.Md5List);
        }
        if (source.IsGlobal != null) {
            this.IsGlobal = new Long(source.IsGlobal);
        }
        if (source.Mode != null) {
            this.Mode = new Long(source.Mode);
        }
        if (source.MatchType != null) {
            this.MatchType = new Long(source.MatchType);
        }
        if (source.FileName != null) {
            this.FileName = new String(source.FileName);
        }
        if (source.FileDirectory != null) {
            this.FileDirectory = new String(source.FileDirectory);
        }
        if (source.FileExtension != null) {
            this.FileExtension = new String(source.FileExtension);
        }
        if (source.CreateTime != null) {
            this.CreateTime = new String(source.CreateTime);
        }
        if (source.EventsCount != null) {
            this.EventsCount = new Long(source.EventsCount);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Id", this.Id);
        this.setParamSimple(map, prefix + "QuuidList", this.QuuidList);
        this.setParamSimple(map, prefix + "Md5List", this.Md5List);
        this.setParamSimple(map, prefix + "IsGlobal", this.IsGlobal);
        this.setParamSimple(map, prefix + "Mode", this.Mode);
        this.setParamSimple(map, prefix + "MatchType", this.MatchType);
        this.setParamSimple(map, prefix + "FileName", this.FileName);
        this.setParamSimple(map, prefix + "FileDirectory", this.FileDirectory);
        this.setParamSimple(map, prefix + "FileExtension", this.FileExtension);
        this.setParamSimple(map, prefix + "CreateTime", this.CreateTime);
        this.setParamSimple(map, prefix + "EventsCount", this.EventsCount);

    }
}

